// Generated by delombok at Sat Dec 14 00:27:56 UTC 2019
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Set;
import java.util.function.Consumer;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotEmpty;

/**
 * Object containing parameters for device code flow. Can be used as parameter to

 * {@link PublicClientApplication#acquireToken(DeviceCodeFlowParameters)}
 */
public class DeviceCodeFlowParameters {
    @NonNull
    private Set<String> scopes;
    @NonNull
    private Consumer<DeviceCode> deviceCodeConsumer;

    private static DeviceCodeFlowParametersBuilder builder() {
        return new DeviceCodeFlowParametersBuilder();
    }

    /**
     * Builder for {@link DeviceCodeFlowParameters}

     * @param scopes scopes application is requesting access to

     * @param deviceCodeConsumer {@link Consumer} of {@link DeviceCode}

     * @return builder that can be used to construct DeviceCodeFlowParameters
     */
    public static DeviceCodeFlowParametersBuilder builder(Set<String> scopes, Consumer<DeviceCode> deviceCodeConsumer) {
        validateNotEmpty("scopes", scopes);
        return builder().scopes(scopes).deviceCodeConsumer(deviceCodeConsumer);
    }


    @java.lang.SuppressWarnings("all")
    public static class DeviceCodeFlowParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private Consumer<DeviceCode> deviceCodeConsumer;

        @java.lang.SuppressWarnings("all")
        DeviceCodeFlowParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public DeviceCodeFlowParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public DeviceCodeFlowParametersBuilder deviceCodeConsumer(final Consumer<DeviceCode> deviceCodeConsumer) {
            this.deviceCodeConsumer = deviceCodeConsumer;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public DeviceCodeFlowParameters build() {
            return new DeviceCodeFlowParameters(scopes, deviceCodeConsumer);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder(scopes=" + this.scopes + ", deviceCodeConsumer=" + this.deviceCodeConsumer + ")";
        }
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    public Consumer<DeviceCode> deviceCodeConsumer() {
        return this.deviceCodeConsumer;
    }

    @java.lang.SuppressWarnings("all")
    private DeviceCodeFlowParameters(@NonNull final Set<String> scopes, @NonNull final Consumer<DeviceCode> deviceCodeConsumer) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        if (deviceCodeConsumer == null) {
            throw new java.lang.NullPointerException("deviceCodeConsumer is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.deviceCodeConsumer = deviceCodeConsumer;
    }
}
