/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.util.Set;
import lombok.NonNull;

public class RefreshTokenParameters {
    @NonNull
    private Set<String> scopes;
    @NonNull
    private String refreshToken;

    private static RefreshTokenParametersBuilder builder() {
        return new RefreshTokenParametersBuilder();
    }

    public static RefreshTokenParametersBuilder builder(Set<String> scopes, String refreshToken) {
        ParameterValidationUtils.validateNotBlank("refreshToken", refreshToken);
        return RefreshTokenParameters.builder().scopes(scopes).refreshToken(refreshToken);
    }

    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    public String refreshToken() {
        return this.refreshToken;
    }

    private RefreshTokenParameters(@NonNull Set<String> scopes, @NonNull String refreshToken) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.refreshToken = refreshToken;
    }

    public static class RefreshTokenParametersBuilder {
        private Set<String> scopes;
        private String refreshToken;

        RefreshTokenParametersBuilder() {
        }

        public RefreshTokenParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public RefreshTokenParametersBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public RefreshTokenParameters build() {
            return new RefreshTokenParameters(this.scopes, this.refreshToken);
        }

        public String toString() {
            return "RefreshTokenParameters.RefreshTokenParametersBuilder(scopes=" + this.scopes + ", refreshToken=" + this.refreshToken + ")";
        }
    }
}

