// Generated by delombok at Fri Nov 01 23:59:32 UTC 2019
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import com.google.gson.annotations.SerializedName;
import com.nimbusds.jose.util.StandardCharset;
import java.util.Base64;

class ClientInfo {
    @SerializedName("uid")
    private String uniqueIdentifier;
    @SerializedName("utid")
    private String unqiueTenantIdentifier;

    public static ClientInfo createFromJson(String clientInfoJsonBase64Encoded) {
        if (StringHelper.isBlank(clientInfoJsonBase64Encoded)) {
            return null;
        }
        byte[] decodedInput = Base64.getDecoder().decode(clientInfoJsonBase64Encoded.getBytes(StandardCharset.UTF_8));
        return JsonHelper.convertJsonToObject(new String(decodedInput, StandardCharset.UTF_8), ClientInfo.class);
    }

    String toAccountIdentifier() {
        return uniqueIdentifier + "." + unqiueTenantIdentifier;
    }

    @java.lang.SuppressWarnings("all")
    String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @java.lang.SuppressWarnings("all")
    String getUnqiueTenantIdentifier() {
        return this.unqiueTenantIdentifier;
    }
}
