/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.util.Arrays;
import java.util.Set;
import lombok.NonNull;

public class UserNamePasswordParameters {
    @NonNull
    private Set<String> scopes;
    @NonNull
    private String username;
    @NonNull
    private char[] password;

    public char[] password() {
        return (char[])this.password.clone();
    }

    private static UserNamePasswordParametersBuilder builder() {
        return new UserNamePasswordParametersBuilder();
    }

    public static UserNamePasswordParametersBuilder builder(Set<String> scopes, String username, char[] password) {
        ParameterValidationUtils.validateNotEmpty("scopes", scopes);
        ParameterValidationUtils.validateNotBlank("username", username);
        ParameterValidationUtils.validateNotEmpty("password", password);
        return UserNamePasswordParameters.builder().scopes(scopes).username(username).password(password);
    }

    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    public String username() {
        return this.username;
    }

    private UserNamePasswordParameters(@NonNull Set<String> scopes, @NonNull String username, @NonNull char[] password) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked @NonNull but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.username = username;
        this.password = password;
    }

    public static class UserNamePasswordParametersBuilder {
        private Set<String> scopes;
        private String username;
        private char[] password;

        public UserNamePasswordParametersBuilder password(char[] password) {
            this.password = (char[])password.clone();
            return this;
        }

        UserNamePasswordParametersBuilder() {
        }

        public UserNamePasswordParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public UserNamePasswordParametersBuilder username(String username) {
            this.username = username;
            return this;
        }

        public UserNamePasswordParameters build() {
            return new UserNamePasswordParameters(this.scopes, this.username, this.password);
        }

        public String toString() {
            return "UserNamePasswordParameters.UserNamePasswordParametersBuilder(scopes=" + this.scopes + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ")";
        }
    }
}

