/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AsymmetricKeyCredential;
import com.microsoft.aad.msal4j.ClientApplicationBase;
import com.microsoft.aad.msal4j.ClientAssertion;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ClientCredentialRequest;
import com.microsoft.aad.msal4j.ClientSecret;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IConfidentialClientApplication;
import com.microsoft.aad.msal4j.JwtHelper;
import com.microsoft.aad.msal4j.MsalClientException;
import com.microsoft.aad.msal4j.OnBehalfOfParameters;
import com.microsoft.aad.msal4j.OnBehalfOfRequest;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import com.microsoft.aad.msal4j.PublicApi;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.LoggerFactory;

public class ConfidentialClientApplication
extends ClientApplicationBase
implements IConfidentialClientApplication {
    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(ClientCredentialParameters parameters) {
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        ClientCredentialRequest clientCredentialRequest = new ClientCredentialRequest(parameters, this, this.createRequestContext(PublicApi.ACQUIRE_TOKEN_FOR_CLIENT));
        return this.executeRequest(clientCredentialRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(OnBehalfOfParameters parameters) {
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        OnBehalfOfRequest oboRequest = new OnBehalfOfRequest(parameters, this, this.createRequestContext(PublicApi.ACQUIRE_TOKEN_ON_BEHALF_OF));
        return this.executeRequest(oboRequest);
    }

    private ConfidentialClientApplication(Builder builder) {
        super(builder);
        this.log = LoggerFactory.getLogger(ConfidentialClientApplication.class);
        this.initClientAuthentication(builder.clientCredential);
    }

    private void initClientAuthentication(IClientCredential clientCredential) {
        ParameterValidationUtils.validateNotNull("clientCredential", clientCredential);
        if (clientCredential instanceof ClientSecret) {
            this.clientAuthentication = new ClientSecretPost(new ClientID(this.clientId()), new Secret(((ClientSecret)clientCredential).clientSecret()));
        } else if (clientCredential instanceof AsymmetricKeyCredential) {
            ClientAssertion clientAssertion = JwtHelper.buildJwt(this.clientId(), (AsymmetricKeyCredential)clientCredential, this.authenticationAuthority.selfSignedJwtAudience());
            this.clientAuthentication = this.createClientAuthFromClientAssertion(clientAssertion);
        } else {
            throw new IllegalArgumentException("Unsupported client credential");
        }
    }

    private ClientAuthentication createClientAuthFromClientAssertion(ClientAssertion clientAssertion) {
        try {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            map.put("client_assertion_type", Collections.singletonList("urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
            map.put("client_assertion", Collections.singletonList(clientAssertion.assertion()));
            return PrivateKeyJWT.parse(map);
        }
        catch (ParseException e) {
            throw new MsalClientException(e);
        }
    }

    public static Builder builder(String clientId, IClientCredential clientCredential) {
        return new Builder(clientId, clientCredential);
    }

    public static class Builder
    extends ClientApplicationBase.Builder<Builder> {
        private IClientCredential clientCredential;

        Builder(String clientId, IClientCredential clientCredential) {
            super(clientId);
            this.clientCredential = clientCredential;
        }

        @Override
        public ConfidentialClientApplication build() {
            return new ConfidentialClientApplication(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

