/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.RequestContext;
import com.microsoft.aad.msal4j.StringHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

final class ClientDataHttpHeaders {
    public static final String PRODUCT_HEADER_NAME = "x-client-SKU";
    public static final String PRODUCT_HEADER_VALUE = "MSAL.Java";
    public static final String PRODUCT_VERSION_HEADER_NAME = "x-client-VER";
    public static final String PRODUCT_VERSION_HEADER_VALUE = ClientDataHttpHeaders.getProductVersion();
    public static final String CPU_HEADER_NAME = "x-client-CPU";
    public static final String CPU_HEADER_VALUE = System.getProperty("os.arch");
    public static final String OS_HEADER_NAME = "x-client-OS";
    public static final String OS_HEADER_VALUE = System.getProperty("os.name");
    public static final String CORRELATION_ID_HEADER_NAME = "client-request-id";
    public final String correlationIdHeaderValue;
    public static final String REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_NAME = "return-client-request-id";
    public static final String REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_VALUE = "true";
    private final String headerValues;
    private final Map<String, String> headerMap = new HashMap<String, String>();

    ClientDataHttpHeaders(String correlationId) {
        this.correlationIdHeaderValue = !StringHelper.isBlank(correlationId) ? correlationId : RequestContext.generateNewCorrelationId();
        this.headerValues = this.initHeaderMap();
    }

    private String initHeaderMap() {
        StringBuilder sb = new StringBuilder();
        BiConsumer<String, String> init = (key, val) -> {
            this.headerMap.put((String)key, (String)val);
            sb.append((String)key).append("=").append((String)val).append(";");
        };
        init.accept(PRODUCT_HEADER_NAME, PRODUCT_HEADER_VALUE);
        init.accept(PRODUCT_VERSION_HEADER_NAME, PRODUCT_VERSION_HEADER_VALUE);
        init.accept(OS_HEADER_NAME, OS_HEADER_VALUE);
        init.accept(CPU_HEADER_NAME, CPU_HEADER_VALUE);
        init.accept(REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_NAME, REQUEST_CORRELATION_ID_IN_RESPONSE_HEADER_VALUE);
        init.accept(CORRELATION_ID_HEADER_NAME, this.correlationIdHeaderValue);
        return sb.toString();
    }

    Map<String, String> getReadonlyHeaderMap() {
        return Collections.unmodifiableMap(this.headerMap);
    }

    String getHeaderCorrelationIdValue() {
        return this.correlationIdHeaderValue;
    }

    public String toString() {
        return this.headerValues;
    }

    private static String getProductVersion() {
        if (ClientDataHttpHeaders.class.getPackage().getImplementationVersion() == null) {
            return "1.0";
        }
        return ClientDataHttpHeaders.class.getPackage().getImplementationVersion();
    }
}

