/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AADAuthority;
import com.microsoft.aad.msal4j.AadInstanceDiscovery;
import com.microsoft.aad.msal4j.AccountsSupplier;
import com.microsoft.aad.msal4j.AcquireTokenByAuthorizationGrantSupplier;
import com.microsoft.aad.msal4j.AcquireTokenByDeviceCodeFlowSupplier;
import com.microsoft.aad.msal4j.AcquireTokenSilentSupplier;
import com.microsoft.aad.msal4j.AuthenticationException;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import com.microsoft.aad.msal4j.Authority;
import com.microsoft.aad.msal4j.AuthorityType;
import com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import com.microsoft.aad.msal4j.AuthorizationCodeRequest;
import com.microsoft.aad.msal4j.B2CAuthority;
import com.microsoft.aad.msal4j.ClientDataHttpHeaders;
import com.microsoft.aad.msal4j.DeviceCodeFlowRequest;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientApplicationBase;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import com.microsoft.aad.msal4j.LogHelper;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import com.microsoft.aad.msal4j.PublicApi;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.RefreshTokenParameters;
import com.microsoft.aad.msal4j.RefreshTokenRequest;
import com.microsoft.aad.msal4j.RemoveAccountRunnable;
import com.microsoft.aad.msal4j.RequestContext;
import com.microsoft.aad.msal4j.ServiceBundle;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.aad.msal4j.SilentRequest;
import com.microsoft.aad.msal4j.TelemetryManager;
import com.microsoft.aad.msal4j.TokenCache;
import com.microsoft.aad.msal4j.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;

abstract class ClientApplicationBase
implements IClientApplicationBase {
    protected Logger log;
    protected ClientAuthentication clientAuthentication;
    private String clientId;
    private String authority;
    protected Authority authenticationAuthority;
    private boolean validateAuthority;
    private String correlationId;
    private boolean logPii;
    private ServiceBundle serviceBundle;
    private Consumer<List<HashMap<String, String>>> telemetryConsumer;
    protected TokenCache tokenCache;

    @Override
    public Proxy proxy() {
        return this.serviceBundle.getProxy();
    }

    @Override
    public SSLSocketFactory sslSocketFactory() {
        return this.serviceBundle.getSslSocketFactory();
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(AuthorizationCodeParameters parameters) {
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        AuthorizationCodeRequest authorizationCodeRequest = new AuthorizationCodeRequest(parameters, this, this.createRequestContext(PublicApi.ACQUIRE_TOKEN_BY_AUTHORIZATION_CODE));
        return this.executeRequest(authorizationCodeRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(RefreshTokenParameters parameters) {
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        RefreshTokenRequest refreshTokenRequest = new RefreshTokenRequest(parameters, this, this.createRequestContext(PublicApi.ACQUIRE_TOKEN_BY_REFRESH_TOKEN));
        return this.executeRequest(refreshTokenRequest);
    }

    CompletableFuture<IAuthenticationResult> executeRequest(MsalRequest msalRequest) {
        AuthenticationResultSupplier supplier = this.getAuthenticationResultSupplier(msalRequest);
        ExecutorService executorService = this.serviceBundle.getExecutorService();
        CompletableFuture<IAuthenticationResult> future = executorService != null ? CompletableFuture.supplyAsync(supplier, executorService) : CompletableFuture.supplyAsync(supplier);
        return future;
    }

    AuthenticationResult acquireTokenCommon(MsalRequest msalRequest, Authority requestAuthority) throws Exception {
        ClientDataHttpHeaders headers = msalRequest.headers();
        if (this.logPii) {
            this.log.debug(LogHelper.createMessage(String.format("Using Client Http Headers: %s", headers), headers.getHeaderCorrelationIdValue()));
        }
        URL url = new URL(requestAuthority.tokenEndpoint());
        TokenRequest request = new TokenRequest(url, msalRequest, this.serviceBundle);
        AuthenticationResult result = request.executeOauthRequestAndProcessResponse();
        if (this.authenticationAuthority.authorityType.equals((Object)AuthorityType.B2C)) {
            this.tokenCache.saveTokens(request, result, this.authenticationAuthority.host);
        } else {
            InstanceDiscoveryMetadataEntry instanceDiscoveryMetadata = AadInstanceDiscovery.GetMetadataEntry(url, this.validateAuthority, msalRequest, this.serviceBundle);
            this.tokenCache.saveTokens(request, result, instanceDiscoveryMetadata.preferredCache);
        }
        return result;
    }

    private AuthenticationResultSupplier getAuthenticationResultSupplier(MsalRequest msalRequest) {
        AuthenticationResultSupplier supplier = msalRequest instanceof DeviceCodeFlowRequest ? new AcquireTokenByDeviceCodeFlowSupplier((PublicClientApplication)this, (DeviceCodeFlowRequest)msalRequest) : (msalRequest instanceof SilentRequest ? new AcquireTokenSilentSupplier(this, (SilentRequest)msalRequest) : new AcquireTokenByAuthorizationGrantSupplier(this, msalRequest, null));
        return supplier;
    }

    RequestContext createRequestContext(PublicApi publicApi) {
        return new RequestContext(this.clientId, this.correlationId(), publicApi);
    }

    ServiceBundle getServiceBundle() {
        return this.serviceBundle;
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireTokenSilently(SilentParameters parameters) throws MalformedURLException {
        ParameterValidationUtils.validateNotNull("parameters", parameters);
        SilentRequest silentRequest = new SilentRequest(parameters, this, this.createRequestContext(PublicApi.ACQUIRE_TOKEN_SILENTLY));
        return this.executeRequest(silentRequest);
    }

    @Override
    public CompletableFuture<Set<IAccount>> getAccounts() {
        MsalRequest msalRequest = new MsalRequest(this, null, this.createRequestContext(PublicApi.GET_ACCOUNTS)){};
        AccountsSupplier supplier = new AccountsSupplier(this, msalRequest);
        CompletableFuture<Set<IAccount>> future = this.serviceBundle.getExecutorService() != null ? CompletableFuture.supplyAsync(supplier, this.serviceBundle.getExecutorService()) : CompletableFuture.supplyAsync(supplier);
        return future;
    }

    @Override
    public CompletableFuture removeAccount(IAccount account) {
        RemoveAccountRunnable runnable = new RemoveAccountRunnable(this, account);
        CompletableFuture<Void> future = this.serviceBundle.getExecutorService() != null ? CompletableFuture.runAsync(runnable, this.serviceBundle.getExecutorService()) : CompletableFuture.runAsync(runnable);
        return future;
    }

    protected static String canonicalizeUrl(String authority) {
        if (!(authority = authority.toLowerCase()).endsWith("/")) {
            authority = authority + "/";
        }
        return authority;
    }

    ClientApplicationBase(Builder<?> builder) {
        this.clientId = ((Builder)builder).clientId;
        this.authority = ((Builder)builder).authority;
        this.validateAuthority = ((Builder)builder).validateAuthority;
        this.correlationId = ((Builder)builder).correlationId;
        this.logPii = ((Builder)builder).logPii;
        this.telemetryConsumer = ((Builder)builder).telemetryConsumer;
        this.serviceBundle = new ServiceBundle(((Builder)builder).executorService, ((Builder)builder).proxy, ((Builder)builder).sslSocketFactory, new TelemetryManager(this.telemetryConsumer, ((Builder)builder).onlySendFailureTelemetry));
        this.authenticationAuthority = ((Builder)builder).authenticationAuthority;
        this.tokenCache = new TokenCache(((Builder)builder).tokenCacheAccessAspect);
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public String authority() {
        return this.authority;
    }

    @Override
    public boolean validateAuthority() {
        return this.validateAuthority;
    }

    @Override
    public String correlationId() {
        return this.correlationId;
    }

    @Override
    public boolean logPii() {
        return this.logPii;
    }

    @Override
    public Consumer<List<HashMap<String, String>>> telemetryConsumer() {
        return this.telemetryConsumer;
    }

    @Override
    public TokenCache tokenCache() {
        return this.tokenCache;
    }

    static abstract class Builder<T extends Builder<T>> {
        private String clientId;
        private String authority = "https://login.microsoftonline.com/common/";
        private Authority authenticationAuthority = Builder.createDefaultAADAuthority();
        private boolean validateAuthority = true;
        private String correlationId = UUID.randomUUID().toString();
        private boolean logPii = false;
        private ExecutorService executorService;
        private Proxy proxy;
        private SSLSocketFactory sslSocketFactory;
        private Consumer<List<HashMap<String, String>>> telemetryConsumer;
        private Boolean onlySendFailureTelemetry = false;
        private ITokenCacheAccessAspect tokenCacheAccessAspect;

        public Builder(String clientId) {
            ParameterValidationUtils.validateNotBlank("clientId", clientId);
            this.clientId = clientId;
        }

        abstract T self();

        public T authority(String val) throws MalformedURLException {
            this.authority = ClientApplicationBase.canonicalizeUrl(val);
            if (Authority.detectAuthorityType(new URL(this.authority)) != AuthorityType.AAD) {
                throw new IllegalArgumentException("Unsupported authority type. Please use AAD authority");
            }
            this.authenticationAuthority = new AADAuthority(new URL(this.authority));
            return this.self();
        }

        public T b2cAuthority(String val) throws MalformedURLException {
            this.authority = ClientApplicationBase.canonicalizeUrl(val);
            if (Authority.detectAuthorityType(new URL(this.authority)) != AuthorityType.B2C) {
                throw new IllegalArgumentException("Unsupported authority type. Please use B2C authority");
            }
            this.authenticationAuthority = new B2CAuthority(new URL(this.authority));
            this.validateAuthority = false;
            return this.self();
        }

        public T validateAuthority(boolean val) {
            this.validateAuthority = val;
            return this.self();
        }

        public T correlationId(String val) {
            ParameterValidationUtils.validateNotBlank("correlationId", val);
            this.correlationId = val;
            return this.self();
        }

        public T logPii(boolean val) {
            this.logPii = val;
            return this.self();
        }

        public T executorService(ExecutorService val) {
            ParameterValidationUtils.validateNotNull("executorService", val);
            this.executorService = val;
            return this.self();
        }

        public T proxy(Proxy val) {
            ParameterValidationUtils.validateNotNull("proxy", val);
            this.proxy = val;
            return this.self();
        }

        public T sslSocketFactory(SSLSocketFactory val) {
            ParameterValidationUtils.validateNotNull("sslSocketFactory", val);
            this.sslSocketFactory = val;
            return this.self();
        }

        public T telemetryConsumer(Consumer<List<HashMap<String, String>>> val) {
            ParameterValidationUtils.validateNotNull("telemetryConsumer", val);
            this.telemetryConsumer = val;
            return this.self();
        }

        public T onlySendFailureTelemetry(Boolean val) {
            this.onlySendFailureTelemetry = val;
            return this.self();
        }

        public T setTokenCacheAccessAspect(ITokenCacheAccessAspect val) {
            ParameterValidationUtils.validateNotNull("tokenCacheAccessAspect", val);
            this.tokenCacheAccessAspect = val;
            return this.self();
        }

        private static Authority createDefaultAADAuthority() {
            AADAuthority authority;
            try {
                authority = new AADAuthority(new URL("https://login.microsoftonline.com/common/"));
            }
            catch (Exception e) {
                throw new AuthenticationException(e);
            }
            return authority;
        }

        abstract ClientApplicationBase build();
    }
}

