/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.google.gson.annotations.SerializedName;
import com.microsoft.aad.msal4j.JsonHelper;
import com.microsoft.aad.msal4j.StringHelper;
import java.util.Base64;

class ClientInfo {
    @SerializedName(value="uid")
    private String uniqueIdentifier;
    @SerializedName(value="utid")
    private String unqiueTenantIdentifier;

    ClientInfo() {
    }

    public static ClientInfo createFromJson(String clientInfoJsonBase64Encoded) {
        if (StringHelper.isBlank(clientInfoJsonBase64Encoded)) {
            return null;
        }
        byte[] decodedInput = Base64.getDecoder().decode(clientInfoJsonBase64Encoded.getBytes());
        return JsonHelper.convertJsonToObject(new String(decodedInput), ClientInfo.class);
    }

    String toAccountIdentifier() {
        return this.uniqueIdentifier + "." + this.unqiueTenantIdentifier;
    }

    String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    String getUnqiueTenantIdentifier() {
        return this.unqiueTenantIdentifier;
    }
}

