/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.Authority;
import java.net.URL;

class B2CAuthority
extends Authority {
    final String B2CTokenEndpointFormat = "https://%s/{tenant}/oauth2/v2.0/token?p={policy}";
    String policy;

    B2CAuthority(URL authorityUrl) {
        super(authorityUrl);
        this.validateAuthorityUrl();
        this.setAuthorityProperties();
    }

    private void setAuthorityProperties() {
        String[] segments = this.canonicalAuthorityUrl.getPath().substring(1).split("/");
        if (segments.length < 3) {
            throw new IllegalArgumentException("B2C 'authority' Uri should have at least 3 segments in the path (i.e. https://<host>/tfp/<tenant>/<policy>/...)");
        }
        this.policy = segments[2];
        String b2cAuthorityFormat = "https://%s/%s/%s/%s/";
        this.authority = String.format("https://%s/%s/%s/%s/", this.canonicalAuthorityUrl.getAuthority(), segments[0], segments[1], segments[2]);
        this.tokenEndpoint = String.format("https://%s/{tenant}/oauth2/v2.0/token?p={policy}", this.host);
        this.tokenEndpoint = this.tokenEndpoint.replace("{tenant}", this.tenant);
        this.selfSignedJwtAudience = this.tokenEndpoint = this.tokenEndpoint.replace("{policy}", this.policy);
    }

    String B2CTokenEndpointFormat() {
        return this.B2CTokenEndpointFormat;
    }

    String policy() {
        return this.policy;
    }
}

