/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.google.gson.annotations.SerializedName;
import com.microsoft.aad.msal4j.Account;
import com.microsoft.aad.msal4j.ClientInfo;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IdToken;
import com.microsoft.aad.msal4j.StringHelper;
import java.util.ArrayList;

class AccountCacheEntity {
    static final String MSSTS_ACCOUNT_TYPE = "MSSTS";
    @SerializedName(value="home_account_id")
    protected String homeAccountId;
    @SerializedName(value="environment")
    protected String environment;
    @SerializedName(value="realm")
    protected String realm;
    @SerializedName(value="local_account_id")
    protected String localAccountId;
    @SerializedName(value="username")
    protected String username;
    @SerializedName(value="name")
    protected String name;
    @SerializedName(value="client_info")
    protected String clientInfoStr;
    @SerializedName(value="authority_type")
    protected String authorityType;

    AccountCacheEntity() {
    }

    ClientInfo clientInfo() {
        return ClientInfo.createFromJson(this.clientInfoStr);
    }

    String getKey() {
        ArrayList<String> keyParts = new ArrayList<String>();
        keyParts.add(this.homeAccountId);
        keyParts.add(this.environment);
        keyParts.add(StringHelper.isBlank(this.realm) ? "" : this.realm);
        return String.join((CharSequence)"-", keyParts).toLowerCase();
    }

    static AccountCacheEntity create(String clientInfoStr, String environment, IdToken idToken, String policy) {
        AccountCacheEntity account = new AccountCacheEntity();
        account.authorityType(MSSTS_ACCOUNT_TYPE);
        account.clientInfoStr = clientInfoStr;
        account.homeAccountId(policy != null ? account.clientInfo().toAccountIdentifier() + "-" + policy : account.clientInfo().toAccountIdentifier());
        account.environment(environment);
        if (idToken != null) {
            account.realm(idToken.tenantIdentifier);
            String localAccountId = !StringHelper.isBlank(idToken.objectIdentifier) ? idToken.objectIdentifier : idToken.subject;
            account.localAccountId(localAccountId);
            account.username(idToken.preferredUsername);
            account.name(idToken.name);
        }
        return account;
    }

    static AccountCacheEntity create(String clientInfoStr, String environment, IdToken idToken) {
        return AccountCacheEntity.create(clientInfoStr, environment, idToken, null);
    }

    IAccount toAccount() {
        return new Account(this.homeAccountId, this.environment, this.username);
    }

    public String homeAccountId() {
        return this.homeAccountId;
    }

    public String environment() {
        return this.environment;
    }

    public String realm() {
        return this.realm;
    }

    public String localAccountId() {
        return this.localAccountId;
    }

    public String username() {
        return this.username;
    }

    public String name() {
        return this.name;
    }

    public String clientInfoStr() {
        return this.clientInfoStr;
    }

    public String authorityType() {
        return this.authorityType;
    }

    public AccountCacheEntity homeAccountId(String homeAccountId) {
        this.homeAccountId = homeAccountId;
        return this;
    }

    public AccountCacheEntity environment(String environment) {
        this.environment = environment;
        return this;
    }

    public AccountCacheEntity realm(String realm) {
        this.realm = realm;
        return this;
    }

    public AccountCacheEntity localAccountId(String localAccountId) {
        this.localAccountId = localAccountId;
        return this;
    }

    public AccountCacheEntity username(String username) {
        this.username = username;
        return this;
    }

    public AccountCacheEntity name(String name) {
        this.name = name;
        return this;
    }

    public AccountCacheEntity clientInfoStr(String clientInfoStr) {
        this.clientInfoStr = clientInfoStr;
        return this;
    }

    public AccountCacheEntity authorityType(String authorityType) {
        this.authorityType = authorityType;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountCacheEntity)) {
            return false;
        }
        AccountCacheEntity other = (AccountCacheEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$homeAccountId = this.homeAccountId();
        String other$homeAccountId = other.homeAccountId();
        if (this$homeAccountId == null ? other$homeAccountId != null : !this$homeAccountId.equals(other$homeAccountId)) {
            return false;
        }
        String this$environment = this.environment();
        String other$environment = other.environment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$localAccountId = this.localAccountId();
        String other$localAccountId = other.localAccountId();
        if (this$localAccountId == null ? other$localAccountId != null : !this$localAccountId.equals(other$localAccountId)) {
            return false;
        }
        String this$username = this.username();
        String other$username = other.username();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$clientInfoStr = this.clientInfoStr();
        String other$clientInfoStr = other.clientInfoStr();
        if (this$clientInfoStr == null ? other$clientInfoStr != null : !this$clientInfoStr.equals(other$clientInfoStr)) {
            return false;
        }
        String this$authorityType = this.authorityType();
        String other$authorityType = other.authorityType();
        return !(this$authorityType == null ? other$authorityType != null : !this$authorityType.equals(other$authorityType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountCacheEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $homeAccountId = this.homeAccountId();
        result = result * 59 + ($homeAccountId == null ? 43 : $homeAccountId.hashCode());
        String $environment = this.environment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $localAccountId = this.localAccountId();
        result = result * 59 + ($localAccountId == null ? 43 : $localAccountId.hashCode());
        String $username = this.username();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $clientInfoStr = this.clientInfoStr();
        result = result * 59 + ($clientInfoStr == null ? 43 : $clientInfoStr.hashCode());
        String $authorityType = this.authorityType();
        result = result * 59 + ($authorityType == null ? 43 : $authorityType.hashCode());
        return result;
    }
}

