/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LinkedTreeMap;
import com.microsoft.aad.msal4j.AadInstanceDiscovery;
import com.microsoft.aad.msal4j.AccessTokenCacheEntity;
import com.microsoft.aad.msal4j.Account;
import com.microsoft.aad.msal4j.AuthenticationAuthority;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.Credential;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.IdToken;
import com.microsoft.aad.msal4j.IdTokenCacheEntity;
import com.microsoft.aad.msal4j.RefreshTokenCacheEntity;
import com.microsoft.aad.msal4j.StringHelper;
import com.microsoft.aad.msal4j.TokenCacheAccessContext;
import com.microsoft.aad.msal4j.TokenRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TokenCache {
    public static final int MIN_ACCESS_TOKEN_EXPIRE_IN_SEC = 300;
    @SerializedName(value="AccessToken")
    Map<String, AccessTokenCacheEntity> accessTokens = new LinkedTreeMap();
    @SerializedName(value="RefreshToken")
    Map<String, RefreshTokenCacheEntity> refreshTokens = new LinkedTreeMap();
    @SerializedName(value="IdToken")
    Map<String, IdTokenCacheEntity> idTokens = new LinkedTreeMap();
    @SerializedName(value="Account")
    Map<String, Account> accounts = new LinkedTreeMap();
    private ITokenCacheAccessAspect tokenCacheAccessAspect;
    private String serializedCachedData;

    public TokenCache(ITokenCacheAccessAspect tokenCacheAccessAspect) {
        this();
        this.tokenCacheAccessAspect = tokenCacheAccessAspect;
    }

    public TokenCache() {
    }

    public void deserializeAndLoadToCache(String data) {
        if (StringHelper.isBlank(data)) {
            return;
        }
        this.serializedCachedData = data;
        Gson gson = new GsonBuilder().create();
        TokenCache deserializedCache = (TokenCache)gson.fromJson(data, TokenCache.class);
        this.accounts = deserializedCache.accounts;
        this.accessTokens = deserializedCache.accessTokens;
        this.refreshTokens = deserializedCache.refreshTokens;
        this.idTokens = deserializedCache.idTokens;
    }

    public String serialize() {
        if (!StringHelper.isBlank(this.serializedCachedData)) {
            Object o = new Gson().fromJson(this.serializedCachedData, Object.class);
            Map map = (Map)o;
            map.put("AccessToken", this.accessTokens);
            map.put("RefreshToken", this.refreshTokens);
            map.put("IdToken", this.idTokens);
            map.put("Account", this.accounts);
            return new GsonBuilder().create().toJson((Object)map);
        }
        return new GsonBuilder().create().toJson((Object)this);
    }

    protected void saveTokens(TokenRequest tokenRequest, AuthenticationResult authenticationResult, String environment) {
        TokenCacheAccessContext context;
        if (this.tokenCacheAccessAspect != null) {
            context = TokenCacheAccessContext.builder().clientId(tokenRequest.getMsalRequest().application().clientId()).tokenCache(this).build();
            this.tokenCacheAccessAspect.beforeCacheAccess(context);
        }
        if (!StringHelper.isBlank(authenticationResult.accessToken())) {
            AccessTokenCacheEntity atEntity = TokenCache.createAccessTokenCacheEntity(tokenRequest, authenticationResult, environment);
            this.accessTokens.put(atEntity.getKey(), atEntity);
        }
        if (!StringHelper.isBlank(authenticationResult.refreshToken())) {
            RefreshTokenCacheEntity rtEntity = TokenCache.createRefreshTokenCacheEntity(tokenRequest, authenticationResult, environment);
            this.refreshTokens.put(rtEntity.getKey(), rtEntity);
        }
        if (!StringHelper.isBlank(authenticationResult.idToken())) {
            IdTokenCacheEntity idTokenEntity = TokenCache.createIdTokenCacheEntity(tokenRequest, authenticationResult, environment);
            this.idTokens.put(idTokenEntity.getKey(), idTokenEntity);
            Account account = authenticationResult.account();
            account.environment(environment);
            this.accounts.put(account.getKey(), account);
        }
        if (this.tokenCacheAccessAspect != null) {
            context = TokenCacheAccessContext.builder().clientId(tokenRequest.getMsalRequest().application().clientId()).tokenCache(this).isCacheChanged(true).build();
            this.tokenCacheAccessAspect.afterCacheAccess(context);
        }
    }

    static RefreshTokenCacheEntity createRefreshTokenCacheEntity(TokenRequest tokenRequest, AuthenticationResult authenticationResult, String environmentAlias) {
        RefreshTokenCacheEntity rt = new RefreshTokenCacheEntity();
        if (authenticationResult.account() != null) {
            rt.homeAccountId(authenticationResult.account().homeAccountId);
        }
        rt.environment(environmentAlias);
        rt.clientId(tokenRequest.getMsalRequest().application().clientId());
        rt.secret(authenticationResult.refreshToken());
        return rt;
    }

    static AccessTokenCacheEntity createAccessTokenCacheEntity(TokenRequest tokenRequest, AuthenticationResult authenticationResult, String environmentAlias) {
        AccessTokenCacheEntity at = new AccessTokenCacheEntity();
        if (authenticationResult.account() != null) {
            at.homeAccountId(authenticationResult.account().homeAccountId);
        }
        at.environment(environmentAlias);
        at.clientId(tokenRequest.getMsalRequest().application().clientId());
        at.secret(authenticationResult.accessToken());
        IdToken idTokenObj = authenticationResult.idTokenObject();
        if (idTokenObj != null) {
            at.realm(idTokenObj.tenantIdentifier);
        }
        String scopes = !StringHelper.isBlank(authenticationResult.scopes()) ? authenticationResult.scopes() : tokenRequest.getMsalRequest().msalAuthorizationGrant().getScopes();
        at.target(scopes);
        long currTimestampSec = System.currentTimeMillis() / 1000L;
        at.cachedAt(Long.toString(currTimestampSec));
        at.expiresOn(Long.toString(authenticationResult.expiresOn()));
        if (authenticationResult.extExpiresOn() > 0L) {
            at.extExpiresOn(Long.toString(authenticationResult.extExpiresOn()));
        }
        return at;
    }

    static IdTokenCacheEntity createIdTokenCacheEntity(TokenRequest tokenRequest, AuthenticationResult authenticationResult, String environmentAlias) {
        IdTokenCacheEntity idToken = new IdTokenCacheEntity();
        if (authenticationResult.account() != null) {
            idToken.homeAccountId(authenticationResult.account().homeAccountId);
        }
        idToken.environment(environmentAlias);
        idToken.clientId(tokenRequest.getMsalRequest().application().clientId());
        idToken.secret(authenticationResult.idToken());
        IdToken idTokenObj = authenticationResult.idTokenObject();
        if (idTokenObj != null) {
            idToken.setRealm(idTokenObj.tenantIdentifier);
        }
        return idToken;
    }

    protected Collection<Account> getAccounts(String clientId, Set<String> environmentAliases) {
        TokenCacheAccessContext context = null;
        if (this.tokenCacheAccessAspect != null) {
            context = TokenCacheAccessContext.builder().clientId(clientId).tokenCache(this).build();
            this.tokenCacheAccessAspect.beforeCacheAccess(context);
        }
        Collection result = this.accounts.values().stream().filter(account -> environmentAliases.contains(account.environment) && this.refreshTokens.values().stream().anyMatch(refreshToken -> refreshToken.homeAccountId.equals(account.homeAccountId) && refreshToken.environment.equals(account.environment) && refreshToken.clientId.equals(clientId))).collect(Collectors.toList());
        if (this.tokenCacheAccessAspect != null) {
            this.tokenCacheAccessAspect.afterCacheAccess(context);
        }
        return result;
    }

    protected void removeAccount(String clientId, Account account, Set<String> environmentAliases) {
        TokenCacheAccessContext context = null;
        if (this.tokenCacheAccessAspect != null) {
            context = TokenCacheAccessContext.builder().clientId(clientId).tokenCache(this).build();
            this.tokenCacheAccessAspect.beforeCacheAccess(context);
        }
        Predicate<Map.Entry> credentialToRemovePredicate = e -> ((Credential)e.getValue()).homeAccountId().equals(account.homeAccountId) && environmentAliases.contains(((Credential)e.getValue()).environment);
        this.accessTokens.entrySet().removeIf(credentialToRemovePredicate);
        this.refreshTokens.entrySet().removeIf(credentialToRemovePredicate);
        this.idTokens.entrySet().removeIf(credentialToRemovePredicate);
        if (this.tokenCacheAccessAspect != null) {
            this.tokenCacheAccessAspect.afterCacheAccess(context);
        }
    }

    boolean isMatchingScopes(AccessTokenCacheEntity accessTokenCacheEntity, Set<String> scopes) {
        TreeSet<String> accessTokenCacheEntityScopes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        accessTokenCacheEntityScopes.addAll(Arrays.asList(accessTokenCacheEntity.target().split(" ")));
        return accessTokenCacheEntityScopes.containsAll(scopes);
    }

    Optional<AccessTokenCacheEntity> getAccessTokenCacheEntity(Account account, AuthenticationAuthority authority, Set<String> scopes, String clientId, Set<String> environmentAliases) {
        long currTimeStampSec = new Date().getTime() / 1000L;
        return this.accessTokens.values().stream().filter(accessToken -> accessToken.homeAccountId.equals(account.homeAccountId) && environmentAliases.contains(accessToken.environment) && Long.parseLong(accessToken.expiresOn()) > currTimeStampSec + 300L && accessToken.realm.equals(authority.getTenant()) && accessToken.clientId.equals(clientId) && this.isMatchingScopes((AccessTokenCacheEntity)accessToken, scopes)).findAny();
    }

    Optional<IdTokenCacheEntity> getIdTokenCacheEntity(Account account, AuthenticationAuthority authority, String clientId, Set<String> environmentAliases) {
        return this.idTokens.values().stream().filter(idToken -> idToken.homeAccountId.equals(account.homeAccountId) && environmentAliases.contains(idToken.environment) && idToken.realm.equals(authority.getTenant()) && idToken.clientId.equals(clientId)).findAny();
    }

    Optional<RefreshTokenCacheEntity> getRefreshTokenCacheEntity(Account account, String clientId, Set<String> environmentAliases) {
        return this.refreshTokens.values().stream().filter(refreshToken -> refreshToken.homeAccountId.equals(account.homeAccountId) && environmentAliases.contains(refreshToken.environment) && refreshToken.clientId.equals(clientId)).findAny();
    }

    AuthenticationResult getAuthenticationResult(Account account, AuthenticationAuthority authority, Set<String> scopes, String clientId) {
        TokenCacheAccessContext context = null;
        if (this.tokenCacheAccessAspect != null) {
            context = TokenCacheAccessContext.builder().clientId(clientId).tokenCache(this).account(account).build();
            this.tokenCacheAccessAspect.beforeCacheAccess(context);
        }
        Set<String> environmentAliases = AadInstanceDiscovery.cache.get(account.environment).getAliasesSet();
        Optional<AccessTokenCacheEntity> atCacheEntity = this.getAccessTokenCacheEntity(account, authority, scopes, clientId, environmentAliases);
        Optional<IdTokenCacheEntity> idTokenCacheEntity = this.getIdTokenCacheEntity(account, authority, clientId, environmentAliases);
        Optional<RefreshTokenCacheEntity> rtCacheEntity = this.getRefreshTokenCacheEntity(account, clientId, environmentAliases);
        if (this.tokenCacheAccessAspect != null) {
            this.tokenCacheAccessAspect.afterCacheAccess(context);
        }
        AuthenticationResult.AuthenticationResultBuilder builder = AuthenticationResult.builder();
        if (atCacheEntity.isPresent()) {
            builder.accessToken(atCacheEntity.get().secret).expiresOn(Long.parseLong(atCacheEntity.get().expiresOn()));
        }
        if (idTokenCacheEntity.isPresent()) {
            builder.idToken(idTokenCacheEntity.get().secret);
        }
        if (rtCacheEntity.isPresent()) {
            builder.refreshToken(rtCacheEntity.get().secret);
        }
        builder.account(account);
        builder.environment(authority.getHost());
        return builder.build();
    }
}

