/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AuthorityType;
import com.microsoft.aad.msal4j.StringHelper;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthenticationAuthority {
    private final Logger log = LoggerFactory.getLogger(AuthenticationAuthority.class);
    private static final String TENANTLESS_TENANT_NAME = "common";
    private static final String DISCOVERY_ENDPOINT = "common/discovery/instance";
    private static final String TOKEN_ENDPOINT = "/oauth2/v2.0/token";
    private static final String USER_REALM_ENDPOINT = "common/userrealm";
    static final String DEVICE_CODE_ENDPOINT = "/oauth2/v2.0/devicecode";
    private final String userRealmEndpointFormat = "https://%s/common/userrealm/%s?api-version=1.0";
    private final String tokenEndpointFormat = "https://%s/{tenant}/oauth2/v2.0/token";
    private final String devicecodeEndpointFormat = "https://%s/{tenant}/oauth2/v2.0/devicecode";
    private String authority = "https://%s/%s/";
    private String host;
    private String issuer;
    private String tokenEndpoint;
    private String deviceCodeEndpoint;
    protected final AuthorityType authorityType;
    private boolean isTenantless;
    private String tokenUri;
    private String selfSignedJwtAudience;
    private final URL authorityUrl;
    private String tenant;

    AuthenticationAuthority(URL authorityUrl) {
        this.authorityUrl = authorityUrl;
        this.authorityType = AuthenticationAuthority.detectAuthorityType(authorityUrl);
        this.validateAuthorityUrl();
        this.setupAuthorityProperties();
    }

    String getUserRealmEndpoint(String username) {
        return String.format("https://%s/common/userrealm/%s?api-version=1.0", this.host, username);
    }

    void setSelfSignedJwtAudience(String selfSignedJwtAudience) {
        this.selfSignedJwtAudience = selfSignedJwtAudience;
    }

    static String getTenant(URL authorityUrl) {
        String path = authorityUrl.getPath().substring(1);
        return path.substring(0, path.indexOf("/"));
    }

    void setupAuthorityProperties() {
        this.tenant = AuthenticationAuthority.getTenant(this.authorityUrl);
        this.host = this.authorityUrl.getAuthority().toLowerCase();
        this.authority = String.format(this.authority, this.host, this.tenant);
        this.tokenEndpoint = String.format(this.tokenEndpointFormat, this.host);
        this.issuer = this.tokenUri = (this.tokenEndpoint = this.tokenEndpoint.replace("{tenant}", this.tenant));
        this.deviceCodeEndpoint = String.format(this.devicecodeEndpointFormat, this.host);
        this.deviceCodeEndpoint = this.deviceCodeEndpoint.replace("{tenant}", this.tenant);
        this.isTenantless = TENANTLESS_TENANT_NAME.equalsIgnoreCase(this.tenant);
        this.setSelfSignedJwtAudience(this.getIssuer());
    }

    static AuthorityType detectAuthorityType(URL authorityUrl) {
        if (authorityUrl == null) {
            throw new NullPointerException("authorityUrl");
        }
        String path = authorityUrl.getPath().substring(1);
        if (StringHelper.isBlank(path)) {
            throw new IllegalArgumentException("'authority' Uri should have at least one segment in the path (i.e. https://<host>/<path>/...)");
        }
        String firstPath = path.substring(0, path.indexOf("/"));
        AuthorityType authorityType = AuthenticationAuthority.isAdfsAuthority(firstPath) ? AuthorityType.ADFS : AuthorityType.AAD;
        return authorityType;
    }

    void validateAuthorityUrl() {
        if (!this.authorityUrl.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("'authority' should use the 'https' scheme");
        }
        if (this.authorityUrl.toString().contains("#")) {
            throw new IllegalArgumentException("authority is invalid format (contains fragment)");
        }
        if (!StringHelper.isBlank(this.authorityUrl.getQuery())) {
            throw new IllegalArgumentException("authority cannot contain query parameters");
        }
    }

    static boolean isAdfsAuthority(String firstPath) {
        return firstPath.compareToIgnoreCase("adfs") == 0;
    }

    Logger getLog() {
        return this.log;
    }

    String getUserRealmEndpointFormat() {
        return this.userRealmEndpointFormat;
    }

    String getTokenEndpointFormat() {
        return this.tokenEndpointFormat;
    }

    String getDevicecodeEndpointFormat() {
        return this.devicecodeEndpointFormat;
    }

    String getAuthority() {
        return this.authority;
    }

    String getHost() {
        return this.host;
    }

    String getIssuer() {
        return this.issuer;
    }

    String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    String getDeviceCodeEndpoint() {
        return this.deviceCodeEndpoint;
    }

    AuthorityType getAuthorityType() {
        return this.authorityType;
    }

    boolean isTenantless() {
        return this.isTenantless;
    }

    String getTokenUri() {
        return this.tokenUri;
    }

    String getSelfSignedJwtAudience() {
        return this.selfSignedJwtAudience;
    }

    URL getAuthorityUrl() {
        return this.authorityUrl;
    }

    String getTenant() {
        return this.tenant;
    }
}

