/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.persistence;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.persistence.Persistence;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class DatabasePersistenceAsync {
    @VisibleForTesting
    public static final String THREAD_NAME = "DatabasePersistenceThread";
    private final Handler mHandler;
    private final Persistence mPersistence;

    public DatabasePersistenceAsync(Persistence persistence) {
        HandlerThread thread = new HandlerThread(THREAD_NAME);
        thread.start();
        this.mHandler = new Handler(thread.getLooper());
        this.mPersistence = persistence;
    }

    public void putLog(final @NonNull String group, final @NonNull Log log, final @Nullable DatabasePersistenceAsyncCallback callback) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    DatabasePersistenceAsync.this.mPersistence.putLog(group, log);
                    DatabasePersistenceAsync.this.onSuccess(callback, null);
                }
                catch (Persistence.PersistenceException e) {
                    DatabasePersistenceAsync.this.onFailure(callback, e);
                }
            }
        });
    }

    public void deleteLogs(@NonNull String group, @NonNull String id) {
        this.deleteLogs(group, id, null);
    }

    public void deleteLogs(final @NonNull String group, final @NonNull String id, final @Nullable DatabasePersistenceAsyncCallback callback) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                DatabasePersistenceAsync.this.mPersistence.deleteLogs(group, id);
                DatabasePersistenceAsync.this.onSuccess(callback, null);
            }
        });
    }

    public void deleteLogs(String group) {
        this.deleteLogs(group, (DatabasePersistenceAsyncCallback)null);
    }

    public void deleteLogs(final String group, final @Nullable DatabasePersistenceAsyncCallback callback) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                DatabasePersistenceAsync.this.mPersistence.deleteLogs(group);
                DatabasePersistenceAsync.this.onSuccess(callback, null);
            }
        });
    }

    public void countLogs(final @NonNull String group, final @Nullable DatabasePersistenceAsyncCallback callback) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                int count = DatabasePersistenceAsync.this.mPersistence.countLogs(group);
                DatabasePersistenceAsync.this.onSuccess(callback, count);
            }
        });
    }

    public void getLogs(final @NonNull String group, final @IntRange(from=0L) int limit, final @NonNull List<Log> outLogs, final @Nullable DatabasePersistenceAsyncCallback callback) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                String id = DatabasePersistenceAsync.this.mPersistence.getLogs(group, limit, outLogs);
                DatabasePersistenceAsync.this.onSuccess(callback, id);
            }
        });
    }

    public void clearPendingLogState() {
        this.clearPendingLogState(null);
    }

    public void clearPendingLogState(final @Nullable DatabasePersistenceAsyncCallback callback) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                DatabasePersistenceAsync.this.mPersistence.clearPendingLogState();
                DatabasePersistenceAsync.this.onSuccess(callback, null);
            }
        });
    }

    public void close() {
        this.close(null);
    }

    public void close(final @Nullable DatabasePersistenceAsyncCallback callback) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    DatabasePersistenceAsync.this.mPersistence.close();
                    DatabasePersistenceAsync.this.onSuccess(callback, null);
                }
                catch (IOException e) {
                    DatabasePersistenceAsync.this.onFailure(callback, e);
                }
                DatabasePersistenceAsync.this.mHandler.removeCallbacks((Runnable)this);
            }
        });
    }

    public void waitForCurrentTasksToComplete(long timeout) throws InterruptedException {
        final Semaphore semaphore = new Semaphore(0);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                semaphore.release();
                MobileCenterLog.debug("MobileCenter", "Persistence tasks completed.");
            }
        });
        if (!semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
            MobileCenterLog.error("MobileCenter", "Timeout waiting for database tasks to complete.");
        }
    }

    private void onSuccess(DatabasePersistenceAsyncCallback callback, Object result) {
        if (callback != null) {
            callback.onSuccess(result);
        }
    }

    @VisibleForTesting
    void onFailure(DatabasePersistenceAsyncCallback callback, Exception e) {
        if (callback != null) {
            callback.onFailure(e);
        }
    }

    public static abstract class AbstractDatabasePersistenceAsyncCallback
    implements DatabasePersistenceAsyncCallback {
        @Override
        public final void onFailure(Exception e) {
        }
    }

    public static interface DatabasePersistenceAsyncCallback {
        public void onSuccess(Object var1);

        public void onFailure(Exception var1);
    }
}

