/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion.models.json;

import android.support.annotation.NonNull;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.LogContainer;
import com.microsoft.azure.mobile.ingestion.models.json.LogFactory;
import com.microsoft.azure.mobile.ingestion.models.json.LogSerializer;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class DefaultLogSerializer
implements LogSerializer {
    private static final String LOGS = "logs";
    private final Map<String, LogFactory> mLogFactories = new HashMap<String, LogFactory>();

    @NonNull
    private JSONStringer writeLog(JSONStringer writer, Log log) throws JSONException {
        writer.object();
        log.write(writer);
        writer.endObject();
        return writer;
    }

    @NonNull
    private Log readLog(JSONObject object) throws JSONException {
        String type = object.getString("type");
        LogFactory logFactory = this.mLogFactories.get(type);
        if (logFactory == null) {
            throw new JSONException("Unknown log type: " + type);
        }
        Log log = logFactory.create();
        log.read(object);
        return log;
    }

    @Override
    @NonNull
    public String serializeLog(@NonNull Log log) throws JSONException {
        return this.writeLog(new JSONStringer(), log).toString();
    }

    @Override
    @NonNull
    public Log deserializeLog(@NonNull String json) throws JSONException {
        return this.readLog(new JSONObject(json));
    }

    @Override
    @NonNull
    public String serializeContainer(@NonNull LogContainer logContainer) throws JSONException {
        JSONStringer writer = null;
        if (MobileCenterLog.getLogLevel() <= 2) {
            try {
                Constructor constructor = JSONStringer.class.getDeclaredConstructor(Integer.TYPE);
                constructor.setAccessible(true);
                writer = (JSONStringer)constructor.newInstance(2);
            }
            catch (Exception e) {
                MobileCenterLog.error("MobileCenter", "Failed to setup pretty json, falling back to default one", e);
            }
        }
        if (writer == null) {
            writer = new JSONStringer();
        }
        writer.object();
        writer.key(LOGS).array();
        for (Log log : logContainer.getLogs()) {
            this.writeLog(writer, log);
        }
        writer.endArray();
        writer.endObject();
        return writer.toString();
    }

    @Override
    @NonNull
    public LogContainer deserializeContainer(@NonNull String json) throws JSONException {
        JSONObject jContainer = new JSONObject(json);
        LogContainer container = new LogContainer();
        JSONArray jLogs = jContainer.getJSONArray(LOGS);
        ArrayList<Log> logs = new ArrayList<Log>();
        for (int i = 0; i < jLogs.length(); ++i) {
            JSONObject jLog = jLogs.getJSONObject(i);
            Log log = this.readLog(jLog);
            logs.add(log);
        }
        container.setLogs(logs);
        return container;
    }

    @Override
    public void addLogFactory(@NonNull String logType, @NonNull LogFactory logFactory) {
        this.mLogFactories.put(logType, logFactory);
    }
}

