/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.channel;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.CancellationException;
import com.microsoft.azure.mobile.channel.Channel;
import com.microsoft.azure.mobile.ingestion.Ingestion;
import com.microsoft.azure.mobile.ingestion.ServiceCallback;
import com.microsoft.azure.mobile.ingestion.http.HttpUtils;
import com.microsoft.azure.mobile.ingestion.http.IngestionHttp;
import com.microsoft.azure.mobile.ingestion.http.IngestionNetworkStateHandler;
import com.microsoft.azure.mobile.ingestion.http.IngestionRetryer;
import com.microsoft.azure.mobile.ingestion.models.Device;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.LogContainer;
import com.microsoft.azure.mobile.ingestion.models.json.LogSerializer;
import com.microsoft.azure.mobile.persistence.DatabasePersistence;
import com.microsoft.azure.mobile.persistence.DatabasePersistenceAsync;
import com.microsoft.azure.mobile.persistence.Persistence;
import com.microsoft.azure.mobile.utils.DeviceInfoHelper;
import com.microsoft.azure.mobile.utils.IdHelper;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.NetworkStateHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultChannel
implements Channel {
    @VisibleForTesting
    static final int CLEAR_BATCH_SIZE = 100;
    @VisibleForTesting
    static final int SHUTDOWN_TIMEOUT = 5000;
    private final Context mContext;
    private final String mAppSecret;
    private final UUID mInstallId;
    private final Handler mIngestionHandler;
    private final Map<String, GroupState> mGroupStates;
    private final Collection<Channel.Listener> mListeners;
    private final DatabasePersistenceAsync mPersistence;
    private final Ingestion mIngestion;
    private boolean mEnabled;
    private boolean mDiscardLogs;
    private Device mDevice;

    public DefaultChannel(@NonNull Context context, @NonNull String appSecret, @NonNull LogSerializer logSerializer) {
        this(context, appSecret, DefaultChannel.buildDefaultPersistence(logSerializer), DefaultChannel.buildDefaultIngestion(context, logSerializer));
    }

    @VisibleForTesting
    DefaultChannel(@NonNull Context context, @NonNull String appSecret, @NonNull Persistence persistence, @NonNull Ingestion ingestion) {
        this.mContext = context;
        this.mAppSecret = appSecret;
        this.mInstallId = IdHelper.getInstallId();
        this.mIngestionHandler = new Handler(Looper.getMainLooper());
        this.mGroupStates = new HashMap<String, GroupState>();
        this.mListeners = new HashSet<Channel.Listener>();
        this.mPersistence = new DatabasePersistenceAsync(persistence);
        this.mIngestion = ingestion;
        this.mEnabled = true;
    }

    private static Ingestion buildDefaultIngestion(@NonNull Context context, @NonNull LogSerializer logSerializer) {
        IngestionHttp api = new IngestionHttp(logSerializer);
        IngestionRetryer retryer = new IngestionRetryer(api);
        return new IngestionNetworkStateHandler(retryer, NetworkStateHelper.getSharedInstance(context));
    }

    private static Persistence buildDefaultPersistence(@NonNull LogSerializer logSerializer) {
        DatabasePersistence persistence = new DatabasePersistence();
        persistence.setLogSerializer(logSerializer);
        return persistence;
    }

    @Override
    public synchronized void addGroup(final String groupName, int maxLogsPerBatch, long batchTimeInterval, int maxParallelBatches, Channel.GroupListener groupListener) {
        MobileCenterLog.debug("MobileCenter", "addGroup(" + groupName + ")");
        this.mGroupStates.put(groupName, new GroupState(groupName, maxLogsPerBatch, batchTimeInterval, maxParallelBatches, groupListener));
        this.mPersistence.countLogs(groupName, new DatabasePersistenceAsync.AbstractDatabasePersistenceAsyncCallback(){

            @Override
            public void onSuccess(Object result) {
                ((GroupState)((DefaultChannel)DefaultChannel.this).mGroupStates.get((Object)groupName)).mPendingLogCount = (Integer)result;
                DefaultChannel.this.checkPendingLogs(groupName);
            }
        });
    }

    @Override
    public synchronized void removeGroup(String groupName) {
        GroupState groupState = this.mGroupStates.remove(groupName);
        if (groupState != null) {
            this.cancelTimer(groupState);
        }
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public synchronized void setEnabled(boolean enabled) {
        if (this.mEnabled == enabled) {
            return;
        }
        if (enabled) {
            this.mEnabled = true;
            this.mDiscardLogs = false;
            for (String groupName : this.mGroupStates.keySet()) {
                this.checkPendingLogs(groupName);
            }
        } else {
            this.suspend(true, new CancellationException());
        }
    }

    @Override
    public void setServerUrl(String serverUrl) {
        this.mIngestion.setServerUrl(serverUrl);
    }

    @Override
    public synchronized void clear(String groupName) {
        this.mPersistence.deleteLogs(groupName);
    }

    @Override
    public synchronized void invalidateDeviceCache() {
        this.mDevice = null;
    }

    private void suspend(boolean deleteLogs, Exception exception) {
        this.mEnabled = false;
        this.mDiscardLogs = deleteLogs;
        for (GroupState groupState : this.mGroupStates.values()) {
            this.cancelTimer(groupState);
            Iterator<Map.Entry<String, List<Log>>> iterator = groupState.mSendingBatches.entrySet().iterator();
            while (iterator.hasNext()) {
                Channel.GroupListener groupListener;
                Map.Entry<String, List<Log>> entry = iterator.next();
                List<Log> removedLogsForBatchId = groupState.mSendingBatches.get(entry.getKey());
                iterator.remove();
                if (!deleteLogs || (groupListener = groupState.mListener) == null) continue;
                for (Log log : removedLogsForBatchId) {
                    groupListener.onFailure(log, exception);
                }
            }
        }
        try {
            this.mIngestion.close();
        }
        catch (IOException e) {
            MobileCenterLog.error("MobileCenter", "Failed to close ingestion", e);
        }
        if (deleteLogs) {
            for (GroupState groupState : this.mGroupStates.values()) {
                this.handleFailureCallback(groupState);
            }
        } else {
            this.mPersistence.clearPendingLogState();
        }
    }

    private void handleFailureCallback(final GroupState groupState) {
        final ArrayList<Log> logs = new ArrayList<Log>();
        this.mPersistence.getLogs(groupState.mName, 100, logs, new DatabasePersistenceAsync.AbstractDatabasePersistenceAsyncCallback(){

            @Override
            public void onSuccess(Object result) {
                if (logs.size() > 0 && groupState.mListener != null) {
                    for (Log log : logs) {
                        groupState.mListener.onBeforeSending(log);
                        groupState.mListener.onFailure(log, new CancellationException());
                    }
                }
                if (logs.size() >= 100 && groupState.mListener != null) {
                    DefaultChannel.this.handleFailureCallback(groupState);
                } else {
                    DefaultChannel.this.mPersistence.deleteLogs(groupState.mName);
                }
            }
        });
    }

    private void cancelTimer(GroupState groupState) {
        if (groupState.mScheduled) {
            groupState.mScheduled = false;
            this.mIngestionHandler.removeCallbacks(groupState.mRunnable);
        }
    }

    @VisibleForTesting
    synchronized int getCounter(@NonNull String groupName) {
        return this.mGroupStates.get((Object)groupName).mPendingLogCount;
    }

    private synchronized void triggerIngestion(final @NonNull String groupName) {
        if (!this.mEnabled) {
            return;
        }
        final GroupState groupState = this.mGroupStates.get(groupName);
        MobileCenterLog.debug("MobileCenter", "triggerIngestion(" + groupName + ") pendingLogCount=" + groupState.mPendingLogCount);
        this.cancelTimer(groupState);
        if (groupState.mSendingBatches.size() == groupState.mMaxParallelBatches) {
            MobileCenterLog.debug("MobileCenter", "Already sending " + groupState.mMaxParallelBatches + " batches of analytics data to the server.");
            return;
        }
        final ArrayList<Log> batch = new ArrayList<Log>(groupState.mMaxLogsPerBatch);
        this.mPersistence.getLogs(groupName, groupState.mMaxLogsPerBatch, batch, new DatabasePersistenceAsync.AbstractDatabasePersistenceAsyncCallback(){

            @Override
            public void onSuccess(Object result) {
                final String batchId = (String)result;
                if (batchId != null) {
                    if (groupState.mListener != null) {
                        for (Log log : batch) {
                            groupState.mListener.onBeforeSending(log);
                        }
                    }
                    groupState.mPendingLogCount -= batch.size();
                    MobileCenterLog.debug("MobileCenter", "ingestLogs(" + groupName + "," + batchId + ") pendingLogCount=" + groupState.mPendingLogCount);
                    groupState.mSendingBatches.put(batchId, batch);
                    LogContainer logContainer = new LogContainer();
                    logContainer.setLogs(batch);
                    DefaultChannel.this.mIngestion.sendAsync(DefaultChannel.this.mAppSecret, DefaultChannel.this.mInstallId, logContainer, new ServiceCallback(){

                        @Override
                        public void onCallSucceeded() {
                            DefaultChannel.this.handleSendingSuccess(groupState, batchId);
                        }

                        @Override
                        public void onCallFailed(Exception e) {
                            DefaultChannel.this.handleSendingFailure(groupState, batchId, e);
                        }
                    });
                    DefaultChannel.this.checkPendingLogs(groupName);
                }
            }
        });
    }

    private synchronized void handleSendingSuccess(@NonNull GroupState groupState, @NonNull String batchId) {
        String groupName = groupState.mName;
        this.mPersistence.deleteLogs(groupName, batchId);
        List<Log> removedLogsForBatchId = groupState.mSendingBatches.remove(batchId);
        Channel.GroupListener groupListener = groupState.mListener;
        if (groupListener != null) {
            for (Log log : removedLogsForBatchId) {
                groupListener.onSuccess(log);
            }
        }
        this.checkPendingLogs(groupName);
    }

    private synchronized void handleSendingFailure(@NonNull GroupState groupState, @NonNull String batchId, @NonNull Exception e) {
        String groupName = groupState.mName;
        MobileCenterLog.error("MobileCenter", "Sending logs groupName=" + groupName + " id=" + batchId + " failed", e);
        List<Log> removedLogsForBatchId = groupState.mSendingBatches.remove(batchId);
        boolean recoverableError = HttpUtils.isRecoverableError(e);
        if (recoverableError) {
            groupState.mPendingLogCount += removedLogsForBatchId.size();
        } else {
            Channel.GroupListener groupListener = groupState.mListener;
            if (groupListener != null) {
                for (Log log : removedLogsForBatchId) {
                    groupListener.onFailure(log, e);
                }
            }
        }
        this.suspend(!recoverableError, e);
    }

    @Override
    public synchronized void enqueue(@NonNull Log log, final @NonNull String groupName) {
        final GroupState groupState = this.mGroupStates.get(groupName);
        if (groupState == null) {
            MobileCenterLog.error("MobileCenter", "Invalid group name:" + groupName);
            return;
        }
        if (this.mDiscardLogs) {
            MobileCenterLog.warn("MobileCenter", "Channel is disabled, log are discarded.");
            if (groupState.mListener != null) {
                groupState.mListener.onBeforeSending(log);
                groupState.mListener.onFailure(log, new CancellationException());
            }
            return;
        }
        for (Channel.Listener listener : this.mListeners) {
            listener.onEnqueuingLog(log, groupName);
        }
        if (log.getDevice() == null) {
            if (this.mDevice == null) {
                try {
                    this.mDevice = DeviceInfoHelper.getDeviceInfo(this.mContext);
                }
                catch (DeviceInfoHelper.DeviceInfoException e) {
                    MobileCenterLog.error("MobileCenter", "Device log cannot be generated", e);
                    return;
                }
            }
            log.setDevice(this.mDevice);
        }
        if (log.getToffset() == 0L) {
            log.setToffset(System.currentTimeMillis());
        }
        this.mPersistence.putLog(groupName, log, new DatabasePersistenceAsync.DatabasePersistenceAsyncCallback(){

            @Override
            public void onSuccess(Object result) {
                ++groupState.mPendingLogCount;
                MobileCenterLog.debug("MobileCenter", "enqueue(" + groupName + ") pendingLogCount=" + groupState.mPendingLogCount);
                if (!DefaultChannel.this.mEnabled) {
                    MobileCenterLog.warn("MobileCenter", "Channel is temporarily disabled, log was saved to disk.");
                } else {
                    DefaultChannel.this.checkPendingLogs(groupName);
                }
            }

            @Override
            public void onFailure(Exception e) {
                MobileCenterLog.error("MobileCenter", "Error persisting log with exception: " + e.toString());
            }
        });
    }

    private synchronized void checkPendingLogs(@NonNull String groupName) {
        GroupState groupState = this.mGroupStates.get(groupName);
        if (groupState != null) {
            long pendingLogCount = groupState.mPendingLogCount;
            MobileCenterLog.debug("MobileCenter", "checkPendingLogs(" + groupName + ") pendingLogCount=" + pendingLogCount);
            if (pendingLogCount >= (long)groupState.mMaxLogsPerBatch) {
                this.triggerIngestion(groupName);
            } else if (pendingLogCount > 0L && !groupState.mScheduled) {
                groupState.mScheduled = true;
                this.mIngestionHandler.postDelayed(groupState.mRunnable, groupState.mBatchTimeInterval);
            }
        } else {
            MobileCenterLog.info("MobileCenter", "The service has been disabled. Stop processing logs.");
        }
    }

    @Override
    public synchronized void addListener(Channel.Listener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public synchronized void removeListener(Channel.Listener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void shutdown() {
        this.suspend(false, new CancellationException());
        try {
            MobileCenterLog.debug("MobileCenter", "Wait for persistence to process queue.");
            this.mPersistence.waitForCurrentTasksToComplete(5000L);
        }
        catch (InterruptedException e) {
            MobileCenterLog.warn("MobileCenter", "Interrupted while waiting persistence to flush.", e);
        }
    }

    private class GroupState {
        final String mName;
        final int mMaxLogsPerBatch;
        final long mBatchTimeInterval;
        final int mMaxParallelBatches;
        final Map<String, List<Log>> mSendingBatches = new HashMap<String, List<Log>>();
        final Channel.GroupListener mListener;
        int mPendingLogCount;
        boolean mScheduled;
        final Runnable mRunnable = new Runnable(){

            @Override
            public void run() {
                GroupState.this.mScheduled = false;
                DefaultChannel.this.triggerIngestion(GroupState.this.mName);
            }
        };

        GroupState(String name, int maxLogsPerBatch, long batchTimeInterval, int maxParallelBatches, Channel.GroupListener listener) {
            this.mName = name;
            this.mMaxLogsPerBatch = maxLogsPerBatch;
            this.mBatchTimeInterval = batchTimeInterval;
            this.mMaxParallelBatches = maxParallelBatches;
            this.mListener = listener;
        }
    }
}

