/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion.models;

import com.microsoft.azure.mobile.ingestion.models.WrapperSdk;
import com.microsoft.azure.mobile.ingestion.models.json.JSONUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class Device
extends WrapperSdk {
    private static final String SDK_NAME = "sdk_name";
    private static final String SDK_VERSION = "sdk_version";
    private static final String MODEL = "model";
    private static final String OEM_NAME = "oem_name";
    private static final String OS_NAME = "os_name";
    private static final String OS_VERSION = "os_version";
    private static final String OS_BUILD = "os_build";
    private static final String OS_API_LEVEL = "os_api_level";
    private static final String LOCALE = "locale";
    private static final String TIME_ZONE_OFFSET = "time_zone_offset";
    private static final String SCREEN_SIZE = "screen_size";
    private static final String APP_VERSION = "app_version";
    private static final String CARRIER_NAME = "carrier_name";
    private static final String CARRIER_COUNTRY = "carrier_country";
    private static final String APP_BUILD = "app_build";
    private static final String APP_NAMESPACE = "app_namespace";
    private String sdkName;
    private String sdkVersion;
    private String model;
    private String oemName;
    private String osName;
    private String osVersion;
    private String osBuild;
    private Integer osApiLevel;
    private String locale;
    private Integer timeZoneOffset;
    private String screenSize;
    private String appVersion;
    private String carrierName;
    private String carrierCountry;
    private String appBuild;
    private String appNamespace;

    public String getSdkName() {
        return this.sdkName;
    }

    public void setSdkName(String sdkName) {
        this.sdkName = sdkName;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getOemName() {
        return this.oemName;
    }

    public void setOemName(String oemName) {
        this.oemName = oemName;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOsBuild() {
        return this.osBuild;
    }

    public void setOsBuild(String osBuild) {
        this.osBuild = osBuild;
    }

    public Integer getOsApiLevel() {
        return this.osApiLevel;
    }

    public void setOsApiLevel(Integer osApiLevel) {
        this.osApiLevel = osApiLevel;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Integer getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(Integer timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public String getScreenSize() {
        return this.screenSize;
    }

    public void setScreenSize(String screenSize) {
        this.screenSize = screenSize;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getCarrierName() {
        return this.carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public String getCarrierCountry() {
        return this.carrierCountry;
    }

    public void setCarrierCountry(String carrierCountry) {
        this.carrierCountry = carrierCountry;
    }

    public String getAppBuild() {
        return this.appBuild;
    }

    public void setAppBuild(String appBuild) {
        this.appBuild = appBuild;
    }

    public String getAppNamespace() {
        return this.appNamespace;
    }

    public void setAppNamespace(String appNamespace) {
        this.appNamespace = appNamespace;
    }

    @Override
    public void read(JSONObject object) throws JSONException {
        super.read(object);
        this.setSdkName(object.getString(SDK_NAME));
        this.setSdkVersion(object.getString(SDK_VERSION));
        this.setModel(object.getString(MODEL));
        this.setOemName(object.getString(OEM_NAME));
        this.setOsName(object.getString(OS_NAME));
        this.setOsVersion(object.getString(OS_VERSION));
        this.setOsBuild(object.optString(OS_BUILD, null));
        this.setOsApiLevel(JSONUtils.readInteger(object, OS_API_LEVEL));
        this.setLocale(object.getString(LOCALE));
        this.setTimeZoneOffset(object.getInt(TIME_ZONE_OFFSET));
        this.setScreenSize(object.getString(SCREEN_SIZE));
        this.setAppVersion(object.getString(APP_VERSION));
        this.setCarrierName(object.optString(CARRIER_NAME, null));
        this.setCarrierCountry(object.optString(CARRIER_COUNTRY, null));
        this.setAppBuild(object.getString(APP_BUILD));
        this.setAppNamespace(object.optString(APP_NAMESPACE, null));
    }

    @Override
    public void write(JSONStringer writer) throws JSONException {
        super.write(writer);
        writer.key(SDK_NAME).value((Object)this.getSdkName());
        writer.key(SDK_VERSION).value((Object)this.getSdkVersion());
        writer.key(MODEL).value((Object)this.getModel());
        writer.key(OEM_NAME).value((Object)this.getOemName());
        writer.key(OS_NAME).value((Object)this.getOsName());
        writer.key(OS_VERSION).value((Object)this.getOsVersion());
        JSONUtils.write(writer, OS_BUILD, this.getOsBuild());
        JSONUtils.write(writer, OS_API_LEVEL, this.getOsApiLevel());
        writer.key(LOCALE).value((Object)this.getLocale());
        writer.key(TIME_ZONE_OFFSET).value((Object)this.getTimeZoneOffset());
        writer.key(SCREEN_SIZE).value((Object)this.getScreenSize());
        writer.key(APP_VERSION).value((Object)this.getAppVersion());
        JSONUtils.write(writer, CARRIER_NAME, this.getCarrierName());
        JSONUtils.write(writer, CARRIER_COUNTRY, this.getCarrierCountry());
        writer.key(APP_BUILD).value((Object)this.getAppBuild());
        JSONUtils.write(writer, APP_NAMESPACE, this.getAppNamespace());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Device device = (Device)o;
        if (this.sdkName != null ? !this.sdkName.equals(device.sdkName) : device.sdkName != null) {
            return false;
        }
        if (this.sdkVersion != null ? !this.sdkVersion.equals(device.sdkVersion) : device.sdkVersion != null) {
            return false;
        }
        if (this.model != null ? !this.model.equals(device.model) : device.model != null) {
            return false;
        }
        if (this.oemName != null ? !this.oemName.equals(device.oemName) : device.oemName != null) {
            return false;
        }
        if (this.osName != null ? !this.osName.equals(device.osName) : device.osName != null) {
            return false;
        }
        if (this.osVersion != null ? !this.osVersion.equals(device.osVersion) : device.osVersion != null) {
            return false;
        }
        if (this.osBuild != null ? !this.osBuild.equals(device.osBuild) : device.osBuild != null) {
            return false;
        }
        if (this.osApiLevel != null ? !this.osApiLevel.equals(device.osApiLevel) : device.osApiLevel != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(device.locale) : device.locale != null) {
            return false;
        }
        if (this.timeZoneOffset != null ? !this.timeZoneOffset.equals(device.timeZoneOffset) : device.timeZoneOffset != null) {
            return false;
        }
        if (this.screenSize != null ? !this.screenSize.equals(device.screenSize) : device.screenSize != null) {
            return false;
        }
        if (this.appVersion != null ? !this.appVersion.equals(device.appVersion) : device.appVersion != null) {
            return false;
        }
        if (this.carrierName != null ? !this.carrierName.equals(device.carrierName) : device.carrierName != null) {
            return false;
        }
        if (this.carrierCountry != null ? !this.carrierCountry.equals(device.carrierCountry) : device.carrierCountry != null) {
            return false;
        }
        if (this.appBuild != null ? !this.appBuild.equals(device.appBuild) : device.appBuild != null) {
            return false;
        }
        return this.appNamespace != null ? this.appNamespace.equals(device.appNamespace) : device.appNamespace == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.sdkName != null ? this.sdkName.hashCode() : 0);
        result = 31 * result + (this.sdkVersion != null ? this.sdkVersion.hashCode() : 0);
        result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
        result = 31 * result + (this.oemName != null ? this.oemName.hashCode() : 0);
        result = 31 * result + (this.osName != null ? this.osName.hashCode() : 0);
        result = 31 * result + (this.osVersion != null ? this.osVersion.hashCode() : 0);
        result = 31 * result + (this.osBuild != null ? this.osBuild.hashCode() : 0);
        result = 31 * result + (this.osApiLevel != null ? this.osApiLevel.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.timeZoneOffset != null ? this.timeZoneOffset.hashCode() : 0);
        result = 31 * result + (this.screenSize != null ? this.screenSize.hashCode() : 0);
        result = 31 * result + (this.appVersion != null ? this.appVersion.hashCode() : 0);
        result = 31 * result + (this.carrierName != null ? this.carrierName.hashCode() : 0);
        result = 31 * result + (this.carrierCountry != null ? this.carrierCountry.hashCode() : 0);
        result = 31 * result + (this.appBuild != null ? this.appBuild.hashCode() : 0);
        result = 31 * result + (this.appNamespace != null ? this.appNamespace.hashCode() : 0);
        return result;
    }
}

