/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.utils.storage;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.storage.DatabaseManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StorageHelper {
    private static final String PREFERENCES_NAME = "MobileCenter";
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context sContext;
    private static SharedPreferences sSharedPreferences;

    public static void initialize(Context context) {
        sContext = context;
        sSharedPreferences = sContext.getSharedPreferences(PREFERENCES_NAME, 0);
    }

    public static class DatabaseStorage
    implements Closeable {
        private final DatabaseManager mDatabaseManager;

        private DatabaseStorage(@NonNull DatabaseManager databaseManager) {
            this.mDatabaseManager = databaseManager;
        }

        public static DatabaseStorage getDatabaseStorage(@NonNull String database, @NonNull String table, @IntRange(from=1L) int version, @NonNull ContentValues schema, @NonNull DatabaseErrorListener listener) {
            return DatabaseStorage.getDatabaseStorage(database, table, version, schema, 0, listener);
        }

        public static DatabaseStorage getDatabaseStorage(@NonNull String database, @NonNull String table, @IntRange(from=1L) int version, @NonNull ContentValues schema, @IntRange(from=0L) int maxRecords, final DatabaseErrorListener listener) {
            return new DatabaseStorage(new DatabaseManager(sContext, database, table, version, schema, maxRecords, new DatabaseManager.ErrorListener(){

                @Override
                public void onError(String operation, RuntimeException e) {
                    listener.onError(operation, e);
                }
            }));
        }

        public long put(@NonNull ContentValues values) {
            return this.mDatabaseManager.put(values);
        }

        public boolean update(@IntRange(from=0L) long id, @NonNull ContentValues values) {
            return this.mDatabaseManager.update(id, values);
        }

        public void delete(@IntRange(from=0L) long id) {
            this.mDatabaseManager.delete(id);
        }

        public void delete(@NonNull List<Long> idList) {
            this.mDatabaseManager.delete(idList);
        }

        public void delete(@Nullable String key, @Nullable Object value) {
            this.mDatabaseManager.delete(key, value);
        }

        public ContentValues get(@IntRange(from=0L) long id) {
            return this.mDatabaseManager.get(id);
        }

        public ContentValues get(@Nullable String key, @Nullable Object value) {
            return this.mDatabaseManager.get(key, value);
        }

        public DatabaseScanner getScanner() {
            return this.getScanner(null, null);
        }

        public DatabaseScanner getScanner(@Nullable String key, @Nullable Object value) {
            return new DatabaseScanner(this.mDatabaseManager.getScanner(key, value));
        }

        public void clear() {
            this.mDatabaseManager.clear();
        }

        @Override
        public void close() throws IOException {
            this.mDatabaseManager.close();
        }

        public long size() {
            return this.mDatabaseManager.getRowCount();
        }

        @VisibleForTesting
        String[] getColumnNames() {
            return this.mDatabaseManager.getCursor(null, null).getColumnNames();
        }

        public static class DatabaseScanner
        implements Iterable<ContentValues>,
        Closeable {
            private final DatabaseManager.Scanner mScanner;

            private DatabaseScanner(DatabaseManager.Scanner scanner) {
                this.mScanner = scanner;
            }

            @Override
            public void close() {
                this.mScanner.close();
            }

            @Override
            public Iterator<ContentValues> iterator() {
                return this.mScanner.iterator();
            }

            public int getCount() {
                return this.mScanner.getCount();
            }
        }

        public static interface DatabaseErrorListener {
            public void onError(String var1, RuntimeException var2);
        }
    }

    public static class InternalStorage {
        public static String read(@NonNull String path) {
            return InternalStorage.read(new File(path));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String read(@NonNull File file) {
            try {
                StringBuilder contents;
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String line;
                    String lineSeparator = System.getProperty("line.separator");
                    contents = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        contents.append(line).append(lineSeparator);
                    }
                }
                return contents.toString();
            }
            catch (IOException e) {
                MobileCenterLog.error(StorageHelper.PREFERENCES_NAME, "Could not read file " + file.getAbsolutePath(), e);
                return null;
            }
        }

        public static void write(@NonNull String path, @NonNull String contents) throws IOException {
            InternalStorage.write(new File(path), contents);
        }

        public static void write(@NonNull File file, @NonNull String contents) throws IOException {
            if (TextUtils.isEmpty((CharSequence)contents) || TextUtils.getTrimmedLength((CharSequence)contents) <= 0) {
                return;
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write(contents);
            }
        }

        public static <T extends Serializable> T readObject(@NonNull File file) throws IOException, ClassNotFoundException {
            try (ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(file));){
                Serializable serializable = (Serializable)inputStream.readObject();
                return (T)serializable;
            }
        }

        public static <T extends Serializable> void writeObject(@NonNull File file, @NonNull T object) throws IOException {
            try (ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(file));){
                outputStream.writeObject(object);
            }
        }

        @NonNull
        public static String[] getFilenames(@NonNull String path, @Nullable FilenameFilter filter) {
            File dir = new File(path);
            if (dir.exists()) {
                return dir.list(filter);
            }
            return new String[0];
        }

        @Nullable
        public static File lastModifiedFile(@NonNull String path, @Nullable FilenameFilter filter) {
            return InternalStorage.lastModifiedFile(new File(path), filter);
        }

        @Nullable
        public static File lastModifiedFile(@NonNull File dir, @Nullable FilenameFilter filter) {
            if (dir.exists()) {
                File[] files = dir.listFiles(filter);
                long lastModification = 0L;
                File lastModifiedFile = null;
                if (files != null) {
                    for (File file : files) {
                        if (file.lastModified() <= lastModification) continue;
                        lastModification = file.lastModified();
                        lastModifiedFile = file;
                    }
                    return lastModifiedFile;
                }
            }
            return null;
        }

        public static boolean delete(@NonNull String path) {
            return InternalStorage.delete(new File(path));
        }

        public static boolean delete(@NonNull File file) {
            return file.delete();
        }

        public static void mkdir(@NonNull String path) {
            new File(path).mkdirs();
        }
    }

    public static class PreferencesStorage {
        public static boolean getBoolean(@NonNull String key) {
            return PreferencesStorage.getBoolean(key, false);
        }

        public static boolean getBoolean(@NonNull String key, boolean defValue) {
            return sSharedPreferences.getBoolean(key, defValue);
        }

        public static void putBoolean(@NonNull String key, boolean value) {
            SharedPreferences.Editor editor = sSharedPreferences.edit();
            editor.putBoolean(key, value);
            editor.apply();
        }

        public static float getFloat(@NonNull String key) {
            return PreferencesStorage.getFloat(key, 0.0f);
        }

        public static float getFloat(@NonNull String key, float defValue) {
            return sSharedPreferences.getFloat(key, defValue);
        }

        public static void putFloat(@NonNull String key, float value) {
            SharedPreferences.Editor editor = sSharedPreferences.edit();
            editor.putFloat(key, value);
            editor.apply();
        }

        public static int getInt(@NonNull String key) {
            return PreferencesStorage.getInt(key, 0);
        }

        public static int getInt(@NonNull String key, int defValue) {
            return sSharedPreferences.getInt(key, defValue);
        }

        public static void putInt(@NonNull String key, int value) {
            SharedPreferences.Editor editor = sSharedPreferences.edit();
            editor.putInt(key, value);
            editor.apply();
        }

        public static long getLong(@NonNull String key) {
            return PreferencesStorage.getLong(key, 0L);
        }

        public static long getLong(@NonNull String key, long defValue) {
            return sSharedPreferences.getLong(key, defValue);
        }

        public static void putLong(@NonNull String key, long value) {
            SharedPreferences.Editor editor = sSharedPreferences.edit();
            editor.putLong(key, value);
            editor.apply();
        }

        public static String getString(@NonNull String key) {
            return PreferencesStorage.getString(key, null);
        }

        public static String getString(@NonNull String key, String defValue) {
            return sSharedPreferences.getString(key, defValue);
        }

        public static void putString(@NonNull String key, String value) {
            SharedPreferences.Editor editor = sSharedPreferences.edit();
            editor.putString(key, value);
            editor.apply();
        }

        public static Set<String> getStringSet(@NonNull String key) {
            return PreferencesStorage.getStringSet(key, null);
        }

        public static Set<String> getStringSet(@NonNull String key, Set<String> defValue) {
            return sSharedPreferences.getStringSet(key, defValue);
        }

        public static void putStringSet(@NonNull String key, Set<String> value) {
            SharedPreferences.Editor editor = sSharedPreferences.edit();
            editor.putStringSet(key, value);
            editor.apply();
        }

        public static void remove(@NonNull String key) {
            SharedPreferences.Editor editor = sSharedPreferences.edit();
            editor.remove(key);
            editor.apply();
        }

        public static void clear() {
            SharedPreferences.Editor editor = sSharedPreferences.edit();
            editor.clear();
            editor.apply();
        }
    }
}

