/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.utils.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.storage.SQLiteUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class DatabaseManager
implements Closeable {
    public static final String PRIMARY_KEY = "oid";
    private static final String PRIMARY_KEY_SELECTION = "oid = ?";
    private final Context mContext;
    private final String mDatabase;
    private final String mTable;
    private final ContentValues mSchema;
    private final int mMaxNumberOfRecords;
    private final ErrorListener mErrorListener;
    private SQLiteOpenHelper mSQLiteOpenHelper;
    private Map<Long, ContentValues> mIMDB;
    private long mIMDBAutoInc;

    DatabaseManager(Context context, String database, String table, int version, ContentValues schema, ErrorListener listener) {
        this(context, database, table, version, schema, 0, listener);
    }

    DatabaseManager(Context context, String database, String table, int version, ContentValues schema, int maxRecords, ErrorListener listener) {
        this.mContext = context;
        this.mDatabase = database;
        this.mTable = table;
        this.mSchema = schema;
        this.mMaxNumberOfRecords = maxRecords;
        this.mErrorListener = listener;
        this.mSQLiteOpenHelper = new SQLiteOpenHelper(context, database, null, version){

            public void onCreate(SQLiteDatabase db) {
                StringBuilder sql = new StringBuilder("CREATE TABLE `");
                sql.append(DatabaseManager.this.mTable);
                sql.append("` (oid INTEGER PRIMARY KEY AUTOINCREMENT");
                for (Map.Entry col : DatabaseManager.this.mSchema.valueSet()) {
                    sql.append(", `").append((String)col.getKey()).append("` ");
                    Object val = col.getValue();
                    if (val instanceof Double || val instanceof Float) {
                        sql.append("REAL");
                        continue;
                    }
                    if (val instanceof Number || val instanceof Boolean) {
                        sql.append("INTEGER");
                        continue;
                    }
                    if (val instanceof byte[]) {
                        sql.append("BLOB");
                        continue;
                    }
                    sql.append("TEXT");
                }
                sql.append(");");
                db.execSQL(sql.toString());
            }

            public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
                db.execSQL("DROP TABLE `" + DatabaseManager.this.mTable + "`");
                this.onCreate(db);
            }
        };
    }

    private static ContentValues buildValues(Cursor cursor, ContentValues schema) {
        ContentValues values = new ContentValues();
        for (int i = 0; i < cursor.getColumnCount(); ++i) {
            if (cursor.isNull(i)) continue;
            String key = cursor.getColumnName(i);
            if (key.equals(PRIMARY_KEY)) {
                values.put(key, Long.valueOf(cursor.getLong(i)));
                continue;
            }
            Object specimen = schema.get(key);
            if (specimen instanceof byte[]) {
                values.put(key, cursor.getBlob(i));
                continue;
            }
            if (specimen instanceof Double) {
                values.put(key, Double.valueOf(cursor.getDouble(i)));
                continue;
            }
            if (specimen instanceof Float) {
                values.put(key, Float.valueOf(cursor.getFloat(i)));
                continue;
            }
            if (specimen instanceof Integer) {
                values.put(key, Integer.valueOf(cursor.getInt(i)));
                continue;
            }
            if (specimen instanceof Long) {
                values.put(key, Long.valueOf(cursor.getLong(i)));
                continue;
            }
            if (specimen instanceof Short) {
                values.put(key, Short.valueOf(cursor.getShort(i)));
                continue;
            }
            if (specimen instanceof Boolean) {
                values.put(key, Boolean.valueOf(cursor.getInt(i) == 1));
                continue;
            }
            values.put(key, cursor.getString(i));
        }
        return values;
    }

    public long put(@NonNull ContentValues values) {
        if (this.mIMDB == null) {
            try {
                long id = this.getDatabase().insertOrThrow(this.mTable, null, values);
                if ((long)this.mMaxNumberOfRecords < this.getRowCount() && this.mMaxNumberOfRecords > 0) {
                    Cursor cursor = this.getCursor(null, null);
                    cursor.moveToNext();
                    this.delete(cursor.getLong(0));
                    cursor.close();
                }
                return id;
            }
            catch (RuntimeException e) {
                this.switchToInMemory("put", e);
            }
        }
        values.put(PRIMARY_KEY, Long.valueOf(this.mIMDBAutoInc));
        this.mIMDB.put(this.mIMDBAutoInc, values);
        return this.mIMDBAutoInc++;
    }

    public boolean update(@IntRange(from=0L) long id, @NonNull ContentValues values) {
        ContentValues existValues;
        if (this.mIMDB == null) {
            try {
                return 0 < this.getDatabase().update(this.mTable, values, PRIMARY_KEY_SELECTION, new String[]{String.valueOf(id)});
            }
            catch (RuntimeException e) {
                this.switchToInMemory("update", e);
            }
        }
        if ((existValues = this.mIMDB.get(id)) == null) {
            return false;
        }
        existValues.putAll(values);
        return true;
    }

    public void delete(@IntRange(from=0L) long id) {
        this.delete(PRIMARY_KEY, id);
    }

    public void delete(@NonNull List<Long> idList) {
        if (idList.size() <= 0) {
            return;
        }
        if (this.mIMDB == null) {
            try {
                this.getDatabase().execSQL(String.format("DELETE FROM " + this.mTable + " WHERE " + PRIMARY_KEY + " IN (%s);", TextUtils.join((CharSequence)", ", idList)));
            }
            catch (RuntimeException e) {
                this.switchToInMemory("delete", e);
            }
        } else {
            for (Long id : idList) {
                this.mIMDB.remove(id);
            }
        }
    }

    public void delete(@Nullable String key, @Nullable Object value) {
        if (this.mIMDB == null) {
            try {
                this.getDatabase().delete(this.mTable, key + " = ?", new String[]{String.valueOf(value)});
            }
            catch (RuntimeException e) {
                this.switchToInMemory("delete", e);
            }
        } else if (PRIMARY_KEY.equals(key)) {
            if (value == null || !(value instanceof Number)) {
                throw new IllegalArgumentException("Primary key should be a number type and cannot be null");
            }
            this.mIMDB.remove(((Number)value).longValue());
        } else {
            Iterator<Map.Entry<Long, ContentValues>> iterator = this.mIMDB.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, ContentValues> entry = iterator.next();
                Object object = entry.getValue().get(key);
                if (object == null || !object.equals(value)) continue;
                iterator.remove();
            }
        }
    }

    public ContentValues get(@IntRange(from=0L) long id) {
        return this.get(PRIMARY_KEY, id);
    }

    public ContentValues get(@Nullable String key, @Nullable Object value) {
        if (this.mIMDB == null) {
            try {
                Cursor cursor = this.getCursor(key, value);
                ContentValues values = cursor.moveToFirst() ? DatabaseManager.buildValues(cursor, this.mSchema) : null;
                cursor.close();
                return values;
            }
            catch (RuntimeException e) {
                this.switchToInMemory("get", e);
            }
        } else {
            if (PRIMARY_KEY.equals(key)) {
                if (value == null || !(value instanceof Number)) {
                    throw new IllegalArgumentException("Primary key should be a number type and cannot be null");
                }
                return this.mIMDB.get(((Number)value).longValue());
            }
            for (ContentValues values : this.mIMDB.values()) {
                Object object = values.get(key);
                if (object == null || !object.equals(value)) continue;
                return values;
            }
        }
        return null;
    }

    Scanner getScanner(String key, Object value) {
        return new Scanner(key, value);
    }

    public void clear() {
        if (this.mIMDB == null) {
            try {
                this.getDatabase().delete(this.mTable, null, null);
            }
            catch (RuntimeException e) {
                this.switchToInMemory("clear", e);
            }
        } else {
            this.mIMDB.clear();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mIMDB == null) {
            try {
                this.getDatabase().close();
            }
            catch (RuntimeException e) {
                this.switchToInMemory("close", e);
            }
        } else {
            this.mIMDB.clear();
            this.mIMDB = null;
        }
    }

    final long getRowCount() {
        if (this.mIMDB == null) {
            try {
                return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.getDatabase(), (String)this.mTable);
            }
            catch (RuntimeException e) {
                this.switchToInMemory("count", e);
            }
        }
        return this.mIMDB.size();
    }

    Cursor getCursor(String key, Object value) throws RuntimeException {
        String[] selectionArgs;
        SQLiteQueryBuilder builder = SQLiteUtils.newSQLiteQueryBuilder();
        builder.setTables(this.mTable);
        if (key == null) {
            selectionArgs = null;
        } else if (value == null) {
            builder.appendWhere((CharSequence)(key + " IS NULL"));
            selectionArgs = null;
        } else {
            builder.appendWhere((CharSequence)(key + " = ?"));
            selectionArgs = new String[]{String.valueOf(value.toString())};
        }
        return builder.query(this.getDatabase(), null, null, selectionArgs, null, null, PRIMARY_KEY);
    }

    @VisibleForTesting
    SQLiteDatabase getDatabase() throws RuntimeException {
        try {
            return this.mSQLiteOpenHelper.getWritableDatabase();
        }
        catch (RuntimeException e) {
            this.mContext.deleteDatabase(this.mDatabase);
            return this.mSQLiteOpenHelper.getWritableDatabase();
        }
    }

    @VisibleForTesting
    void switchToInMemory(String operation, RuntimeException exception) {
        this.mIMDB = new LinkedHashMap<Long, ContentValues>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, ContentValues> eldest) {
                return DatabaseManager.this.mMaxNumberOfRecords < this.size() && DatabaseManager.this.mMaxNumberOfRecords > 0;
            }
        };
        if (this.mErrorListener != null) {
            this.mErrorListener.onError(operation, exception);
        }
    }

    @VisibleForTesting
    void setSQLiteOpenHelper(@NonNull SQLiteOpenHelper helper) {
        this.mSQLiteOpenHelper.close();
        this.mSQLiteOpenHelper = helper;
    }

    class Scanner
    implements Iterable<ContentValues>,
    Closeable {
        private final String key;
        private final Object value;
        private Cursor cursor;

        private Scanner(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public void close() {
            if (this.cursor != null) {
                try {
                    this.cursor.close();
                    this.cursor = null;
                }
                catch (RuntimeException e) {
                    DatabaseManager.this.switchToInMemory("scan.close", e);
                }
            }
        }

        @Override
        public Iterator<ContentValues> iterator() {
            if (DatabaseManager.this.mIMDB == null) {
                try {
                    this.close();
                    this.cursor = DatabaseManager.this.getCursor(this.key, this.value);
                    return new Iterator<ContentValues>(){
                        Boolean hasNext;

                        @Override
                        public boolean hasNext() {
                            if (this.hasNext == null) {
                                try {
                                    this.hasNext = Scanner.this.cursor.moveToNext();
                                }
                                catch (RuntimeException e) {
                                    this.hasNext = false;
                                    try {
                                        Scanner.this.cursor.close();
                                    }
                                    catch (RuntimeException e1) {
                                        MobileCenterLog.warn("MobileCenter", "Closing cursor failed", e1);
                                    }
                                    Scanner.this.cursor = null;
                                    DatabaseManager.this.switchToInMemory("scan.hasNext", e);
                                }
                            }
                            return this.hasNext;
                        }

                        @Override
                        public ContentValues next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            this.hasNext = null;
                            return DatabaseManager.buildValues(Scanner.this.cursor, DatabaseManager.this.mSchema);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                catch (RuntimeException e) {
                    DatabaseManager.this.switchToInMemory("scan.iterator", e);
                }
            }
            return new Iterator<ContentValues>(){
                final Iterator<ContentValues> iterator;
                boolean advanced;
                ContentValues next;
                {
                    this.iterator = DatabaseManager.this.mIMDB.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    if (!this.advanced) {
                        this.next = null;
                        while (this.iterator.hasNext()) {
                            ContentValues nextCandidate = this.iterator.next();
                            Object candidateValue = nextCandidate.get(Scanner.this.key);
                            if (Scanner.this.key != null && (Scanner.this.value == null || !Scanner.this.value.equals(candidateValue)) && (Scanner.this.value != null || candidateValue != null)) continue;
                            this.next = nextCandidate;
                            break;
                        }
                        this.advanced = true;
                    }
                    return this.next != null;
                }

                @Override
                public ContentValues next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.advanced = false;
                    return this.next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int getCount() {
            if (DatabaseManager.this.mIMDB == null) {
                try {
                    if (this.cursor == null) {
                        this.cursor = DatabaseManager.this.getCursor(this.key, this.value);
                    }
                    return this.cursor.getCount();
                }
                catch (RuntimeException e) {
                    DatabaseManager.this.switchToInMemory("scan.count", e);
                }
            }
            int count = 0;
            Iterator<ContentValues> iterator = this.iterator();
            while (iterator.hasNext()) {
                ++count;
                iterator.next();
            }
            return count;
        }
    }

    static interface ErrorListener {
        public void onError(String var1, RuntimeException var2);
    }
}

