/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion.http;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.ingestion.Ingestion;
import com.microsoft.azure.mobile.ingestion.ServiceCall;
import com.microsoft.azure.mobile.ingestion.ServiceCallback;
import com.microsoft.azure.mobile.ingestion.http.HttpUtils;
import com.microsoft.azure.mobile.ingestion.http.IngestionCallDecorator;
import com.microsoft.azure.mobile.ingestion.http.IngestionDecorator;
import com.microsoft.azure.mobile.ingestion.models.LogContainer;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class IngestionRetryer
extends IngestionDecorator {
    @VisibleForTesting
    static final long[] RETRY_INTERVALS = new long[]{TimeUnit.SECONDS.toMillis(10L), TimeUnit.MINUTES.toMillis(5L), TimeUnit.MINUTES.toMillis(20L)};
    private final Handler mHandler;
    private final Random mRandom = new Random();

    public IngestionRetryer(Ingestion decoratedApi) {
        this(decoratedApi, new Handler(Looper.getMainLooper()));
    }

    @VisibleForTesting
    IngestionRetryer(Ingestion decoratedApi, Handler handler) {
        super(decoratedApi);
        this.mHandler = handler;
    }

    @Override
    public ServiceCall sendAsync(UUID appSecret, UUID installId, LogContainer logContainer, ServiceCallback serviceCallback) throws IllegalArgumentException {
        RetryableCall retryableCall = new RetryableCall(this.mDecoratedApi, appSecret, installId, logContainer, serviceCallback);
        retryableCall.run();
        return retryableCall;
    }

    private class RetryableCall
    extends IngestionCallDecorator {
        private int mRetryCount;

        RetryableCall(Ingestion decoratedApi, UUID appSecret, UUID installId, LogContainer logContainer, ServiceCallback serviceCallback) {
            super(decoratedApi, appSecret, installId, logContainer, serviceCallback);
        }

        @Override
        public synchronized void cancel() {
            IngestionRetryer.this.mHandler.removeCallbacks((Runnable)this);
            super.cancel();
        }

        @Override
        public void onCallFailed(Exception e) {
            if (this.mRetryCount < RETRY_INTERVALS.length && HttpUtils.isRecoverableError(e)) {
                long delay = RETRY_INTERVALS[this.mRetryCount++] / 2L;
                delay += (long)IngestionRetryer.this.mRandom.nextInt((int)delay);
                String message = "Try #" + this.mRetryCount + " failed and will be retried in " + delay + " ms";
                if (e instanceof UnknownHostException) {
                    message = message + " (UnknownHostException)";
                }
                MobileCenterLog.warn("MobileCenter", message, e);
                IngestionRetryer.this.mHandler.postDelayed((Runnable)this, delay);
            } else {
                this.mServiceCallback.onCallFailed(e);
            }
        }
    }
}

