/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion.http;

import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.ingestion.Ingestion;
import com.microsoft.azure.mobile.ingestion.ServiceCall;
import com.microsoft.azure.mobile.ingestion.ServiceCallback;
import com.microsoft.azure.mobile.ingestion.http.HttpException;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.LogContainer;
import com.microsoft.azure.mobile.ingestion.models.json.LogSerializer;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.UUID;

public class IngestionHttp
implements Ingestion {
    private static final String DEFAULT_BASE_URL = "https://in.mobile.azure.com";
    private static final String API_PATH = "/logs?api_version=1.0.0-preview20160914";
    private static final String CONTENT_TYPE_VALUE = "application/json";
    private static final String APP_SECRET = "App-Secret";
    private static final String INSTALL_ID = "Install-ID";
    private static final int DEFAULT_STRING_BUILDER_CAPACITY = 16;
    private static final String CONTENT_TYPE_KEY = "Content-Type";
    private static final String CHARSET_NAME = "UTF-8";
    private static final int READ_BUFFER_SIZE = 1024;
    private static final int CONNECT_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 20000;
    private final LogSerializer mLogSerializer;
    private String mBaseUrl;

    public IngestionHttp(@NonNull LogSerializer logSerializer) {
        this.mLogSerializer = logSerializer;
        this.mBaseUrl = DEFAULT_BASE_URL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCall(String baseUrl, LogSerializer logSerializer, UUID appSecret, UUID installId, LogContainer logContainer) throws Exception {
        URL url = new URL(baseUrl + API_PATH);
        MobileCenterLog.verbose("MobileCenter", "Calling " + url + " ...");
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        try {
            String payload;
            urlConnection.setConnectTimeout(60000);
            urlConnection.setReadTimeout(20000);
            urlConnection.setRequestProperty(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE);
            urlConnection.setRequestProperty(APP_SECRET, appSecret.toString());
            urlConnection.setRequestProperty(INSTALL_ID, installId.toString());
            MobileCenterLog.verbose("MobileCenter", "Headers: " + urlConnection.getRequestProperties());
            List<Log> logs = logContainer.getLogs();
            int size = logs.size();
            long[] absoluteTimes = new long[size];
            for (int i = 0; i < size; ++i) {
                long toffset;
                Log log = logs.get(i);
                absoluteTimes[i] = toffset = log.getToffset();
                log.setToffset(System.currentTimeMillis() - toffset);
            }
            try {
                payload = logSerializer.serializeContainer(logContainer);
            }
            finally {
                for (int i = 0; i < size; ++i) {
                    logs.get(i).setToffset(absoluteTimes[i]);
                }
            }
            MobileCenterLog.verbose("MobileCenter", payload);
            byte[] binaryPayload = payload.getBytes(CHARSET_NAME);
            urlConnection.setDoOutput(true);
            urlConnection.setFixedLengthStreamingMode(binaryPayload.length);
            OutputStream out = urlConnection.getOutputStream();
            out.write(binaryPayload);
            out.close();
            int status = urlConnection.getResponseCode();
            String response = IngestionHttp.dump(urlConnection);
            MobileCenterLog.verbose("MobileCenter", "HTTP response status=" + status + " payload=" + response);
            if (status != 200) {
                throw new HttpException(status, response);
            }
        }
        finally {
            urlConnection.disconnect();
        }
    }

    private static String dump(HttpURLConnection urlConnection) throws IOException {
        int len;
        StringBuilder builder = new StringBuilder(Math.max(urlConnection.getContentLength(), 16));
        InputStream stream = urlConnection.getResponseCode() < 400 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
        InputStreamReader in = new InputStreamReader(stream, CHARSET_NAME);
        char[] buffer = new char[1024];
        while ((len = in.read(buffer)) > 0) {
            builder.append(buffer, 0, len);
        }
        return builder.toString();
    }

    @Override
    public void setServerUrl(@NonNull String baseUrl) {
        this.mBaseUrl = baseUrl;
    }

    @Override
    public ServiceCall sendAsync(UUID appSecret, UUID installId, LogContainer logContainer, ServiceCallback serviceCallback) throws IllegalArgumentException {
        final Call call = new Call(this.mBaseUrl, this.mLogSerializer, appSecret, installId, logContainer, serviceCallback);
        call.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return new ServiceCall(){

            @Override
            public void cancel() {
                if (!call.isCancelled()) {
                    call.cancel(true);
                }
            }
        };
    }

    @Override
    public void close() throws IOException {
    }

    @VisibleForTesting
    static class Call
    extends AsyncTask<Void, Void, Exception> {
        private final String mBaseUrl;
        private final LogSerializer mLogSerializer;
        private final UUID mAppSecret;
        private final UUID mInstallId;
        private final LogContainer mLogContainer;
        private final ServiceCallback mServiceCallback;

        Call(String baseUrl, LogSerializer logSerializer, UUID appSecret, UUID installId, LogContainer logContainer, ServiceCallback serviceCallback) {
            this.mBaseUrl = baseUrl;
            this.mLogSerializer = logSerializer;
            this.mAppSecret = appSecret;
            this.mInstallId = installId;
            this.mLogContainer = logContainer;
            this.mServiceCallback = serviceCallback;
        }

        protected Exception doInBackground(Void ... params) {
            try {
                IngestionHttp.doCall(this.mBaseUrl, this.mLogSerializer, this.mAppSecret, this.mInstallId, this.mLogContainer);
            }
            catch (Exception e) {
                return e;
            }
            return null;
        }

        protected void onPostExecute(Exception e) {
            if (e == null) {
                this.mServiceCallback.onCallSucceeded();
            } else {
                this.mServiceCallback.onCallFailed(e);
            }
        }
    }
}

