/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.utils.crypto;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Base64;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.crypto.CryptoAesHandler;
import com.microsoft.azure.mobile.utils.crypto.CryptoHandler;
import com.microsoft.azure.mobile.utils.crypto.CryptoNoOpHandler;
import com.microsoft.azure.mobile.utils.crypto.CryptoRsaHandler;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;

public class CryptoUtils {
    @VisibleForTesting
    static final ICryptoFactory DEFAULT_CRYPTO_FACTORY = new ICryptoFactory(){

        @Override
        public IKeyGenerator getKeyGenerator(String algorithm, String provider) throws Exception {
            final KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm, provider);
            return new IKeyGenerator(){

                @Override
                public void init(AlgorithmParameterSpec parameters) throws Exception {
                    keyGenerator.init(parameters);
                }

                @Override
                public void generateKey() {
                    keyGenerator.generateKey();
                }
            };
        }

        @Override
        public ICipher getCipher(String transformation, String provider) throws Exception {
            final Cipher cipher = Cipher.getInstance(transformation, provider);
            return new ICipher(){

                @Override
                public void init(int opMode, Key key) throws Exception {
                    cipher.init(opMode, key);
                }

                @Override
                public void init(int opMode, Key key, AlgorithmParameterSpec params) throws Exception {
                    cipher.init(opMode, key, params);
                }

                @Override
                public byte[] doFinal(byte[] input) throws Exception {
                    return cipher.doFinal(input);
                }

                @Override
                public byte[] doFinal(byte[] input, int inputOffset, int inputLength) throws Exception {
                    return cipher.doFinal(input, inputOffset, inputLength);
                }

                @Override
                public byte[] getIV() {
                    return cipher.getIV();
                }

                @Override
                public int getBlockSize() {
                    return cipher.getBlockSize();
                }

                @Override
                public String getAlgorithm() {
                    return cipher.getAlgorithm();
                }

                @Override
                public String getProvider() {
                    return cipher.getProvider().getName();
                }
            };
        }
    };
    @SuppressLint(value={"StaticFieldLeak"})
    private static CryptoUtils sInstance;
    private final Context mContext;
    private final ICryptoFactory mCryptoFactory;
    private final int mApiLevel;
    private final KeyStore mKeyStore;
    private final Map<String, CryptoHandlerEntry> mCryptoHandlers = new LinkedHashMap<String, CryptoHandlerEntry>();

    private CryptoUtils(@NonNull Context context) {
        this(context, DEFAULT_CRYPTO_FACTORY, Build.VERSION.SDK_INT);
    }

    @VisibleForTesting
    @TargetApi(value=23)
    CryptoUtils(@NonNull Context context, @NonNull ICryptoFactory cryptoFactory, int apiLevel) {
        this.mContext = context.getApplicationContext();
        this.mCryptoFactory = cryptoFactory;
        this.mApiLevel = apiLevel;
        KeyStore keyStore = null;
        if (apiLevel >= 19) {
            try {
                keyStore = KeyStore.getInstance("AndroidKeyStore");
                keyStore.load(null);
            }
            catch (Exception e) {
                MobileCenterLog.error("MobileCenter", "Cannot use secure keystore on this device.");
            }
        }
        this.mKeyStore = keyStore;
        if (keyStore != null && apiLevel >= 23) {
            try {
                this.registerHandler(new CryptoAesHandler());
            }
            catch (Exception e) {
                MobileCenterLog.error("MobileCenter", "Cannot use modern encryption on this device.");
            }
        }
        if (keyStore != null) {
            try {
                this.registerHandler(new CryptoRsaHandler());
            }
            catch (Exception e) {
                MobileCenterLog.error("MobileCenter", "Cannot use old encryption on this device.");
            }
        }
        CryptoNoOpHandler cryptoNoOpHandler = new CryptoNoOpHandler();
        this.mCryptoHandlers.put(cryptoNoOpHandler.getAlgorithm(), new CryptoHandlerEntry(0, cryptoNoOpHandler));
    }

    public static CryptoUtils getInstance(@NonNull Context context) {
        if (sInstance == null) {
            sInstance = new CryptoUtils(context);
        }
        return sInstance;
    }

    @VisibleForTesting
    ICryptoFactory getCryptoFactory() {
        return this.mCryptoFactory;
    }

    private void registerHandler(@NonNull CryptoHandler handler) throws Exception {
        String alias0 = this.getAlias(handler, 0);
        String alias1 = this.getAlias(handler, 1);
        Date aliasDate0 = this.mKeyStore.getCreationDate(alias0);
        Date aliasDate1 = this.mKeyStore.getCreationDate(alias1);
        int index = 0;
        String alias = alias0;
        if (aliasDate1 != null && aliasDate1.after(aliasDate0)) {
            index = 1;
            alias = alias1;
        }
        if (this.mCryptoHandlers.isEmpty() && !this.mKeyStore.containsAlias(alias)) {
            MobileCenterLog.debug("MobileCenter", "Creating alias: " + alias);
            handler.generateKey(this.mCryptoFactory, alias, this.mContext);
        }
        MobileCenterLog.debug("MobileCenter", "Using " + alias);
        this.mCryptoHandlers.put(handler.getAlgorithm(), new CryptoHandlerEntry(index, handler));
    }

    @NonNull
    private String getAlias(@NonNull CryptoHandler handler, int index) {
        return "mobile.center." + index + "." + handler.getAlgorithm();
    }

    @Nullable
    private KeyStore.Entry getKeyStoreEntry(@NonNull CryptoHandlerEntry handlerEntry) throws Exception {
        if (this.mKeyStore == null) {
            return null;
        }
        String alias = this.getAlias(handlerEntry.mCryptoHandler, handlerEntry.mAliasIndex);
        return this.mKeyStore.getEntry(alias, null);
    }

    @Nullable
    public String encrypt(@Nullable String data) {
        if (data == null) {
            return null;
        }
        try {
            CryptoHandlerEntry handlerEntry = this.mCryptoHandlers.values().iterator().next();
            CryptoHandler handler = handlerEntry.mCryptoHandler;
            try {
                KeyStore.Entry keyStoreEntry = this.getKeyStoreEntry(handlerEntry);
                byte[] encryptedBytes = handler.encrypt(this.mCryptoFactory, this.mApiLevel, keyStoreEntry, data.getBytes("UTF-8"));
                String encryptedString = Base64.encodeToString((byte[])encryptedBytes, (int)0);
                return handler.getAlgorithm() + ":" + encryptedString;
            }
            catch (InvalidKeyException e) {
                MobileCenterLog.debug("MobileCenter", "Alias expired: " + handlerEntry.mAliasIndex);
                handlerEntry.mAliasIndex ^= 1;
                String newAlias = this.getAlias(handler, handlerEntry.mAliasIndex);
                if (this.mKeyStore.containsAlias(newAlias)) {
                    MobileCenterLog.debug("MobileCenter", "Deleting alias: " + newAlias);
                    this.mKeyStore.deleteEntry(newAlias);
                }
                MobileCenterLog.debug("MobileCenter", "Creating alias: " + newAlias);
                handler.generateKey(this.mCryptoFactory, newAlias, this.mContext);
                return this.encrypt(data);
            }
        }
        catch (Exception e) {
            MobileCenterLog.error("MobileCenter", "Failed to encrypt data.");
            return data;
        }
    }

    @NonNull
    public DecryptedData decrypt(@Nullable String data) {
        if (data == null) {
            return new DecryptedData(null, null);
        }
        String[] dataSplit = data.split(":");
        CryptoHandlerEntry handlerEntry = dataSplit.length == 2 ? this.mCryptoHandlers.get(dataSplit[0]) : null;
        CryptoHandler cryptoHandler = handlerEntry == null ? null : handlerEntry.mCryptoHandler;
        try {
            if (cryptoHandler == null) {
                throw new IllegalStateException("Could not find crypto handler that was used for the specified data.");
            }
            KeyStore.Entry keyStoreEntry = this.getKeyStoreEntry(handlerEntry);
            byte[] decryptedBytes = cryptoHandler.decrypt(this.mCryptoFactory, this.mApiLevel, keyStoreEntry, Base64.decode((String)dataSplit[1], (int)0));
            String decryptedString = new String(decryptedBytes, "UTF-8");
            String newEncryptedData = null;
            if (cryptoHandler != this.mCryptoHandlers.values().iterator().next().mCryptoHandler) {
                newEncryptedData = this.encrypt(decryptedString);
            }
            return new DecryptedData(decryptedString, newEncryptedData);
        }
        catch (Exception e) {
            MobileCenterLog.error("MobileCenter", "Failed to decrypt data.");
            return new DecryptedData(data, null);
        }
    }

    public static class DecryptedData {
        final String mDecryptedData;
        final String mNewEncryptedData;

        @VisibleForTesting
        public DecryptedData(String decryptedData, String newEncryptedData) {
            this.mDecryptedData = decryptedData;
            this.mNewEncryptedData = newEncryptedData;
        }

        public String getDecryptedData() {
            return this.mDecryptedData;
        }

        public String getNewEncryptedData() {
            return this.mNewEncryptedData;
        }
    }

    private static class CryptoHandlerEntry {
        final CryptoHandler mCryptoHandler;
        int mAliasIndex;

        CryptoHandlerEntry(int aliasIndex, CryptoHandler cryptoHandler) {
            this.mAliasIndex = aliasIndex;
            this.mCryptoHandler = cryptoHandler;
        }
    }

    static interface ICipher {
        public void init(int var1, Key var2) throws Exception;

        public void init(int var1, Key var2, AlgorithmParameterSpec var3) throws Exception;

        public byte[] doFinal(byte[] var1) throws Exception;

        public byte[] doFinal(byte[] var1, int var2, int var3) throws Exception;

        public byte[] getIV();

        public int getBlockSize();

        @VisibleForTesting
        public String getAlgorithm();

        @VisibleForTesting
        public String getProvider();
    }

    static interface IKeyGenerator {
        public void init(AlgorithmParameterSpec var1) throws Exception;

        public void generateKey();
    }

    static interface ICryptoFactory {
        public IKeyGenerator getKeyGenerator(String var1, String var2) throws Exception;

        public ICipher getCipher(String var1, String var2) throws Exception;
    }
}

