/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.utils;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;

public class NetworkStateHelper
implements Closeable {
    @SuppressLint(value={"StaticFieldLeak"})
    private static NetworkStateHelper sSharedInstance;
    private final Context mContext;
    private final ConnectivityManager mConnectivityManager;
    private final ConnectivityReceiver mConnectivityReceiver;
    private final Set<Listener> mListeners = new HashSet<Listener>();
    private String mNetworkType;

    @VisibleForTesting
    NetworkStateHelper(Context context) {
        this.mContext = context.getApplicationContext();
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.mConnectivityReceiver = new ConnectivityReceiver();
        this.updateNetworkType();
        context.registerReceiver((BroadcastReceiver)this.mConnectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public static NetworkStateHelper getSharedInstance(Context context) {
        if (sSharedInstance == null) {
            sSharedInstance = new NetworkStateHelper(context);
        }
        return sSharedInstance;
    }

    public boolean isNetworkConnected() {
        return this.mNetworkType != null;
    }

    private void updateNetworkType() {
        NetworkInfo networkInfo;
        try {
            networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        }
        catch (RuntimeException e) {
            networkInfo = null;
            MobileCenterLog.error("MobileCenter", "Could not get network info and thus stuck in disconnected state, please check you declared android.permission.ACCESS_NETWORK_STATE");
        }
        this.updateNetworkType(networkInfo);
    }

    private void updateNetworkType(NetworkInfo networkInfo) {
        MobileCenterLog.debug("MobileCenter", "Active network info=" + networkInfo);
        this.mNetworkType = networkInfo != null && networkInfo.isConnected() ? networkInfo.getTypeName() + networkInfo.getSubtypeName() : null;
    }

    private void notifyNetworkStateUpdated(boolean connected) {
        for (Listener listener : this.mListeners) {
            listener.onNetworkStateUpdated(connected);
        }
    }

    @Override
    public void close() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mConnectivityReceiver);
    }

    public void addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    private class ConnectivityReceiver
    extends BroadcastReceiver {
        private ConnectivityReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            boolean networkTypeChanged;
            String previousNetworkType = NetworkStateHelper.this.mNetworkType;
            NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            NetworkStateHelper.this.updateNetworkType(networkInfo);
            boolean bl = previousNetworkType == null ? NetworkStateHelper.this.mNetworkType != null : (networkTypeChanged = !previousNetworkType.equals(NetworkStateHelper.this.mNetworkType));
            if (networkTypeChanged) {
                boolean connected = NetworkStateHelper.this.isNetworkConnected();
                if (connected && previousNetworkType != null) {
                    NetworkStateHelper.this.notifyNetworkStateUpdated(false);
                }
                NetworkStateHelper.this.notifyNetworkStateUpdated(connected);
            }
        }
    }

    public static interface Listener {
        public void onNetworkStateUpdated(boolean var1);
    }
}

