/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.utils;

import android.support.annotation.IntRange;
import android.util.Log;

public class MobileCenterLog {
    public static final String LOG_TAG = "MobileCenter";
    public static final int NONE = 8;
    private static int sLogLevel = 7;

    @IntRange(from=2L, to=8L)
    public static int getLogLevel() {
        return sLogLevel;
    }

    public static void setLogLevel(@IntRange(from=2L, to=8L) int logLevel) {
        sLogLevel = logLevel;
    }

    public static void verbose(String tag, String message) {
        if (sLogLevel <= 2) {
            Log.v((String)tag, (String)message);
        }
    }

    public static void verbose(String tag, String message, Throwable throwable) {
        if (sLogLevel <= 2) {
            Log.v((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void debug(String tag, String message) {
        if (sLogLevel <= 3) {
            Log.d((String)tag, (String)message);
        }
    }

    public static void debug(String tag, String message, Throwable throwable) {
        if (sLogLevel <= 3) {
            Log.d((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void info(String tag, String message) {
        if (sLogLevel <= 4) {
            Log.i((String)tag, (String)message);
        }
    }

    public static void info(String tag, String message, Throwable throwable) {
        if (sLogLevel <= 4) {
            Log.i((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void warn(String tag, String message) {
        if (sLogLevel <= 5) {
            Log.w((String)tag, (String)message);
        }
    }

    public static void warn(String tag, String message, Throwable throwable) {
        if (sLogLevel <= 5) {
            Log.w((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void error(String tag, String message) {
        if (sLogLevel <= 6) {
            Log.e((String)tag, (String)message);
        }
    }

    public static void error(String tag, String message, Throwable throwable) {
        if (sLogLevel <= 6) {
            Log.e((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void logAssert(String tag, String message) {
        if (sLogLevel <= 7) {
            Log.println((int)7, (String)tag, (String)message);
        }
    }

    public static void logAssert(String tag, String message, Throwable throwable) {
        if (sLogLevel <= 7) {
            Log.println((int)7, (String)tag, (String)(message + "\n" + Log.getStackTraceString((Throwable)throwable)));
        }
    }
}

