/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.ingestion;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.http.DefaultHttpClient;
import com.microsoft.azure.mobile.http.HttpClient;
import com.microsoft.azure.mobile.http.HttpClientNetworkStateHandler;
import com.microsoft.azure.mobile.http.HttpClientRetryer;
import com.microsoft.azure.mobile.http.HttpUtils;
import com.microsoft.azure.mobile.http.ServiceCall;
import com.microsoft.azure.mobile.http.ServiceCallback;
import com.microsoft.azure.mobile.ingestion.Ingestion;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.LogContainer;
import com.microsoft.azure.mobile.ingestion.models.json.LogSerializer;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.NetworkStateHelper;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;

public class IngestionHttp
implements Ingestion {
    public static final String DEFAULT_LOG_URL = "https://in.mobile.azure.com";
    @VisibleForTesting
    static final String API_PATH = "/logs?api_version=1.0.0-preview20160914";
    @VisibleForTesting
    static final String INSTALL_ID = "Install-ID";
    private final LogSerializer mLogSerializer;
    private final HttpClient mHttpClient;
    private String mLogUrl;

    public IngestionHttp(@NonNull Context context, @NonNull LogSerializer logSerializer) {
        this.mLogSerializer = logSerializer;
        HttpClientRetryer retryer = new HttpClientRetryer(new DefaultHttpClient());
        NetworkStateHelper networkStateHelper = NetworkStateHelper.getSharedInstance(context);
        this.mHttpClient = new HttpClientNetworkStateHandler(retryer, networkStateHelper);
        this.mLogUrl = DEFAULT_LOG_URL;
    }

    @Override
    public void setLogUrl(@NonNull String logUrl) {
        this.mLogUrl = logUrl;
    }

    @Override
    public ServiceCall sendAsync(String appSecret, UUID installId, LogContainer logContainer, ServiceCallback serviceCallback) throws IllegalArgumentException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(INSTALL_ID, installId.toString());
        headers.put("App-Secret", appSecret);
        IngestionCallTemplate callTemplate = new IngestionCallTemplate(this.mLogSerializer, logContainer);
        return this.mHttpClient.callAsync(this.mLogUrl + API_PATH, "METHOD_POST", headers, callTemplate, serviceCallback);
    }

    @Override
    public void close() throws IOException {
        this.mHttpClient.close();
    }

    private static class IngestionCallTemplate
    implements HttpClient.CallTemplate {
        private final LogSerializer mLogSerializer;
        private final LogContainer mLogContainer;

        IngestionCallTemplate(LogSerializer logSerializer, LogContainer logContainer) {
            this.mLogSerializer = logSerializer;
            this.mLogContainer = logContainer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String buildRequestBody() throws JSONException {
            String payload;
            List<Log> logs = this.mLogContainer.getLogs();
            int size = logs.size();
            long[] absoluteTimes = new long[size];
            for (int i = 0; i < size; ++i) {
                long toffset;
                Log log = logs.get(i);
                absoluteTimes[i] = toffset = log.getToffset();
                log.setToffset(System.currentTimeMillis() - toffset);
            }
            try {
                payload = this.mLogSerializer.serializeContainer(this.mLogContainer);
            }
            finally {
                for (int i = 0; i < size; ++i) {
                    logs.get(i).setToffset(absoluteTimes[i]);
                }
            }
            return payload;
        }

        @Override
        public void onBeforeCalling(URL url, Map<String, String> headers) {
            if (MobileCenterLog.getLogLevel() <= 2) {
                MobileCenterLog.verbose("MobileCenter", "Calling " + url + "...");
                HashMap<String, String> logHeaders = new HashMap<String, String>(headers);
                String appSecret = (String)logHeaders.get("App-Secret");
                if (appSecret != null) {
                    logHeaders.put("App-Secret", HttpUtils.hideSecret(appSecret));
                }
                MobileCenterLog.verbose("MobileCenter", "Headers: " + logHeaders);
            }
        }
    }
}

