/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.http;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.http.HttpClient;
import com.microsoft.azure.mobile.http.HttpClientCallDecorator;
import com.microsoft.azure.mobile.http.HttpClientDecorator;
import com.microsoft.azure.mobile.http.HttpUtils;
import com.microsoft.azure.mobile.http.ServiceCall;
import com.microsoft.azure.mobile.http.ServiceCallback;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class HttpClientRetryer
extends HttpClientDecorator {
    @VisibleForTesting
    static final long[] RETRY_INTERVALS = new long[]{TimeUnit.SECONDS.toMillis(10L), TimeUnit.MINUTES.toMillis(5L), TimeUnit.MINUTES.toMillis(20L)};
    private final Handler mHandler;
    private final Random mRandom = new Random();

    public HttpClientRetryer(HttpClient decoratedApi) {
        this(decoratedApi, new Handler(Looper.getMainLooper()));
    }

    @VisibleForTesting
    HttpClientRetryer(HttpClient decoratedApi, Handler handler) {
        super(decoratedApi);
        this.mHandler = handler;
    }

    @Override
    public ServiceCall callAsync(String url, String method, Map<String, String> headers, HttpClient.CallTemplate callTemplate, ServiceCallback serviceCallback) {
        RetryableCall retryableCall = new RetryableCall(this.mDecoratedApi, url, method, headers, callTemplate, serviceCallback);
        retryableCall.run();
        return retryableCall;
    }

    private class RetryableCall
    extends HttpClientCallDecorator {
        private int mRetryCount;

        RetryableCall(HttpClient decoratedApi, String url, String method, Map<String, String> headers, HttpClient.CallTemplate callTemplate, ServiceCallback serviceCallback) {
            super(decoratedApi, url, method, headers, callTemplate, serviceCallback);
        }

        @Override
        public synchronized void cancel() {
            HttpClientRetryer.this.mHandler.removeCallbacks((Runnable)this);
            super.cancel();
        }

        @Override
        public void onCallFailed(Exception e) {
            if (this.mRetryCount < RETRY_INTERVALS.length && HttpUtils.isRecoverableError(e)) {
                long delay = RETRY_INTERVALS[this.mRetryCount++] / 2L;
                delay += (long)HttpClientRetryer.this.mRandom.nextInt((int)delay);
                String message = "Try #" + this.mRetryCount + " failed and will be retried in " + delay + " ms";
                if (e instanceof UnknownHostException) {
                    message = message + " (UnknownHostException)";
                }
                MobileCenterLog.warn("MobileCenter", message, e);
                HttpClientRetryer.this.mHandler.postDelayed((Runnable)this, delay);
            } else {
                this.mServiceCallback.onCallFailed(e);
            }
        }
    }
}

