/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.microsoft.azure.mobile.MobileCenterHandler;
import com.microsoft.azure.mobile.MobileCenterService;
import com.microsoft.azure.mobile.channel.Channel;
import com.microsoft.azure.mobile.ingestion.models.json.LogFactory;
import com.microsoft.azure.mobile.utils.HandlerUtils;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.async.DefaultMobileCenterFuture;
import com.microsoft.azure.mobile.utils.async.MobileCenterFuture;
import com.microsoft.azure.mobile.utils.storage.StorageHelper;
import java.util.Map;

public abstract class AbstractMobileCenterService
implements MobileCenterService {
    private static final String PREFERENCE_KEY_SEPARATOR = "_";
    protected Channel mChannel;
    private MobileCenterHandler mHandler;

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    protected synchronized MobileCenterFuture<Boolean> isInstanceEnabledAsync() {
        final DefaultMobileCenterFuture<Boolean> future = new DefaultMobileCenterFuture<Boolean>();
        this.postAsyncGetter(new Runnable(){

            @Override
            public void run() {
                future.complete(true);
            }
        }, future, false);
        return future;
    }

    protected final synchronized MobileCenterFuture<Void> setInstanceEnabledAsync(final boolean enabled) {
        final DefaultMobileCenterFuture<Void> future = new DefaultMobileCenterFuture<Void>();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractMobileCenterService.this.setInstanceEnabled(enabled);
                future.complete(null);
            }
        };
        Runnable coreDisabledRunnable = new Runnable(){

            @Override
            public void run() {
                MobileCenterLog.error("MobileCenter", "Mobile Center SDK is disabled.");
                future.complete(null);
            }
        };
        if (!this.post(runnable, coreDisabledRunnable, runnable)) {
            future.complete(null);
        }
        return future;
    }

    @Override
    public synchronized boolean isInstanceEnabled() {
        return StorageHelper.PreferencesStorage.getBoolean(this.getEnabledPreferenceKey(), true);
    }

    @Override
    public synchronized void setInstanceEnabled(boolean enabled) {
        if (enabled == this.isInstanceEnabled()) {
            MobileCenterLog.info(this.getLoggerTag(), String.format("%s service has already been %s.", this.getServiceName(), enabled ? "enabled" : "disabled"));
            return;
        }
        String groupName = this.getGroupName();
        if (groupName != null) {
            if (enabled) {
                this.mChannel.addGroup(groupName, this.getTriggerCount(), this.getTriggerInterval(), this.getTriggerMaxParallelRequests(), this.getChannelListener());
            } else {
                this.mChannel.clear(groupName);
                this.mChannel.removeGroup(groupName);
            }
        }
        StorageHelper.PreferencesStorage.putBoolean(this.getEnabledPreferenceKey(), enabled);
        MobileCenterLog.info(this.getLoggerTag(), String.format("%s service has been %s.", this.getServiceName(), enabled ? "enabled" : "disabled"));
        this.applyEnabledState(enabled);
    }

    protected synchronized void applyEnabledState(boolean enabled) {
    }

    @Override
    public final synchronized void onStarting(@NonNull MobileCenterHandler handler) {
        this.mHandler = handler;
    }

    @Override
    public synchronized void onStarted(@NonNull Context context, @NonNull String appSecret, @NonNull Channel channel) {
        String groupName = this.getGroupName();
        boolean enabled = this.isInstanceEnabled();
        if (groupName != null) {
            channel.removeGroup(groupName);
            if (enabled) {
                channel.addGroup(groupName, this.getTriggerCount(), this.getTriggerInterval(), this.getTriggerMaxParallelRequests(), this.getChannelListener());
            } else {
                channel.clear(groupName);
            }
        }
        this.mChannel = channel;
        if (enabled) {
            this.applyEnabledState(true);
        }
    }

    @Override
    public Map<String, LogFactory> getLogFactories() {
        return null;
    }

    protected abstract String getGroupName();

    protected abstract String getLoggerTag();

    @NonNull
    protected String getEnabledPreferenceKey() {
        return "enabled_" + this.getServiceName();
    }

    protected int getTriggerCount() {
        return 50;
    }

    protected int getTriggerInterval() {
        return 3000;
    }

    protected int getTriggerMaxParallelRequests() {
        return 3;
    }

    protected Channel.GroupListener getChannelListener() {
        return null;
    }

    protected synchronized void post(Runnable runnable) {
        this.post(runnable, null, null);
    }

    protected synchronized boolean post(final Runnable runnable, Runnable coreDisabledRunnable, final Runnable serviceDisabledRunnable) {
        if (this.mHandler == null) {
            MobileCenterLog.error("MobileCenter", this.getServiceName() + " needs to be started before it can be used.");
            return false;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AbstractMobileCenterService.this.isInstanceEnabled()) {
                    runnable.run();
                } else if (serviceDisabledRunnable != null) {
                    serviceDisabledRunnable.run();
                } else {
                    MobileCenterLog.info("MobileCenter", AbstractMobileCenterService.this.getServiceName() + " service disabled, discarding calls.");
                }
            }
        }, coreDisabledRunnable);
        return true;
    }

    protected synchronized <T> void postAsyncGetter(final Runnable runnable, final DefaultMobileCenterFuture<T> future, final T valueIfDisabledOrNotStarted) {
        Runnable disabledOrNotStartedRunnable = new Runnable(){

            @Override
            public void run() {
                future.complete(valueIfDisabledOrNotStarted);
            }
        };
        if (!this.post(new Runnable(){

            @Override
            public void run() {
                runnable.run();
            }
        }, disabledOrNotStartedRunnable, disabledOrNotStartedRunnable)) {
            disabledOrNotStartedRunnable.run();
        }
    }

    protected synchronized void postOnUiThread(final Runnable runnable) {
        this.post(new Runnable(){

            @Override
            public void run() {
                HandlerUtils.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        AbstractMobileCenterService.this.runIfEnabled(runnable);
                    }
                });
            }
        }, new Runnable(){

            @Override
            public void run() {
            }
        }, null);
    }

    private synchronized void runIfEnabled(Runnable runnable) {
        if (this.isInstanceEnabled()) {
            runnable.run();
        }
    }
}

