/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.mobile.analytics;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.microsoft.azure.mobile.AbstractMobileCenterService;
import com.microsoft.azure.mobile.analytics.channel.AnalyticsListener;
import com.microsoft.azure.mobile.analytics.channel.SessionTracker;
import com.microsoft.azure.mobile.analytics.ingestion.models.EventLog;
import com.microsoft.azure.mobile.analytics.ingestion.models.PageLog;
import com.microsoft.azure.mobile.analytics.ingestion.models.json.EventLogFactory;
import com.microsoft.azure.mobile.analytics.ingestion.models.json.PageLogFactory;
import com.microsoft.azure.mobile.analytics.ingestion.models.json.StartSessionLogFactory;
import com.microsoft.azure.mobile.channel.Channel;
import com.microsoft.azure.mobile.ingestion.models.Log;
import com.microsoft.azure.mobile.ingestion.models.json.LogFactory;
import com.microsoft.azure.mobile.utils.MobileCenterLog;
import com.microsoft.azure.mobile.utils.UUIDUtils;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class Analytics
extends AbstractMobileCenterService {
    private static final String SERVICE_NAME = "Analytics";
    public static final String LOG_TAG = "MobileCenterAnalytics";
    private static final String ANALYTICS_GROUP = "group_analytics";
    private static final String ACTIVITY_SUFFIX = "Activity";
    private static Analytics sInstance = null;
    private final Map<String, LogFactory> mFactories = new HashMap<String, LogFactory>();
    private WeakReference<Activity> mCurrentActivity;
    private SessionTracker mSessionTracker;
    private AnalyticsListener mAnalyticsListener;
    private boolean mAutoPageTrackingEnabled = false;

    private Analytics() {
        this.mFactories.put("start_session", new StartSessionLogFactory());
        this.mFactories.put("page", new PageLogFactory());
        this.mFactories.put("event", new EventLogFactory());
    }

    public static synchronized Analytics getInstance() {
        if (sInstance == null) {
            sInstance = new Analytics();
        }
        return sInstance;
    }

    @VisibleForTesting
    static synchronized void unsetInstance() {
        sInstance = null;
    }

    public static boolean isEnabled() {
        return Analytics.getInstance().isInstanceEnabled();
    }

    public static void setEnabled(boolean enabled) {
        Analytics.getInstance().setInstanceEnabled(enabled);
    }

    @VisibleForTesting
    protected static void setListener(AnalyticsListener listener) {
        Analytics.getInstance().setInstanceListener(listener);
    }

    static boolean isAutoPageTrackingEnabled() {
        return Analytics.getInstance().isInstanceAutoPageTrackingEnabled();
    }

    static void setAutoPageTrackingEnabled(boolean autoPageTrackingEnabled) {
        Analytics.getInstance().setInstanceAutoPageTrackingEnabled(autoPageTrackingEnabled);
    }

    static void trackPage(String name) {
        Analytics.trackPage(name, null);
    }

    static void trackPage(String name, Map<String, String> properties) {
        String logType = "Page";
        if (Analytics.validateName(name, "Page")) {
            Map<String, String> validatedProperties = Analytics.validateProperties(properties, name, "Page");
            Analytics.getInstance().queuePage(name, validatedProperties);
        }
    }

    public static void trackEvent(String name) {
        Analytics.trackEvent(name, null);
    }

    public static void trackEvent(String name, Map<String, String> properties) {
        String logType = "Event";
        if (Analytics.validateName(name, "Event")) {
            Map<String, String> validatedProperties = Analytics.validateProperties(properties, name, "Event");
            Analytics.getInstance().queueEvent(name, validatedProperties);
        }
    }

    private static String generatePageName(Class<?> activityClass) {
        String suffix;
        String name = activityClass.getSimpleName();
        if (name.endsWith(suffix = ACTIVITY_SUFFIX) && name.length() > suffix.length()) {
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }

    protected String getGroupName() {
        return ANALYTICS_GROUP;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    protected String getLoggerTag() {
        return LOG_TAG;
    }

    public Map<String, LogFactory> getLogFactories() {
        return this.mFactories;
    }

    public synchronized void onStarted(@NonNull Context context, @NonNull String appSecret, @NonNull Channel channel) {
        super.onStarted(context, appSecret, channel);
        this.applyEnabledState(this.isInstanceEnabled());
    }

    public synchronized void onActivityResumed(Activity activity) {
        this.mCurrentActivity = new WeakReference<Activity>(activity);
        if (this.mSessionTracker != null) {
            this.processOnResume(activity);
        }
    }

    private void processOnResume(Activity activity) {
        this.mSessionTracker.onActivityResumed();
        if (this.mAutoPageTrackingEnabled) {
            this.queuePage(Analytics.generatePageName(activity.getClass()), null);
        }
    }

    public synchronized void onActivityPaused(Activity activity) {
        this.mCurrentActivity = null;
        if (this.mSessionTracker != null) {
            this.mSessionTracker.onActivityPaused();
        }
    }

    public synchronized void setInstanceEnabled(boolean enabled) {
        super.setInstanceEnabled(enabled);
        this.applyEnabledState(enabled);
    }

    protected Channel.GroupListener getChannelListener() {
        return new Channel.GroupListener(){

            public void onBeforeSending(Log log) {
                if (Analytics.this.mAnalyticsListener != null) {
                    Analytics.this.mAnalyticsListener.onBeforeSending(log);
                }
            }

            public void onSuccess(Log log) {
                if (Analytics.this.mAnalyticsListener != null) {
                    Analytics.this.mAnalyticsListener.onSendingSucceeded(log);
                }
            }

            public void onFailure(Log log, Exception e) {
                if (Analytics.this.mAnalyticsListener != null) {
                    Analytics.this.mAnalyticsListener.onSendingFailed(log, e);
                }
            }
        };
    }

    private synchronized void applyEnabledState(boolean enabled) {
        if (enabled && this.mChannel != null && this.mSessionTracker == null) {
            Activity activity;
            this.mSessionTracker = new SessionTracker(this.mChannel, ANALYTICS_GROUP);
            this.mChannel.addListener((Channel.Listener)this.mSessionTracker);
            if (this.mCurrentActivity != null && (activity = (Activity)this.mCurrentActivity.get()) != null) {
                this.processOnResume(activity);
            }
        } else if (!enabled && this.mSessionTracker != null) {
            this.mChannel.removeListener((Channel.Listener)this.mSessionTracker);
            this.mSessionTracker.clearSessions();
            this.mSessionTracker = null;
        }
    }

    private synchronized void queuePage(String name, Map<String, String> properties) {
        if (this.isInactive()) {
            return;
        }
        PageLog pageLog = new PageLog();
        pageLog.setName(name);
        pageLog.setProperties(properties);
        this.mChannel.enqueue((Log)pageLog, ANALYTICS_GROUP);
    }

    private synchronized void queueEvent(String name, Map<String, String> properties) {
        if (this.isInactive()) {
            return;
        }
        EventLog eventLog = new EventLog();
        eventLog.setId(UUIDUtils.randomUUID());
        eventLog.setName(name);
        eventLog.setProperties(properties);
        this.mChannel.enqueue((Log)eventLog, ANALYTICS_GROUP);
    }

    private boolean isInstanceAutoPageTrackingEnabled() {
        return this.mAutoPageTrackingEnabled;
    }

    private synchronized void setInstanceAutoPageTrackingEnabled(boolean autoPageTrackingEnabled) {
        this.mAutoPageTrackingEnabled = autoPageTrackingEnabled;
    }

    private synchronized void setInstanceListener(AnalyticsListener listener) {
        this.mAnalyticsListener = listener;
    }

    private static boolean validateName(String name, String logType) {
        int maxNameLength = 256;
        if (name == null || name.isEmpty()) {
            MobileCenterLog.error((String)LOG_TAG, (String)(logType + " name cannot be null or empty."));
            return false;
        }
        if (name.length() > 256) {
            MobileCenterLog.error((String)LOG_TAG, (String)String.format("%s '%s' : name length cannot be longer than %s characters.", logType, name, 256));
            return false;
        }
        return true;
    }

    private static Map<String, String> validateProperties(Map<String, String> properties, String logName, String logType) {
        if (properties == null) {
            return null;
        }
        int maxPropertiesCount = 5;
        int maxPropertyItemLength = 64;
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String message;
            if (result.size() >= 5) {
                message = String.format("%s '%s' : properties cannot contain more than %s items. Skipping other properties.", logType, logName, 5);
                MobileCenterLog.warn((String)LOG_TAG, (String)message);
                break;
            }
            if (property.getKey() == null || property.getKey().isEmpty()) {
                message = String.format("%s '%s' : a property key cannot be null or empty. Property will be skipped.", logType, logName);
                MobileCenterLog.warn((String)LOG_TAG, (String)message);
                continue;
            }
            if (property.getKey().length() > 64) {
                message = String.format("%s '%s' : property '%s' : property key length cannot be longer than %s characters. Property '%s' will be skipped.", logType, logName, property.getKey(), 64, property.getKey());
                MobileCenterLog.warn((String)LOG_TAG, (String)message);
                continue;
            }
            if (property.getValue() == null) {
                message = String.format("%s '%s' : property '%s' : property value cannot be null. Property '%s' will be skipped.", logType, logName, property.getKey(), property.getKey());
                MobileCenterLog.warn((String)LOG_TAG, (String)message);
                continue;
            }
            if (property.getValue().length() > 64) {
                message = String.format("%s '%s' : property '%s' : property value cannot be longer than %s characters. Property '%s' will be skipped.", logType, logName, property.getKey(), 64, property.getKey());
                MobileCenterLog.warn((String)LOG_TAG, (String)message);
                continue;
            }
            result.put(property.getKey(), property.getValue());
        }
        return result;
    }
}

