/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.format;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CslFormat {
    public abstract String getType();

    public abstract Object getValue();

    abstract String getValueAsString();

    private String getValueOrNullAsString() {
        if (this.getValue() == null) {
            return "null";
        }
        return this.getValueAsString();
    }

    public String toString() {
        return this.getType() + "(" + this.getValueOrNullAsString() + ")";
    }

    public static String parseValueFromValueWithType(String valueWithType, String type) {
        String valueWithTypeRegex = String.format("%s\\s*\\(\\s*(.*\\S+)\\s*\\)\\s*", type);
        Pattern valueWithTypePattern = Pattern.compile(valueWithTypeRegex, 2);
        Matcher matcher = valueWithTypePattern.matcher(valueWithType);
        return matcher.matches() ? matcher.group(1) : valueWithType;
    }
}

