/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.IConfidentialClientApplication;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.azure.kusto.data.auth.ConfidentialAppTokenProviderBase;
import com.microsoft.azure.kusto.data.auth.HttpClientWrapper;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.apache.http.client.HttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationKeyTokenProvider
extends ConfidentialAppTokenProviderBase {
    private final IClientSecret clientSecret;
    public static final String APPLICATION_KEY_TOKEN_PROVIDER = "ApplicationKeyTokenProvider";

    ApplicationKeyTokenProvider(@NotNull String clusterUrl, @NotNull String applicationClientId, @NotNull IClientSecret clientSecret, String authorityId, @Nullable HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, applicationClientId, authorityId, httpClient);
        this.clientSecret = clientSecret;
    }

    @Override
    protected IConfidentialClientApplication getClientApplication() throws MalformedURLException {
        ConfidentialClientApplication.Builder authority = (ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.applicationClientId, (IClientCredential)this.clientSecret).authority(this.aadAuthorityUrl);
        if (this.httpClient != null) {
            authority.httpClient((IHttpClient)new HttpClientWrapper(this.httpClient));
        }
        return authority.build();
    }

    @Override
    protected String getAuthMethod() {
        return APPLICATION_KEY_TOKEN_PROVIDER;
    }
}

