/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Stack;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPUtils {
    private static final Logger log = LoggerFactory.getLogger(FTPUtils.class);
    public static final String REPLY_MESSAGE = "Reply Message : %s";
    public static final String FAILED_TO_UPLOAD_RESOURCE = "Failed to upload file: ";
    public static final String UPLOADING_RESOURCE = "Uploading resource %s to %s";

    public static FTPClient getFTPClient(String ftpServer, String username, String password) throws IOException {
        FTPClient ftpClient = new FTPClient();
        ftpClient.connect(ftpServer);
        ftpClient.login(username, password);
        ftpClient.setFileType(2);
        ftpClient.enterLocalPassiveMode();
        return ftpClient;
    }

    public static void uploadFile(FTPClient ftpClient, String sourceFilePath, String targetFilePath) throws IOException {
        log.info(String.format(UPLOADING_RESOURCE, sourceFilePath, targetFilePath));
        File sourceFile = new File(sourceFilePath);
        FTPUtils.changeDirectoryWithCreate(ftpClient, targetFilePath);
        try (InputStream is = Files.newInputStream(sourceFile.toPath(), new OpenOption[0]);){
            ftpClient.storeFile(sourceFile.getName(), is);
            int replyCode = ftpClient.getReplyCode();
            String replyMessage = ftpClient.getReplyString();
            if (FTPUtils.isCommandFailed(replyCode)) {
                throw new IOException(FAILED_TO_UPLOAD_RESOURCE + sourceFilePath);
            }
            log.info(String.format(REPLY_MESSAGE, replyMessage));
        }
    }

    private static void changeDirectoryWithCreate(FTPClient ftpClient, String targetPath) throws IOException {
        Stack<Path> pathStacks = new Stack<Path>();
        Path path = Paths.get(targetPath, new String[0]);
        while (!ftpClient.changeWorkingDirectory(path.toString())) {
            pathStacks.push(path);
            path = path.getParent();
        }
        while (!pathStacks.isEmpty()) {
            ftpClient.makeDirectory(((Path)pathStacks.pop()).toString());
        }
        ftpClient.changeWorkingDirectory(targetPath);
    }

    private static boolean isCommandFailed(int replyCode) {
        return replyCode >= 300;
    }
}

