/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.maven.model.DeploymentResource;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.legacy.appservice.DeploymentSlotSetting;
import java.util.List;
import java.util.Objects;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

public class WebAppConfiguration {
    private static final Region DEFAULT_REGION = Region.US_CENTRAL;
    public static final PricingTier DEFAULT_JBOSS_PRICING_TIER = PricingTier.PREMIUM_P1V3;
    public static final PricingTier DEFAULT_PRICINGTIER = PricingTier.PREMIUM_P1V2;
    protected String subscriptionId;
    protected String appName;
    protected DeploymentSlotSetting deploymentSlotSetting;
    protected String resourceGroup;
    protected Region region;
    protected String pricingTier;
    protected String servicePlanName;
    protected String servicePlanResourceGroup;
    protected OperatingSystem os;
    protected String javaVersion;
    protected String webContainer;
    protected Settings mavenSettings;
    protected String image;
    protected String serverId;
    protected String registryUrl;
    protected String schemaVersion;
    protected List<DeploymentResource> resources;
    protected String stagingDirectoryPath;
    protected String buildDirectoryAbsolutePath;
    protected MavenProject project;
    protected MavenSession session;
    protected MavenResourcesFiltering filtering;

    public String getRegionOrDefault() {
        return this.region == null ? WebAppConfiguration.getDefaultRegion().toString() : this.region.toString();
    }

    public static Region getDefaultRegion() {
        AzureAccount az = (AzureAccount)Azure.az(AzureAccount.class);
        if (az.isLoggedIn()) {
            Subscription sub = (Subscription)az.account().getSelectedSubscriptions().get(0);
            AppServiceServiceSubscription appServiceSubscription = (AppServiceServiceSubscription)((AzureAppService)Azure.az(AzureAppService.class)).get(sub.getId(), null);
            List regions = Objects.requireNonNull(appServiceSubscription).listSupportedRegions();
            if (regions.contains(DEFAULT_REGION)) {
                return DEFAULT_REGION;
            }
            return (Region)regions.get(0);
        }
        return DEFAULT_REGION;
    }

    protected WebAppConfiguration(WebAppConfigurationBuilder<?, ?> b) {
        this.subscriptionId = ((WebAppConfigurationBuilder)b).subscriptionId;
        this.appName = ((WebAppConfigurationBuilder)b).appName;
        this.deploymentSlotSetting = ((WebAppConfigurationBuilder)b).deploymentSlotSetting;
        this.resourceGroup = ((WebAppConfigurationBuilder)b).resourceGroup;
        this.region = ((WebAppConfigurationBuilder)b).region;
        this.pricingTier = ((WebAppConfigurationBuilder)b).pricingTier;
        this.servicePlanName = ((WebAppConfigurationBuilder)b).servicePlanName;
        this.servicePlanResourceGroup = ((WebAppConfigurationBuilder)b).servicePlanResourceGroup;
        this.os = ((WebAppConfigurationBuilder)b).os;
        this.javaVersion = ((WebAppConfigurationBuilder)b).javaVersion;
        this.webContainer = ((WebAppConfigurationBuilder)b).webContainer;
        this.mavenSettings = ((WebAppConfigurationBuilder)b).mavenSettings;
        this.image = ((WebAppConfigurationBuilder)b).image;
        this.serverId = ((WebAppConfigurationBuilder)b).serverId;
        this.registryUrl = ((WebAppConfigurationBuilder)b).registryUrl;
        this.schemaVersion = ((WebAppConfigurationBuilder)b).schemaVersion;
        this.resources = ((WebAppConfigurationBuilder)b).resources;
        this.stagingDirectoryPath = ((WebAppConfigurationBuilder)b).stagingDirectoryPath;
        this.buildDirectoryAbsolutePath = ((WebAppConfigurationBuilder)b).buildDirectoryAbsolutePath;
        this.project = ((WebAppConfigurationBuilder)b).project;
        this.session = ((WebAppConfigurationBuilder)b).session;
        this.filtering = ((WebAppConfigurationBuilder)b).filtering;
    }

    public static WebAppConfigurationBuilder<?, ?> builder() {
        return new WebAppConfigurationBuilderImpl();
    }

    public WebAppConfigurationBuilder<?, ?> toBuilder() {
        return new WebAppConfigurationBuilderImpl().$fillValuesFrom(this);
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getAppName() {
        return this.appName;
    }

    public DeploymentSlotSetting getDeploymentSlotSetting() {
        return this.deploymentSlotSetting;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public Region getRegion() {
        return this.region;
    }

    public String getPricingTier() {
        return this.pricingTier;
    }

    public String getServicePlanName() {
        return this.servicePlanName;
    }

    public String getServicePlanResourceGroup() {
        return this.servicePlanResourceGroup;
    }

    public OperatingSystem getOs() {
        return this.os;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getWebContainer() {
        return this.webContainer;
    }

    public Settings getMavenSettings() {
        return this.mavenSettings;
    }

    public String getImage() {
        return this.image;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public List<DeploymentResource> getResources() {
        return this.resources;
    }

    public String getStagingDirectoryPath() {
        return this.stagingDirectoryPath;
    }

    public String getBuildDirectoryAbsolutePath() {
        return this.buildDirectoryAbsolutePath;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public MavenResourcesFiltering getFiltering() {
        return this.filtering;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setDeploymentSlotSetting(DeploymentSlotSetting deploymentSlotSetting) {
        this.deploymentSlotSetting = deploymentSlotSetting;
    }

    public void setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setPricingTier(String pricingTier) {
        this.pricingTier = pricingTier;
    }

    public void setServicePlanName(String servicePlanName) {
        this.servicePlanName = servicePlanName;
    }

    public void setServicePlanResourceGroup(String servicePlanResourceGroup) {
        this.servicePlanResourceGroup = servicePlanResourceGroup;
    }

    public void setOs(OperatingSystem os) {
        this.os = os;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void setWebContainer(String webContainer) {
        this.webContainer = webContainer;
    }

    public void setMavenSettings(Settings mavenSettings) {
        this.mavenSettings = mavenSettings;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setResources(List<DeploymentResource> resources) {
        this.resources = resources;
    }

    public void setStagingDirectoryPath(String stagingDirectoryPath) {
        this.stagingDirectoryPath = stagingDirectoryPath;
    }

    public void setBuildDirectoryAbsolutePath(String buildDirectoryAbsolutePath) {
        this.buildDirectoryAbsolutePath = buildDirectoryAbsolutePath;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public void setFiltering(MavenResourcesFiltering filtering) {
        this.filtering = filtering;
    }

    private static final class WebAppConfigurationBuilderImpl
    extends WebAppConfigurationBuilder<WebAppConfiguration, WebAppConfigurationBuilderImpl> {
        private WebAppConfigurationBuilderImpl() {
        }

        @Override
        protected WebAppConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public WebAppConfiguration build() {
            return new WebAppConfiguration(this);
        }
    }

    public static abstract class WebAppConfigurationBuilder<C extends WebAppConfiguration, B extends WebAppConfigurationBuilder<C, B>> {
        private String subscriptionId;
        private String appName;
        private DeploymentSlotSetting deploymentSlotSetting;
        private String resourceGroup;
        private Region region;
        private String pricingTier;
        private String servicePlanName;
        private String servicePlanResourceGroup;
        private OperatingSystem os;
        private String javaVersion;
        private String webContainer;
        private Settings mavenSettings;
        private String image;
        private String serverId;
        private String registryUrl;
        private String schemaVersion;
        private List<DeploymentResource> resources;
        private String stagingDirectoryPath;
        private String buildDirectoryAbsolutePath;
        private MavenProject project;
        private MavenSession session;
        private MavenResourcesFiltering filtering;

        protected B $fillValuesFrom(C instance) {
            WebAppConfigurationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(WebAppConfiguration instance, WebAppConfigurationBuilder<?, ?> b) {
            b.subscriptionId(instance.subscriptionId);
            b.appName(instance.appName);
            b.deploymentSlotSetting(instance.deploymentSlotSetting);
            b.resourceGroup(instance.resourceGroup);
            b.region(instance.region);
            b.pricingTier(instance.pricingTier);
            b.servicePlanName(instance.servicePlanName);
            b.servicePlanResourceGroup(instance.servicePlanResourceGroup);
            b.os(instance.os);
            b.javaVersion(instance.javaVersion);
            b.webContainer(instance.webContainer);
            b.mavenSettings(instance.mavenSettings);
            b.image(instance.image);
            b.serverId(instance.serverId);
            b.registryUrl(instance.registryUrl);
            b.schemaVersion(instance.schemaVersion);
            b.resources(instance.resources);
            b.stagingDirectoryPath(instance.stagingDirectoryPath);
            b.buildDirectoryAbsolutePath(instance.buildDirectoryAbsolutePath);
            b.project(instance.project);
            b.session(instance.session);
            b.filtering(instance.filtering);
        }

        protected abstract B self();

        public abstract C build();

        public B subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this.self();
        }

        public B appName(String appName) {
            this.appName = appName;
            return this.self();
        }

        public B deploymentSlotSetting(DeploymentSlotSetting deploymentSlotSetting) {
            this.deploymentSlotSetting = deploymentSlotSetting;
            return this.self();
        }

        public B resourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            return this.self();
        }

        public B region(Region region) {
            this.region = region;
            return this.self();
        }

        public B pricingTier(String pricingTier) {
            this.pricingTier = pricingTier;
            return this.self();
        }

        public B servicePlanName(String servicePlanName) {
            this.servicePlanName = servicePlanName;
            return this.self();
        }

        public B servicePlanResourceGroup(String servicePlanResourceGroup) {
            this.servicePlanResourceGroup = servicePlanResourceGroup;
            return this.self();
        }

        public B os(OperatingSystem os) {
            this.os = os;
            return this.self();
        }

        public B javaVersion(String javaVersion) {
            this.javaVersion = javaVersion;
            return this.self();
        }

        public B webContainer(String webContainer) {
            this.webContainer = webContainer;
            return this.self();
        }

        public B mavenSettings(Settings mavenSettings) {
            this.mavenSettings = mavenSettings;
            return this.self();
        }

        public B image(String image) {
            this.image = image;
            return this.self();
        }

        public B serverId(String serverId) {
            this.serverId = serverId;
            return this.self();
        }

        public B registryUrl(String registryUrl) {
            this.registryUrl = registryUrl;
            return this.self();
        }

        public B schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this.self();
        }

        public B resources(List<DeploymentResource> resources) {
            this.resources = resources;
            return this.self();
        }

        public B stagingDirectoryPath(String stagingDirectoryPath) {
            this.stagingDirectoryPath = stagingDirectoryPath;
            return this.self();
        }

        public B buildDirectoryAbsolutePath(String buildDirectoryAbsolutePath) {
            this.buildDirectoryAbsolutePath = buildDirectoryAbsolutePath;
            return this.self();
        }

        public B project(MavenProject project) {
            this.project = project;
            return this.self();
        }

        public B session(MavenSession session) {
            this.session = session;
            return this.self();
        }

        public B filtering(MavenResourcesFiltering filtering) {
            this.filtering = filtering;
            return this.self();
        }

        public String toString() {
            return "WebAppConfiguration.WebAppConfigurationBuilder(subscriptionId=" + this.subscriptionId + ", appName=" + this.appName + ", deploymentSlotSetting=" + this.deploymentSlotSetting + ", resourceGroup=" + this.resourceGroup + ", region=" + this.region + ", pricingTier=" + this.pricingTier + ", servicePlanName=" + this.servicePlanName + ", servicePlanResourceGroup=" + this.servicePlanResourceGroup + ", os=" + this.os + ", javaVersion=" + this.javaVersion + ", webContainer=" + this.webContainer + ", mavenSettings=" + this.mavenSettings + ", image=" + this.image + ", serverId=" + this.serverId + ", registryUrl=" + this.registryUrl + ", schemaVersion=" + this.schemaVersion + ", resources=" + this.resources + ", stagingDirectoryPath=" + this.stagingDirectoryPath + ", buildDirectoryAbsolutePath=" + this.buildDirectoryAbsolutePath + ", project=" + this.project + ", session=" + this.session + ", filtering=" + this.filtering + ")";
        }
    }
}

