/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.artifact;

import com.google.common.io.Files;
import com.microsoft.azure.maven.artifacthandler.ArtifactHandlerBase;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import com.microsoft.azure.maven.webapp.handlers.artifact.ArtifactHandlerUtils;
import java.io.File;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class WarArtifactHandlerImpl
extends ArtifactHandlerBase {
    protected final String warFile;
    protected final String contextPath;
    public static final String FILE_IS_NOT_WAR = "The deployment file is not a war typed file.";
    public static final String FIND_WAR_FILE_FAIL = "Failed to find the war file: '%s'";
    public static final String UPLOAD_FAILURE = "Exception occurred when deploying war file to server: %s, retrying immediately (%d/%d)";
    public static final String DEPLOY_FAILURE = "Failed to deploy war file after %d times of retry.";
    public static final int DEFAULT_MAX_RETRY_TIMES = 3;

    protected WarArtifactHandlerImpl(Builder builder) {
        super((ArtifactHandlerBase.Builder)builder);
        this.contextPath = builder.contextPath;
        this.warFile = builder.warFile;
    }

    public void publish(DeployTarget target) throws MojoExecutionException {
        File war = this.getWarFile();
        this.assureWarFileExisted(war);
        Runnable warDeployExecutor = ArtifactHandlerUtils.getRealWarDeployExecutor(target, war, this.getContextPath());
        this.log.info((CharSequence)String.format("Trying to deploy artifact to %s...", target.getName()));
        this.log.info((CharSequence)"Deploying the war file...");
        for (int retryCount = 0; retryCount < 3; ++retryCount) {
            try {
                warDeployExecutor.run();
                this.log.info((CharSequence)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
                return;
            }
            catch (Exception e) {
                this.log.debug((CharSequence)String.format(UPLOAD_FAILURE, e.getMessage(), retryCount, 3));
                continue;
            }
        }
        throw new MojoExecutionException(String.format(DEPLOY_FAILURE, 3));
    }

    protected String getContextPath() {
        String path = this.contextPath.trim();
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    protected File getWarFile() {
        return StringUtils.isNotEmpty((String)this.warFile) ? new File(this.warFile) : new File(Paths.get(this.buildDirectoryAbsolutePath, this.project.getBuild().getFinalName() + ".war").toString());
    }

    protected void assureWarFileExisted(File war) throws MojoExecutionException {
        if (!Files.getFileExtension((String)war.getName()).equalsIgnoreCase("war")) {
            throw new MojoExecutionException(FILE_IS_NOT_WAR);
        }
        if (!war.exists() || !war.isFile()) {
            throw new MojoExecutionException(String.format(FIND_WAR_FILE_FAIL, war.getAbsolutePath()));
        }
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        private String warFile;
        private String contextPath;

        protected Builder self() {
            return this;
        }

        public WarArtifactHandlerImpl build() {
            return new WarArtifactHandlerImpl(this);
        }

        public Builder warFile(String value) {
            this.warFile = value;
            return this.self();
        }

        public Builder contextPath(String value) {
            this.contextPath = value;
            return this.self();
        }
    }
}

