/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.artifact;

import com.microsoft.azure.maven.artifacthandler.ArtifactHandlerBase;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import com.microsoft.azure.maven.webapp.configuration.OperatingSystemEnum;
import com.microsoft.azure.maven.webapp.configuration.RuntimeSetting;
import com.microsoft.azure.maven.webapp.handlers.artifact.ArtifactHandlerUtils;
import com.microsoft.azure.maven.webapp.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.zeroturnaround.zip.ZipUtil;

public class ArtifactHandlerImplV2
extends ArtifactHandlerBase {
    private static final int MAX_RETRY_TIMES = 3;
    private static final String ALWAYS_DEPLOY_PROPERTY = "alwaysDeploy";
    private static final String WEB_CONFIG = "web.config";
    private static final String RENAMING_MESSAGE = "Renaming %s to %s";
    private static final String RENAMING_FAILED_MESSAGE = "Failed to rename artifact to %s, which is required in Java SE environment, refer to https://docs.microsoft.com/en-us/azure/app-service/containers/configure-language-java#set-java-runtime-options for details.";
    private static final String NO_EXECUTABLE_JAR = "No executable jar found in target folder according to resource filter '%s', please make sure the resource filter is correct and you have built the jar.";
    private static final String MULTI_EXECUTABLE_JARS = "Multi executable jars found in <resources>, please check the configuration";
    private RuntimeSetting runtimeSetting;

    protected ArtifactHandlerImplV2(Builder builder) {
        super((ArtifactHandlerBase.Builder)builder);
        this.runtimeSetting = builder.getRuntimeSetting();
    }

    public void publish(DeployTarget target) throws MojoExecutionException, IOException {
        if (this.resources == null || this.resources.size() < 1) {
            this.log.warn((CharSequence)"No <resources> is found in <deployment> element in pom.xml, skip deployment.");
            return;
        }
        this.copyArtifactsToStagingDirectory();
        List<File> allArtifacts = this.getAllArtifacts(this.stagingDirectoryPath);
        if (allArtifacts.size() == 0) {
            String absolutePath = new File(this.stagingDirectoryPath).getAbsolutePath();
            throw new MojoExecutionException(String.format("There is no artifact to deploy in staging directory: '%s'", absolutePath));
        }
        this.log.info((CharSequence)String.format("Trying to deploy artifact to %s...", target.getName()));
        if (ArtifactHandlerUtils.areAllWarFiles(allArtifacts)) {
            this.publishArtifactsViaWarDeploy(target, this.stagingDirectoryPath, allArtifacts);
            this.log.info((CharSequence)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
            return;
        }
        if (!ArtifactHandlerUtils.hasWarFiles(allArtifacts)) {
            this.publishArtifactsViaZipDeploy(target, this.stagingDirectoryPath);
            this.log.info((CharSequence)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
            return;
        }
        if (this.isDeployMixedArtifactsConfirmed()) {
            this.publishArtifactsViaZipDeploy(target, this.stagingDirectoryPath);
            this.log.info((CharSequence)String.format("Successfully deployed the artifact to https://%s", target.getDefaultHostName()));
        } else {
            this.log.info((CharSequence)"Deployment is aborted.");
        }
    }

    protected boolean isDeployMixedArtifactsConfirmed() {
        String input;
        if ("true".equalsIgnoreCase(System.getProperty(ALWAYS_DEPLOY_PROPERTY))) {
            return true;
        }
        this.log.info((CharSequence)String.format("To get rid of the following message, set the property %s to true to always proceed with the deploy.", ALWAYS_DEPLOY_PROPERTY));
        Scanner scanner = new Scanner(System.in, "UTF-8");
        do {
            this.log.warn((CharSequence)"Deploying war along with other kinds of artifacts might make the web app inaccessible, are you sure to proceed (y/n)?");
            input = scanner.nextLine();
            if (!"y".equalsIgnoreCase(input)) continue;
            return true;
        } while (!"n".equalsIgnoreCase(input));
        return false;
    }

    protected List<File> getAllArtifacts(String stagingDirectoryPath) {
        File stagingDirectory = new File(stagingDirectoryPath);
        return ArtifactHandlerUtils.getArtifacts(stagingDirectory);
    }

    protected void copyArtifactsToStagingDirectory() throws IOException, MojoExecutionException {
        this.prepareResources();
        this.assureStagingDirectoryNotEmpty();
    }

    protected void publishArtifactsViaZipDeploy(DeployTarget target, String stagingDirectoryPath) throws MojoExecutionException {
        if (this.isJavaSERuntime()) {
            this.prepareJavaSERuntime(this.getAllArtifacts(stagingDirectoryPath));
        }
        File stagingDirectory = new File(stagingDirectoryPath);
        File zipFile = Utils.createTempFile(stagingDirectory.getName(), ".zip");
        ZipUtil.pack((File)stagingDirectory, (File)zipFile);
        this.log.info((CharSequence)String.format("Deploying the zip package %s...", zipFile.getName()));
        boolean deploySuccess = ArtifactHandlerUtils.performActionWithRetry(() -> target.zipDeploy(zipFile), 3, this.log);
        if (!deploySuccess) {
            throw new MojoExecutionException(String.format("The zip deploy failed after %d times of retry.", 4));
        }
    }

    protected void publishArtifactsViaWarDeploy(DeployTarget target, String stagingDirectoryPath, List<File> warArtifacts) throws MojoExecutionException {
        if (warArtifacts == null || warArtifacts.size() == 0) {
            throw new MojoExecutionException(String.format("There is no war artifacts to deploy in staging path %s.", stagingDirectoryPath));
        }
        for (File warArtifact : warArtifacts) {
            String contextPath = ArtifactHandlerUtils.getContextPathFromFileName(stagingDirectoryPath, warArtifact.getAbsolutePath());
            this.publishWarArtifact(target, warArtifact, contextPath);
        }
    }

    public void publishWarArtifact(DeployTarget target, File warArtifact, String contextPath) throws MojoExecutionException {
        Runnable executor = ArtifactHandlerUtils.getRealWarDeployExecutor(target, warArtifact, contextPath);
        this.log.info((CharSequence)String.format("Deploying the war file %s...", warArtifact.getName()));
        boolean deploySuccess = ArtifactHandlerUtils.performActionWithRetry(executor, 3, this.log);
        if (!deploySuccess) {
            throw new MojoExecutionException(String.format("Failed to deploy war file after %d times of retry.", 3));
        }
    }

    protected boolean isJavaSERuntime() {
        boolean isJarProject;
        boolean bl = isJarProject = this.project != null && StringUtils.equalsIgnoreCase((CharSequence)this.project.getPackaging(), (CharSequence)"jar");
        if (this.runtimeSetting == null || this.runtimeSetting.isEmpty() || isJarProject) {
            return isJarProject;
        }
        String webContainer = this.runtimeSetting.getOsEnum() == OperatingSystemEnum.Windows ? this.runtimeSetting.getWebContainer().toString() : this.runtimeSetting.getLinuxRuntime().stack();
        return StringUtils.containsIgnoreCase((CharSequence)webContainer, (CharSequence)"java");
    }

    private void prepareJavaSERuntime(List<File> artifacts) throws MojoExecutionException {
        if (ArtifactHandlerImplV2.existsWebConfig(artifacts)) {
            return;
        }
        File artifact = this.getProjectJarArtifact(artifacts);
        File renamedArtifact = new File(artifact.getParent(), "app.jar");
        if (!StringUtils.equals((CharSequence)artifact.getName(), (CharSequence)"app.jar")) {
            this.log.info((CharSequence)String.format(RENAMING_MESSAGE, artifact.getAbsolutePath(), "app.jar"));
            if (!artifact.renameTo(renamedArtifact)) {
                throw new MojoExecutionException(String.format(RENAMING_FAILED_MESSAGE, "app.jar"));
            }
        }
    }

    private File getProjectJarArtifact(List<File> artifacts) throws MojoExecutionException {
        String fileName = String.format("%s.%s", this.project.getBuild().getFinalName(), this.project.getPackaging());
        List executableArtifacts = artifacts.stream().filter(file -> ArtifactHandlerImplV2.isExecutableJar(file)).collect(Collectors.toList());
        File finalArtifact = executableArtifacts.stream().filter(file -> StringUtils.equals((CharSequence)fileName, (CharSequence)file.getName())).findFirst().orElse(null);
        if (executableArtifacts.size() == 0) {
            throw new MojoExecutionException(String.format(NO_EXECUTABLE_JAR, this.getResourceConfiguration()));
        }
        if (finalArtifact == null && executableArtifacts.size() > 1) {
            throw new MojoExecutionException(MULTI_EXECUTABLE_JARS);
        }
        return finalArtifact == null ? (File)executableArtifacts.get(0) : finalArtifact;
    }

    private String getResourceConfiguration() {
        return this.resources.stream().map(resource -> resource.toString()).collect(Collectors.joining(","));
    }

    private static boolean existsWebConfig(List<File> artifacts) {
        return artifacts.stream().anyMatch(file -> StringUtils.equals((CharSequence)file.getName(), (CharSequence)WEB_CONFIG));
    }

    /*
     * Exception decompiling
     */
    private static boolean isExecutableJar(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class Builder
    extends ArtifactHandlerBase.Builder<Builder> {
        private RuntimeSetting runtimeSetting;

        public RuntimeSetting getRuntimeSetting() {
            return this.runtimeSetting;
        }

        protected Builder self() {
            return this;
        }

        public Builder runtime(RuntimeSetting runtimeSetting) {
            this.runtimeSetting = runtimeSetting;
            return this.self();
        }

        public ArtifactHandlerImplV2 build() {
            return new ArtifactHandlerImplV2(this);
        }
    }
}

