/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import com.microsoft.azure.maven.utils.AppServiceUtils;
import com.microsoft.azure.maven.webapp.configuration.DockerImageType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class WebAppUtils {
    public static final String SERVICE_PLAN_NOT_APPLICABLE = "The App Service Plan '%s' is not a %s Plan";
    public static final String CREATE_SERVICE_PLAN = "Creating App Service Plan '%s'...";
    public static final String SERVICE_PLAN_CREATED = "Successfully created App Service Plan.";
    public static final String SERVICE_PLAN_NOT_FOUND = "Failed to get App Service Plan";
    public static final String GENERATE_WEB_CONFIG_FAIL = "Failed to generate web.config file for JAR deployment.";
    public static final String READ_WEB_CONFIG_TEMPLATE_FAIL = "Failed to read the content of web.config.template.";
    public static final String GENERATING_WEB_CONFIG = "Generating web.config for Web App on Windows.";
    public static final String CONFIGURATION_NOT_APPLICABLE = "The configuration is not applicable for the target Web App (%s). Please correct it in pom.xml.";
    public static final String UPDATE_APP_SERVICE_PLAN = "Updating app service plan";
    private static final String JAR_CMD = ":JAR_COMMAND:";
    private static final String JAR_COMMAND_PATTERN = " %s -Djava.net.preferIPv4Stack=true -Dserver.port=%%HTTP_PLATFORM_PORT%% -jar &quot;%%HOME%%\\\\site\\\\wwwroot\\\\%s&quot;";

    public static void assureLinuxWebApp(WebApp app) throws MojoExecutionException {
        if (!WebAppUtils.isLinuxWebApp(app)) {
            throw new MojoExecutionException(String.format(CONFIGURATION_NOT_APPLICABLE, "Windows"));
        }
    }

    public static void assureWindowsWebApp(WebApp app) throws MojoExecutionException {
        if (WebAppUtils.isLinuxWebApp(app)) {
            throw new MojoExecutionException(String.format(CONFIGURATION_NOT_APPLICABLE, "Linux"));
        }
    }

    public static WebApp.DefinitionStages.WithDockerContainerImage defineLinuxApp(String resourceGroup, String appName, Azure azureClient, AppServicePlan plan) throws Exception {
        WebAppUtils.assureLinuxPlan(plan);
        WebApp.DefinitionStages.ExistingLinuxPlanWithGroup existingLinuxPlanWithGroup = ((WebApp.DefinitionStages.Blank)azureClient.webApps().define(appName)).withExistingLinuxPlan(plan);
        return azureClient.resourceGroups().contain(resourceGroup) ? existingLinuxPlanWithGroup.withExistingResourceGroup(resourceGroup) : existingLinuxPlanWithGroup.withNewResourceGroup(resourceGroup);
    }

    public static WebApp.DefinitionStages.WithCreate defineWindowsApp(String resourceGroup, String appName, Azure azureClient, AppServicePlan plan) throws Exception {
        WebAppUtils.assureWindowsPlan(plan);
        WebApp.DefinitionStages.ExistingWindowsPlanWithGroup existingWindowsPlanWithGroup = ((WebApp.DefinitionStages.Blank)azureClient.webApps().define(appName)).withExistingWindowsPlan(plan);
        return azureClient.resourceGroups().contain(resourceGroup) ? existingWindowsPlanWithGroup.withExistingResourceGroup(resourceGroup) : existingWindowsPlanWithGroup.withNewResourceGroup(resourceGroup);
    }

    public static AppServicePlan createOrGetAppServicePlan(String servicePlanName, String resourceGroup, Azure azure, String servicePlanResourceGroup, Region region, PricingTier pricingTier, Log log, OperatingSystem os) throws MojoExecutionException {
        AppServicePlan plan = AppServiceUtils.getAppServicePlan((String)servicePlanName, (Azure)azure, (String)resourceGroup, (String)servicePlanResourceGroup);
        return plan != null ? plan : WebAppUtils.createAppServicePlan(servicePlanName, resourceGroup, azure, servicePlanResourceGroup, region, pricingTier, log, os);
    }

    public static AppServicePlan createAppServicePlan(String servicePlanName, String resourceGroup, Azure azure, String servicePlanResourceGroup, Region region, PricingTier pricingTier, Log log, OperatingSystem os) throws MojoExecutionException {
        if (region == null) {
            throw new MojoExecutionException("Please config the <region> in pom.xml, it is required to create a new Azure App Service Plan.");
        }
        servicePlanName = AppServiceUtils.getAppServicePlanName((String)servicePlanName);
        String servicePlanResGrp = AppServiceUtils.getAppServicePlanResourceGroup((String)resourceGroup, (String)servicePlanResourceGroup);
        log.info((CharSequence)String.format(CREATE_SERVICE_PLAN, servicePlanName));
        AppServicePlan.DefinitionStages.WithGroup withGroup = (AppServicePlan.DefinitionStages.WithGroup)((AppServicePlan.DefinitionStages.Blank)azure.appServices().appServicePlans().define(servicePlanName)).withRegion(region);
        AppServicePlan.DefinitionStages.WithPricingTier withPricingTier = azure.resourceGroups().contain(servicePlanResGrp) ? (AppServicePlan.DefinitionStages.WithPricingTier)withGroup.withExistingResourceGroup(servicePlanResGrp) : (AppServicePlan.DefinitionStages.WithPricingTier)withGroup.withNewResourceGroup(servicePlanResGrp);
        AppServicePlan result = (AppServicePlan)withPricingTier.withPricingTier(pricingTier).withOperatingSystem(os).create();
        log.info((CharSequence)SERVICE_PLAN_CREATED);
        return result;
    }

    public static AppServicePlan updateAppServicePlan(AppServicePlan appServicePlan, PricingTier pricingTier, Log log) throws MojoExecutionException {
        if (appServicePlan == null) {
            throw new MojoExecutionException(SERVICE_PLAN_NOT_FOUND);
        }
        log.info((CharSequence)String.format(UPDATE_APP_SERVICE_PLAN, new Object[0]));
        AppServicePlan.Update appServicePlanUpdate = (AppServicePlan.Update)appServicePlan.update();
        if (pricingTier != null && !appServicePlan.pricingTier().equals((Object)pricingTier)) {
            appServicePlanUpdate.withPricingTier(pricingTier);
        }
        return (AppServicePlan)appServicePlanUpdate.apply();
    }

    public static DockerImageType getDockerImageType(String imageName, String serverId, String registryUrl) {
        if (StringUtils.isEmpty((CharSequence)imageName)) {
            return DockerImageType.NONE;
        }
        boolean isCustomRegistry = StringUtils.isNotEmpty((CharSequence)registryUrl);
        boolean isPrivate = StringUtils.isNotEmpty((CharSequence)serverId);
        if (isCustomRegistry) {
            return isPrivate ? DockerImageType.PRIVATE_REGISTRY : DockerImageType.UNKNOWN;
        }
        return isPrivate ? DockerImageType.PRIVATE_DOCKER_HUB : DockerImageType.PUBLIC_DOCKER_HUB;
    }

    public static void generateWebConfigFile(DeployTarget deployTarget, String jarFileName, String stagingDirectoryPath, Log log) throws IOException {
        String templateContent;
        log.info((CharSequence)GENERATING_WEB_CONFIG);
        try (InputStream is = WebAppUtils.class.getClassLoader().getResourceAsStream("web.config.template");){
            templateContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error((CharSequence)READ_WEB_CONFIG_TEMPLATE_FAIL);
            throw e;
        }
        String javaOpts = deployTarget.getAppSettings().containsKey("JAVA_OPTS") ? "%JAVA_OPTS%" : "";
        String jarCommand = String.format(JAR_COMMAND_PATTERN, javaOpts, jarFileName);
        String webConfigFile = templateContent.replaceAll(JAR_CMD, jarCommand);
        File webConfig = new File(stagingDirectoryPath, "web.config");
        webConfig.createNewFile();
        try (FileOutputStream fos = new FileOutputStream(webConfig);){
            IOUtils.write((String)webConfigFile, (OutputStream)fos, (String)"UTF-8");
        }
        catch (Exception e) {
            log.error((CharSequence)GENERATE_WEB_CONFIG_FAIL);
        }
    }

    public static AppServicePlan getAppServicePlanByWebApp(WebApp webApp) {
        return (AppServicePlan)((AppServiceManager)webApp.manager()).appServicePlans().getById(webApp.appServicePlanId());
    }

    public static void clearTags(WebApp app) {
        ((SiteInner)app.inner()).withTags(null);
    }

    private static void assureWindowsPlan(AppServicePlan plan) throws MojoExecutionException {
        if (!plan.operatingSystem().equals((Object)OperatingSystem.WINDOWS)) {
            throw new MojoExecutionException(String.format(SERVICE_PLAN_NOT_APPLICABLE, plan.name(), OperatingSystem.WINDOWS.name()));
        }
    }

    private static void assureLinuxPlan(AppServicePlan plan) throws MojoExecutionException {
        if (!plan.operatingSystem().equals((Object)OperatingSystem.LINUX)) {
            throw new MojoExecutionException(String.format(SERVICE_PLAN_NOT_APPLICABLE, plan.name(), OperatingSystem.LINUX.name()));
        }
    }

    private static boolean isLinuxWebApp(WebApp app) {
        return ((SiteInner)app.inner()).kind().contains("linux");
    }
}

