/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.management.appservice.RuntimeStack;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.codehaus.plexus.util.StringUtils;

public class RuntimeStackUtils {
    private static final List<String> JAVA_STACKS = Arrays.asList("JAVA", "TOMCAT", "WILDFLY");
    private static final List<RuntimeStack> RUNTIME_STACKS = new ArrayList<RuntimeStack>();
    private static final BidiMap<String, String> JAVA_VERSIONS = new DualHashBidiMap();

    public static String getJavaVersionFromRuntimeStack(RuntimeStack runtimeStack) {
        return runtimeStack.version().split("-")[1];
    }

    public static String getWebContainerFromRuntimeStack(RuntimeStack runtimeStack) {
        String stack = runtimeStack.stack();
        String version = runtimeStack.version();
        return stack.equalsIgnoreCase("JAVA") ? version.split("-")[1] : stack + " " + version.split("-")[0];
    }

    public static RuntimeStack getRuntimeStack(String javaVersion) {
        for (RuntimeStack runtimeStack : RuntimeStackUtils.getValidRuntimeStacks()) {
            if (!runtimeStack.stack().equals("JAVA") || !RuntimeStackUtils.getJavaVersionFromRuntimeStack(runtimeStack).equalsIgnoreCase(javaVersion)) continue;
            return runtimeStack;
        }
        return null;
    }

    public static RuntimeStack getRuntimeStack(String javaVersion, String webContainer) {
        if (StringUtils.isEmpty((String)webContainer) || RuntimeStackUtils.getValidJavaVersions().containsValue((Object)webContainer)) {
            return RuntimeStackUtils.getRuntimeStack(javaVersion);
        }
        for (RuntimeStack runtimeStack : RuntimeStackUtils.getValidRuntimeStacks()) {
            if (!RuntimeStackUtils.getJavaVersionFromRuntimeStack(runtimeStack).equalsIgnoreCase(javaVersion) || !RuntimeStackUtils.getWebContainerFromRuntimeStack(runtimeStack).equalsIgnoreCase(webContainer)) continue;
            return runtimeStack;
        }
        return null;
    }

    public static List<RuntimeStack> getValidRuntimeStacks() {
        return new ArrayList<RuntimeStack>(RUNTIME_STACKS);
    }

    public static List<String> getValidWebContainer(String javaVersion) {
        HashSet<String> result = new HashSet<String>();
        for (RuntimeStack runtimeStack : RuntimeStackUtils.getValidRuntimeStacks()) {
            if (!RuntimeStackUtils.getJavaVersionFromRuntimeStack(runtimeStack).equalsIgnoreCase(javaVersion) || runtimeStack.stack().equals("JAVA")) continue;
            result.add(RuntimeStackUtils.getWebContainerFromRuntimeStack(runtimeStack));
        }
        return new ArrayList<String>(result);
    }

    public static BidiMap<String, String> getValidJavaVersions() {
        return JAVA_VERSIONS;
    }

    static {
        for (Field field : RuntimeStack.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                RuntimeStack runtimeStack = (RuntimeStack)field.get(null);
                if (!JAVA_STACKS.contains(runtimeStack.stack())) continue;
                RUNTIME_STACKS.add(runtimeStack);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        JAVA_VERSIONS.put((Object)"Java 8", (Object)"jre8");
        JAVA_VERSIONS.put((Object)"Java 11", (Object)"java11");
    }
}

