/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.maven.AbstractAppServiceMojo;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.configuration.Deployment;
import com.microsoft.azure.maven.webapp.configuration.DeploymentSlotSetting;
import com.microsoft.azure.maven.webapp.configuration.DockerImageType;
import com.microsoft.azure.maven.webapp.configuration.RuntimeSetting;
import com.microsoft.azure.maven.webapp.parser.ConfigurationParser;
import com.microsoft.azure.maven.webapp.parser.V1ConfigurationParser;
import com.microsoft.azure.maven.webapp.parser.V2ConfigurationParser;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;
import com.microsoft.azure.maven.webapp.validator.V1ConfigurationValidator;
import com.microsoft.azure.maven.webapp.validator.V2ConfigurationValidator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractWebAppMojo
extends AbstractAppServiceMojo {
    public static final String JAVA_VERSION_KEY = "javaVersion";
    public static final String JAVA_WEB_CONTAINER_KEY = "javaWebContainer";
    public static final String LINUX_RUNTIME_KEY = "linuxRuntime";
    public static final String DOCKER_IMAGE_TYPE_KEY = "dockerImageType";
    public static final String DEPLOYMENT_TYPE_KEY = "deploymentType";
    public static final String OS_KEY = "os";
    public static final String INVALID_CONFIG_KEY = "invalidConfiguration";
    public static final String SCHEMA_VERSION_KEY = "schemaVersion";
    @Parameter(property="webapp.pricingTier", defaultValue="P1V2")
    protected String pricingTier;
    @Parameter(property="webapp.javaVersion")
    protected String javaVersion;
    @Parameter(property="webapp.javaWebContainer", defaultValue="tomcat 8.5")
    protected String javaWebContainer;
    @Parameter(property="webapp.linuxRuntime")
    protected String linuxRuntime;
    @Parameter
    protected ContainerSetting containerSettings;
    @Parameter(property="webapp.stopAppDuringDeployment", defaultValue="false")
    protected boolean stopAppDuringDeployment;
    @Parameter(property="webapp.resources")
    protected List<Resource> resources;
    @Parameter(property="webapp.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="webapp.warFile")
    protected String warFile;
    @Parameter(property="webapp.jarFile")
    protected String jarFile;
    @Parameter(property="webapp.path", defaultValue="/")
    protected String path;
    @Parameter(property="webapp.region")
    protected String region;
    @Parameter(alias="deploymentSlot")
    protected DeploymentSlotSetting deploymentSlotSetting;
    @Parameter(property="schemaVersion", defaultValue="v1")
    protected String schemaVersion;
    @Parameter(property="runtime")
    protected RuntimeSetting runtime;
    @Parameter(property="deployment")
    protected Deployment deployment;
    private WebAppConfiguration webAppConfiguration;

    protected boolean isSkipMojo() {
        return this.skip;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppName() {
        return this.appName == null ? "" : this.appName;
    }

    public DeploymentSlotSetting getDeploymentSlotSetting() {
        return this.deploymentSlotSetting;
    }

    public String getAppServicePlanResourceGroup() {
        return this.appServicePlanResourceGroup;
    }

    public String getAppServicePlanName() {
        return this.appServicePlanName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPricingTier() {
        return this.pricingTier;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getLinuxRuntime() {
        return this.linuxRuntime;
    }

    public WebContainer getJavaWebContainer() {
        return StringUtils.isEmpty((String)this.javaWebContainer) ? WebContainer.TOMCAT_8_5_NEWEST : WebContainer.fromString((String)this.javaWebContainer);
    }

    public ContainerSetting getContainerSettings() {
        return this.containerSettings;
    }

    public boolean isStopAppDuringDeployment() {
        return this.stopAppDuringDeployment;
    }

    public List<Resource> getResources() {
        return this.resources == null ? Collections.EMPTY_LIST : this.resources;
    }

    public String getWarFile() {
        return this.warFile;
    }

    public String getJarFile() {
        return this.jarFile;
    }

    public String getPath() {
        return this.path;
    }

    public WebApp getWebApp() throws AzureAuthFailureException {
        try {
            return (WebApp)this.getAzureClient().webApps().getByResourceGroup(this.getResourceGroup(), this.getAppName());
        }
        catch (AzureAuthFailureException authEx) {
            throw authEx;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DeploymentSlot getDeploymentSlot(WebApp app, String slotName) {
        DeploymentSlot slot = null;
        if (StringUtils.isNotEmpty((String)slotName)) {
            try {
                slot = (DeploymentSlot)app.deploymentSlots().getByName(slotName);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return slot;
    }

    public boolean isDeployToDeploymentSlot() {
        return this.getDeploymentSlotSetting() != null;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public RuntimeSetting getRuntime() {
        return this.runtime;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public void setRuntime(RuntimeSetting runtime) {
        this.runtime = runtime;
    }

    protected ConfigurationParser getParserBySchemaVersion() throws MojoExecutionException {
        String schemaVersion = StringUtils.isEmpty((String)this.getSchemaVersion()) ? "v1" : this.getSchemaVersion();
        switch (schemaVersion.toLowerCase(Locale.ENGLISH)) {
            case "v1": {
                return new V1ConfigurationParser(this, new V1ConfigurationValidator(this));
            }
            case "v2": {
                return new V2ConfigurationParser(this, new V2ConfigurationValidator(this));
            }
        }
        throw new MojoExecutionException("Unknown value of <schemaVersion> in pom.xml.");
    }

    protected WebAppConfiguration getWebAppConfiguration() throws MojoExecutionException {
        if (this.webAppConfiguration == null) {
            this.webAppConfiguration = this.getParserBySchemaVersion().getWebAppConfiguration();
        }
        return this.webAppConfiguration;
    }

    public void setDeploymentSlot(DeploymentSlotSetting slotSetting) {
        this.deploymentSlotSetting = slotSetting;
    }

    public Map<String, String> getTelemetryProperties() {
        WebAppConfiguration webAppConfiguration;
        Map map = super.getTelemetryProperties();
        try {
            webAppConfiguration = this.getWebAppConfiguration();
        }
        catch (Exception e) {
            map.put(INVALID_CONFIG_KEY, e.getMessage());
            return map;
        }
        if (webAppConfiguration.getImage() != null) {
            String imageType = WebAppUtils.getDockerImageType(webAppConfiguration.getImage(), webAppConfiguration.getServerId(), webAppConfiguration.getRegistryUrl()).toString();
            map.put(DOCKER_IMAGE_TYPE_KEY, imageType);
        } else {
            map.put(DOCKER_IMAGE_TYPE_KEY, DockerImageType.NONE.toString());
        }
        map.put(SCHEMA_VERSION_KEY, this.schemaVersion);
        map.put(OS_KEY, webAppConfiguration.getOs() == null ? "" : webAppConfiguration.getOs().toString());
        map.put(JAVA_VERSION_KEY, webAppConfiguration.getJavaVersion() == null ? "" : webAppConfiguration.getJavaVersion().toString());
        map.put(JAVA_WEB_CONTAINER_KEY, webAppConfiguration.getWebContainer() == null ? "" : webAppConfiguration.getJavaVersion().toString());
        map.put(LINUX_RUNTIME_KEY, webAppConfiguration.getRuntimeStack() == null ? "" : webAppConfiguration.getRuntimeStack().stack() + " " + webAppConfiguration.getRuntimeStack().version());
        try {
            map.put(DEPLOYMENT_TYPE_KEY, this.getDeploymentType().toString());
        }
        catch (MojoExecutionException e) {
            map.put(DEPLOYMENT_TYPE_KEY, "Unknown deployment type.");
        }
        return map;
    }
}

