/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.maven.webapp.utils.FTPUtils;
import com.microsoft.azure.maven.webapp.utils.Utils;
import com.microsoft.azure.toolkits.appservice.model.DeployType;
import com.microsoft.azure.toolkits.appservice.model.PublishingProfile;
import com.microsoft.azure.toolkits.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkits.appservice.service.IAppService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.maven.model.Resource;

public class DeployUtils {
    private static final Path FTP_ROOT = Paths.get("/site/wwwroot", new String[0]);
    private static final String DEFAULT_APP_SERVICE_JAR_NAME = "app.jar";
    private static final String WEB_CONFIG = "web.config";
    private static final String RENAMING_MESSAGE = "Renaming %s to %s";
    private static final String RENAMING_FAILED_MESSAGE = "Failed to rename artifact to %s, which is required in Java SE environment, refer to https://docs.microsoft.com/en-us/azure/app-service/containers/configure-language-java#set-java-runtime-options for details.";
    private static final String NO_EXECUTABLE_JAR = "No executable jar found in target folder according to resource filter in <resource>, please make sure the resource filter is correct and you have built the jar.";
    private static final String MULTI_EXECUTABLE_JARS = "Multi executable jars found in <resources>, please check the configuration";

    public static boolean isExternalResource(Resource resource) {
        Path target = Paths.get(DeployUtils.getAbsoluteTargetPath(resource.getTargetPath()), new String[0]);
        return !target.startsWith(FTP_ROOT);
    }

    public static void deployResourcesWithFtp(IAppService appService, List<Resource> externalResources) throws AzureExecutionException {
        if (externalResources.isEmpty()) {
            return;
        }
        PublishingProfile publishingProfile = appService.getPublishingProfile();
        String serverUrl = publishingProfile.getFtpUrl().split("/", 2)[0];
        try {
            FTPClient ftpClient = FTPUtils.getFTPClient(serverUrl, publishingProfile.getFtpUsername(), publishingProfile.getFtpPassword());
            for (Resource externalResource : externalResources) {
                DeployUtils.uploadResource(externalResource, ftpClient);
            }
        }
        catch (IOException e) {
            throw new AzureExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isAllWarArtifacts(List<WebAppArtifact> webAppArtifacts) {
        Set deployTypes = webAppArtifacts.stream().map(WebAppArtifact::getDeployType).collect(Collectors.toSet());
        return deployTypes.size() == 1 && deployTypes.iterator().next() == DeployType.WAR;
    }

    private static void uploadResource(Resource resource, FTPClient ftpClient) throws IOException {
        List<File> files = Utils.getArtifacts(resource);
        String target = DeployUtils.getAbsoluteTargetPath(resource.getTargetPath());
        for (File file : files) {
            FTPUtils.uploadFile(ftpClient, file.getPath(), target);
        }
    }

    public static String getAbsoluteTargetPath(String targetPath) {
        return StringUtils.startsWith((CharSequence)(targetPath = StringUtils.defaultString((String)targetPath)), (CharSequence)"/") ? targetPath : FTP_ROOT.resolve(Paths.get(targetPath, new String[0])).normalize().toString();
    }

    public static void prepareJavaSERuntimeJarArtifact(List<File> artifacts, String finalName) throws AzureExecutionException {
        if (DeployUtils.existsWebConfig(artifacts)) {
            return;
        }
        File artifact = DeployUtils.getProjectJarArtifact(artifacts, finalName);
        File renamedArtifact = new File(artifact.getParent(), DEFAULT_APP_SERVICE_JAR_NAME);
        if (!StringUtils.equals((CharSequence)artifact.getName(), (CharSequence)DEFAULT_APP_SERVICE_JAR_NAME)) {
            Log.info((String)String.format(RENAMING_MESSAGE, artifact.getAbsolutePath(), DEFAULT_APP_SERVICE_JAR_NAME));
            if (!artifact.renameTo(renamedArtifact)) {
                throw new AzureExecutionException(String.format(RENAMING_FAILED_MESSAGE, DEFAULT_APP_SERVICE_JAR_NAME));
            }
        }
    }

    private static File getProjectJarArtifact(List<File> artifacts, String finalName) throws AzureExecutionException {
        List executableArtifacts = artifacts.stream().filter(file -> DeployUtils.isExecutableJar(file)).collect(Collectors.toList());
        File finalArtifact = executableArtifacts.stream().filter(file -> StringUtils.equals((CharSequence)finalName, (CharSequence)file.getName())).findFirst().orElse(null);
        if (executableArtifacts.size() == 0) {
            throw new AzureExecutionException(NO_EXECUTABLE_JAR);
        }
        if (finalArtifact == null && executableArtifacts.size() > 1) {
            throw new AzureExecutionException(MULTI_EXECUTABLE_JARS);
        }
        return finalArtifact == null ? (File)executableArtifacts.get(0) : finalArtifact;
    }

    private static boolean existsWebConfig(List<File> artifacts) {
        return artifacts.stream().anyMatch(file -> StringUtils.equals((CharSequence)file.getName(), (CharSequence)WEB_CONFIG));
    }

    /*
     * Exception decompiling
     */
    private static boolean isExecutableJar(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

