/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.parser;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.maven.MavenDockerCredentialProvider;
import com.microsoft.azure.maven.utils.MavenArtifactUtils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfig;
import com.microsoft.azure.maven.webapp.utils.DeployUtils;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import com.microsoft.azure.toolkits.appservice.model.DeployType;
import com.microsoft.azure.toolkits.appservice.model.DockerConfiguration;
import com.microsoft.azure.toolkits.appservice.model.PricingTier;
import com.microsoft.azure.toolkits.appservice.model.Runtime;
import com.microsoft.azure.toolkits.appservice.model.WebAppArtifact;
import com.microsoft.azure.tools.common.model.Region;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.settings.Settings;

public abstract class AbstractConfigParser {
    protected AbstractWebAppMojo mojo;
    protected AbstractConfigurationValidator validator;

    public AbstractConfigParser(AbstractWebAppMojo mojo, AbstractConfigurationValidator validator) {
        this.mojo = mojo;
        this.validator = validator;
    }

    public String getAppName() throws AzureExecutionException {
        this.validate(this.validator::validateAppName);
        return this.mojo.getAppName();
    }

    public String getResourceGroup() throws AzureExecutionException {
        this.validate(this.validator::validateResourceGroup);
        return this.mojo.getResourceGroup();
    }

    public String getDeploymentSlotName() {
        return this.mojo.getDeploymentSlotSetting() == null ? null : this.mojo.getDeploymentSlotSetting().getName();
    }

    public String getDeploymentSlotConfigurationSource() {
        return this.mojo.getDeploymentSlotSetting() == null ? null : this.mojo.getDeploymentSlotSetting().getConfigurationSource();
    }

    public PricingTier getPricingTier() throws AzureExecutionException {
        this.validate(this.validator::validatePricingTier);
        return PricingTier.fromString((String)this.mojo.getPricingTier());
    }

    public String getAppServicePlanName() throws AzureExecutionException {
        this.validate(this.validator::validateAppServicePlan);
        return this.mojo.getAppServicePlanName();
    }

    public String getAppServicePlanResourceGroup() throws AzureExecutionException {
        this.validate(this.validator::validateResourceGroup);
        return this.mojo.getAppServicePlanResourceGroup();
    }

    public abstract Region getRegion() throws AzureExecutionException;

    public abstract DockerConfiguration getDockerConfiguration() throws AzureExecutionException;

    public abstract List<WebAppArtifact> getMavenArtifacts() throws AzureExecutionException;

    public abstract Runtime getRuntime() throws AzureExecutionException;

    public WebAppConfig parse() throws AzureExecutionException {
        return ((WebAppConfig.WebAppConfigBuilder)((WebAppConfig.WebAppConfigBuilder)((WebAppConfig.WebAppConfigBuilder)((WebAppConfig.WebAppConfigBuilder)((WebAppConfig.WebAppConfigBuilder)((WebAppConfig.WebAppConfigBuilder)((WebAppConfig.WebAppConfigBuilder)((WebAppConfig.WebAppConfigBuilder)((WebAppConfig.WebAppConfigBuilder)((WebAppConfig.WebAppConfigBuilder)((WebAppConfig.WebAppConfigBuilder)WebAppConfig.builder().appName(this.getAppName())).resourceGroup(this.getResourceGroup())).servicePlanName(this.getAppServicePlanName())).servicePlanResourceGroup(this.getAppServicePlanResourceGroup())).pricingTier(this.getPricingTier())).region(this.getRegion())).runtime(this.getRuntime())).dockerConfiguration(this.getDockerConfiguration())).deploymentSlotName(this.getDeploymentSlotName())).deploymentSlotConfigurationSource(this.getDeploymentSlotConfigurationSource())).webAppArtifacts(this.getMavenArtifacts())).build();
    }

    protected MavenDockerCredentialProvider getDockerCredential(String serverId) {
        return MavenDockerCredentialProvider.fromMavenSettings((Settings)this.mojo.getSettings(), (String)serverId);
    }

    protected void validate(Supplier<String> validator) throws AzureExecutionException {
        String message = validator.get();
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            throw new AzureExecutionException(message);
        }
    }

    protected static List<WebAppArtifact> parseArtifactsFromResources(List<Resource> resources) {
        return CollectionUtils.isEmpty(resources) ? Collections.EMPTY_LIST : resources.stream().filter(resource -> !DeployUtils.isExternalResource(resource)).flatMap(resource -> AbstractConfigParser.convertResourceToArtifact(resource).stream()).collect(Collectors.toList());
    }

    protected static List<WebAppArtifact> convertResourceToArtifact(Resource resource) {
        return MavenArtifactUtils.getArtifacts((Resource)resource).stream().map(file -> WebAppArtifact.builder().file(file).deployType(AbstractConfigParser.getDeployTypeFromFile(file)).path(resource.getTargetPath()).build()).collect(Collectors.toList());
    }

    protected static DeployType getDeployTypeFromFile(File file) {
        DeployType type = DeployType.fromString((String)FilenameUtils.getExtension((String)file.getName()));
        return type == null ? DeployType.ZIP : type;
    }
}

