/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.resources.models.Subscription;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.common.appservice.DockerImageType;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.common.utils.TextUtils;
import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.maven.AbstractAppServiceMojo;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.auth.MavenAuthManager;
import com.microsoft.azure.maven.model.MavenAuthConfiguration;
import com.microsoft.azure.maven.model.SubscriptionOption2;
import com.microsoft.azure.maven.utils.CustomTextIoStringListReader;
import com.microsoft.azure.maven.utils.SystemPropertyUtils;
import com.microsoft.azure.maven.webapp.WebAppConfig;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.configuration.Deployment;
import com.microsoft.azure.maven.webapp.configuration.MavenRuntimeConfig;
import com.microsoft.azure.maven.webapp.configuration.SchemaVersion;
import com.microsoft.azure.maven.webapp.parser.AbstractConfigParser;
import com.microsoft.azure.maven.webapp.parser.V1ConfigParser;
import com.microsoft.azure.maven.webapp.parser.V2ConfigParser;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import com.microsoft.azure.maven.webapp.validator.V1ConfigurationValidator;
import com.microsoft.azure.maven.webapp.validator.V2ConfigurationValidator;
import com.microsoft.azure.toolkits.appservice.AzureAppService;
import com.microsoft.azure.toolkits.appservice.model.DockerConfiguration;
import com.microsoft.azure.tools.auth.exception.AzureLoginException;
import com.microsoft.azure.tools.auth.model.AzureCredentialWrapper;
import com.microsoft.azure.tools.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.tools.common.util.StringListUtils;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.Parameter;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextIoFactory;

public abstract class AbstractWebAppMojo
extends AbstractAppServiceMojo {
    public static final String JAVA_VERSION_KEY = "javaVersion";
    public static final String JAVA_WEB_CONTAINER_KEY = "javaWebContainer";
    public static final String DOCKER_IMAGE_TYPE_KEY = "dockerImageType";
    public static final String DEPLOYMENT_TYPE_KEY = "deploymentType";
    public static final String OS_KEY = "os";
    public static final String INVALID_CONFIG_KEY = "invalidConfiguration";
    public static final String SCHEMA_VERSION_KEY = "schemaVersion";
    @Parameter(property="webapp.pricingTier")
    protected String pricingTier;
    @Deprecated
    @Parameter(property="webapp.javaVersion")
    protected String javaVersion;
    @Deprecated
    @Parameter(property="webapp.javaWebContainer", defaultValue="tomcat 8.5")
    protected String javaWebContainer;
    @Deprecated
    @Parameter(property="webapp.linuxRuntime")
    protected String linuxRuntime;
    @Deprecated
    @Parameter
    protected ContainerSetting containerSettings;
    @Deprecated
    @Parameter(property="webapp.stopAppDuringDeployment", defaultValue="false")
    protected boolean stopAppDuringDeployment;
    @Deprecated
    @Parameter(property="webapp.resources")
    protected List<Resource> resources;
    @Parameter(property="webapp.skip", defaultValue="false")
    protected boolean skip;
    @Deprecated
    @Parameter(property="webapp.warFile")
    protected String warFile;
    @Deprecated
    @Parameter(property="webapp.jarFile")
    protected String jarFile;
    @Deprecated
    @Parameter(property="webapp.path", defaultValue="/")
    protected String path;
    @Parameter(property="webapp.region")
    protected String region;
    @Parameter(property="schemaVersion", defaultValue="v2")
    protected String schemaVersion;
    @Parameter(property="runtime")
    protected MavenRuntimeConfig runtime;
    @Parameter(property="deployment")
    protected Deployment deployment;
    private WebAppConfiguration webAppConfiguration;
    protected File stagingDirectory;
    protected AzureAppService az;
    private boolean isRuntimeInjected = false;

    protected boolean isSkipMojo() {
        return this.skip;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppName() {
        return this.appName == null ? "" : this.appName;
    }

    public String getAppServicePlanResourceGroup() {
        return this.appServicePlanResourceGroup;
    }

    public String getAppServicePlanName() {
        return this.appServicePlanName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getPricingTier() {
        return this.pricingTier;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getLinuxRuntime() {
        return this.linuxRuntime;
    }

    public WebContainer getJavaWebContainer() {
        return StringUtils.isEmpty((CharSequence)this.javaWebContainer) ? WebContainer.TOMCAT_8_5_NEWEST : WebContainer.fromString((String)this.javaWebContainer);
    }

    public ContainerSetting getContainerSettings() {
        return this.containerSettings;
    }

    public boolean isStopAppDuringDeployment() {
        return this.stopAppDuringDeployment;
    }

    public List<Resource> getResources() {
        return this.resources == null ? Collections.emptyList() : this.resources;
    }

    public String getWarFile() {
        return this.warFile;
    }

    public String getJarFile() {
        return this.jarFile;
    }

    public String getPath() {
        return this.path;
    }

    public WebApp getWebApp() throws AzureAuthFailureException, AzureExecutionException {
        return (WebApp)this.getAzureClient().webApps().getByResourceGroup(this.getResourceGroup(), this.getAppName());
    }

    public DeploymentSlot getDeploymentSlot(WebApp app, String slotName) {
        DeploymentSlot slot = null;
        if (StringUtils.isNotEmpty((CharSequence)slotName)) {
            try {
                slot = (DeploymentSlot)app.deploymentSlots().getByName(slotName);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return slot;
    }

    public boolean isDeployToDeploymentSlot() {
        return this.getDeploymentSlotSetting() != null;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public MavenRuntimeConfig getRuntime() {
        if (!this.isRuntimeInjected) {
            this.setRuntime((MavenRuntimeConfig)SystemPropertyUtils.injectCommandLineParameter((String)"runtime", (Object)this.runtime, MavenRuntimeConfig.class));
            this.isRuntimeInjected = true;
        }
        return this.runtime;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public void setRuntime(MavenRuntimeConfig runtime) {
        this.runtime = runtime;
    }

    public Map<String, String> getTelemetryProperties() {
        WebAppConfig webAppConfig;
        Map map = super.getTelemetryProperties();
        try {
            webAppConfig = this.getWebAppConfig();
        }
        catch (Exception e) {
            map.put(INVALID_CONFIG_KEY, e.getMessage());
            return map;
        }
        if (webAppConfig.getDockerConfiguration() != null) {
            DockerConfiguration dockerConfiguration = webAppConfig.getDockerConfiguration();
            String imageType = AppServiceUtils.getDockerImageType((String)dockerConfiguration.getImage(), (boolean)StringUtils.isEmpty((CharSequence)dockerConfiguration.getPassword()), (String)dockerConfiguration.getRegistryUrl()).name();
            map.put(DOCKER_IMAGE_TYPE_KEY, imageType);
        } else {
            map.put(DOCKER_IMAGE_TYPE_KEY, DockerImageType.NONE.toString());
        }
        map.put(SCHEMA_VERSION_KEY, this.schemaVersion);
        map.put(OS_KEY, webAppConfig.getRuntime() == null ? "" : Objects.toString(webAppConfig.getRuntime().getOperatingSystem()));
        map.put(JAVA_VERSION_KEY, webAppConfig.getRuntime() == null || webAppConfig.getRuntime().getJavaVersion() == null ? "" : webAppConfig.getRuntime().getJavaVersion().toString());
        map.put(JAVA_WEB_CONTAINER_KEY, webAppConfig.getRuntime() == null || webAppConfig.getRuntime().getWebContainer() == null ? "" : webAppConfig.getRuntime().getWebContainer().toString());
        try {
            map.put(DEPLOYMENT_TYPE_KEY, this.getDeploymentType().toString());
        }
        catch (AzureExecutionException e) {
            map.put(DEPLOYMENT_TYPE_KEY, "Unknown deployment type.");
        }
        return map;
    }

    protected WebAppConfig getWebAppConfig() throws AzureExecutionException {
        SchemaVersion version = SchemaVersion.fromString(this.getSchemaVersion());
        AbstractConfigurationValidator validator = version == SchemaVersion.V2 ? new V2ConfigurationValidator(this) : new V1ConfigurationValidator(this);
        AbstractConfigParser parser = version == SchemaVersion.V2 ? new V2ConfigParser(this, validator) : new V1ConfigParser(this, validator);
        return parser.parse();
    }

    protected AzureAppService getOrCreateAzureAppServiceClient() throws AzureExecutionException {
        try {
            MavenAuthConfiguration mavenAuthConfiguration = this.auth == null ? new MavenAuthConfiguration() : this.auth;
            mavenAuthConfiguration.setType(this.getAuthType());
            AzureCredentialWrapper azureCredentialWrapper = MavenAuthManager.getInstance().login(this.session, this.settingsDecrypter, mavenAuthConfiguration);
            if (Objects.isNull(azureCredentialWrapper)) {
                return null;
            }
            AzureEnvironment env = azureCredentialWrapper.getEnv();
            String environmentName = AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)env);
            if (env != AzureEnvironment.AZURE) {
                Log.prompt((String)String.format("Using Azure environment: %s.", com.microsoft.azure.toolkit.lib.common.utils.TextUtils.cyan((String)environmentName)));
            }
            Log.info((String)azureCredentialWrapper.getCredentialDescription());
            AzureProfile profile = new AzureProfile(azureCredentialWrapper.getTenantId(), this.getSubscriptionId(), this.convertEnvironment(azureCredentialWrapper.getEnv()));
            AzureResourceManager.Authenticated authenticated = AzureResourceManager.configure().authenticate(azureCredentialWrapper.getTokenCredential(), profile);
            List<Subscription> subscriptions = authenticated.subscriptions().list().stream().collect(Collectors.toList());
            String targetSubscriptionId = this.getTargetSubscriptionId(azureCredentialWrapper, subscriptions);
            AbstractWebAppMojo.checkSubscription(subscriptions, targetSubscriptionId);
            azureCredentialWrapper.withDefaultSubscriptionId(targetSubscriptionId);
            AzureResourceManager azureResourceManager = authenticated.withSubscription(targetSubscriptionId);
            Subscription subscription = azureResourceManager.getCurrentSubscription();
            if (subscription != null) {
                Log.info((String)String.format("Subscription: %s(%s)", com.microsoft.azure.toolkit.lib.common.utils.TextUtils.cyan((String)subscription.displayName()), com.microsoft.azure.toolkit.lib.common.utils.TextUtils.cyan((String)subscription.subscriptionId())));
            }
            return AzureAppService.auth((AzureResourceManager)azureResourceManager);
        }
        catch (AzureExecutionException | AzureLoginException e) {
            throw new AzureExecutionException(e.getMessage());
        }
    }

    private String getTargetSubscriptionId(AzureCredentialWrapper azureCredentialWrapper, List<Subscription> subscriptions) throws AzureExecutionException {
        Collection filteredSubscriptions;
        List subsIdList = subscriptions.stream().map(Subscription::subscriptionId).collect(Collectors.toList());
        String targetSubscriptionId = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.subscriptionId, azureCredentialWrapper.getDefaultSubscriptionId()});
        if (StringUtils.isBlank((CharSequence)targetSubscriptionId) && ArrayUtils.isNotEmpty((Object[])azureCredentialWrapper.getFilteredSubscriptionIds()) && (filteredSubscriptions = StringListUtils.intersectIgnoreCase(subsIdList, Arrays.asList(azureCredentialWrapper.getFilteredSubscriptionIds()))).size() == 1) {
            targetSubscriptionId = (String)filteredSubscriptions.iterator().next();
        }
        if (StringUtils.isBlank((CharSequence)targetSubscriptionId)) {
            return this.selectSubscription(subscriptions.toArray(new Subscription[0]));
        }
        return targetSubscriptionId;
    }

    protected String selectSubscription(Subscription[] subscriptions) throws AzureExecutionException {
        if (subscriptions.length == 0) {
            throw new AzureExecutionException("Cannot find any subscriptions in current account.");
        }
        if (subscriptions.length == 1) {
            Log.info((String)String.format("There is only one subscription '%s' in your account, will use it automatically.", TextUtils.blue((String)SubscriptionOption2.getSubscriptionName((Subscription)subscriptions[0]))));
            return subscriptions[0].subscriptionId();
        }
        List wrapSubs = Arrays.stream(subscriptions).map(t -> new SubscriptionOption2(t)).sorted().collect(Collectors.toList());
        SubscriptionOption2 defaultValue = wrapSubs.stream().findFirst().orElse(null);
        TextIO textIO = TextIoFactory.getTextIO();
        SubscriptionOption2 subscriptionOptionSelected = (SubscriptionOption2)((GenericInputReader)((GenericInputReader)new CustomTextIoStringListReader(() -> textIO.getTextTerminal(), null).withCustomPrompt(String.format("Please choose a subscription%s: ", AbstractWebAppMojo.highlightDefaultValue((String)(defaultValue == null ? null : defaultValue.getSubscriptionName())))).withNumberedPossibleValues(wrapSubs)).withDefaultValue((Object)defaultValue)).read(new String[]{"Available subscriptions:"});
        if (subscriptionOptionSelected == null) {
            throw new AzureExecutionException("You must select a subscription.");
        }
        return subscriptionOptionSelected.getSubscription().subscriptionId();
    }

    private static void checkSubscription(List<Subscription> subscriptions, String targetSubscriptionId) throws AzureLoginException {
        if (StringUtils.isEmpty((CharSequence)targetSubscriptionId)) {
            Log.warn((String)"Subscription ID was not specified, using the first subscription in current account, please refer https://github.com/microsoft/azure-maven-plugins/wiki/Authentication#subscription for more information.");
            return;
        }
        Optional<Subscription> optionalSubscription = subscriptions.stream().filter(subscription -> StringUtils.equals((CharSequence)subscription.subscriptionId(), (CharSequence)targetSubscriptionId)).findAny();
        if (!optionalSubscription.isPresent()) {
            throw new AzureLoginException(String.format("Subscription %s was not found in current account.", targetSubscriptionId));
        }
    }

    private com.azure.core.management.AzureEnvironment convertEnvironment(AzureEnvironment environment) {
        return com.azure.core.management.AzureEnvironment.knownEnvironments().stream().filter(env -> StringUtils.equals((CharSequence)environment.managementEndpoint(), (CharSequence)env.getManagementEndpoint())).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeploymentStagingDirectoryPath() {
        if (this.stagingDirectory == null) {
            AbstractWebAppMojo abstractWebAppMojo = this;
            synchronized (abstractWebAppMojo) {
                if (this.stagingDirectory == null) {
                    String outputFolder = this.getPluginName().replaceAll("-maven-plugin", "");
                    String stagingDirectoryPath = Paths.get(this.getBuildDirectoryAbsolutePath(), outputFolder, String.format("%s-%s", this.getAppName(), UUID.randomUUID().toString())).toString();
                    this.stagingDirectory = new File(stagingDirectoryPath);
                    if (!this.stagingDirectory.exists()) {
                        this.stagingDirectory.mkdirs();
                    }
                }
            }
        }
        return this.stagingDirectory.getPath();
    }
}

