/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.maven.webapp.utils.JavaVersionUtils;
import com.microsoft.azure.maven.webapp.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class RuntimeStackUtils {
    private static final List<String> JAVA_STACKS = Arrays.asList(RuntimeStack.JAVA_8_JRE8.stack(), RuntimeStack.TOMCAT_8_5_JRE8.stack(), RuntimeStack.JBOSS_EAP_7_2_JAVA8.stack());
    private static final List<RuntimeStack> RUNTIME_STACKS = new ArrayList<RuntimeStack>();

    public static String getJavaVersionFromRuntimeStack(RuntimeStack runtimeStack) {
        if (Objects.isNull(runtimeStack)) {
            return null;
        }
        String javaVersion = runtimeStack.version().split("-")[1];
        return JavaVersionUtils.formatJavaVersion(javaVersion);
    }

    public static String getWebContainerFromRuntimeStack(RuntimeStack runtimeStack) {
        if (Objects.isNull(runtimeStack)) {
            return null;
        }
        String stack = StringUtils.capitalize((String)StringUtils.lowerCase((String)runtimeStack.stack()));
        String version = runtimeStack.version();
        return stack.equalsIgnoreCase("JAVA") ? "Java SE" : stack + " " + version.split("-")[0];
    }

    public static RuntimeStack getJavaSERuntimeStack(String javaVersion) {
        for (RuntimeStack runtimeStack : RuntimeStackUtils.getValidRuntimeStacks()) {
            if (!runtimeStack.stack().equals("JAVA") || !JavaVersionUtils.equalsJavaVersion(RuntimeStackUtils.getJavaVersionFromRuntimeStack(runtimeStack), javaVersion)) continue;
            return runtimeStack;
        }
        return null;
    }

    public static RuntimeStack getRuntimeStack(String javaVersion, String webContainer) {
        if (StringUtils.isEmpty((CharSequence)webContainer) || JavaVersionUtils.getValidJavaVersions().contains(webContainer) || Objects.nonNull((Object)JavaVersionUtils.parseJavaVersionEnum(webContainer)) || Objects.nonNull(Utils.findStringInCollectionIgnoreCase(Arrays.asList("JAVA", "Java SE", "java 11"), webContainer))) {
            return RuntimeStackUtils.getJavaSERuntimeStack(javaVersion);
        }
        String formattedJavaVersion = JavaVersionUtils.formatJavaVersion(javaVersion);
        for (RuntimeStack runtimeStack : RuntimeStackUtils.getValidRuntimeStacks()) {
            if (!RuntimeStackUtils.getJavaVersionFromRuntimeStack(runtimeStack).equalsIgnoreCase(formattedJavaVersion) || !RuntimeStackUtils.getWebContainerFromRuntimeStack(runtimeStack).equalsIgnoreCase(webContainer)) continue;
            return runtimeStack;
        }
        return null;
    }

    public static List<RuntimeStack> getValidRuntimeStacks() {
        return new ArrayList<RuntimeStack>(RUNTIME_STACKS);
    }

    public static List<String> getValidLinuxRuntimeStacksForJavaVersion(String javaVersion) {
        HashSet<String> result = new HashSet<String>();
        for (RuntimeStack runtimeStack : RuntimeStackUtils.getValidRuntimeStacks()) {
            if (!JavaVersionUtils.equalsJavaVersion(RuntimeStackUtils.getJavaVersionFromRuntimeStack(runtimeStack), javaVersion) || runtimeStack.stack().equals("JAVA")) continue;
            result.add(RuntimeStackUtils.getWebContainerFromRuntimeStack(runtimeStack));
        }
        return new ArrayList<String>(result);
    }

    static {
        for (Field field : FieldUtils.getAllFieldsList(RuntimeStack.class)) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(RuntimeStack.class)) continue;
            try {
                RuntimeStack runtimeStack = (RuntimeStack)field.get(null);
                if (!JAVA_STACKS.contains(runtimeStack.stack())) continue;
                RUNTIME_STACKS.add(runtimeStack);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

