/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.serializer;

import com.microsoft.azure.common.appservice.DeploymentSlotSetting;
import com.microsoft.azure.common.appservice.OperatingSystemEnum;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.serializer.ConfigurationSerializer;
import com.microsoft.azure.maven.webapp.utils.JavaVersionUtils;
import com.microsoft.azure.maven.webapp.utils.RuntimeStackUtils;
import com.microsoft.azure.maven.webapp.utils.WebContainerUtils;
import com.microsoft.azure.maven.webapp.utils.XMLUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;

public class V2ConfigurationSerializer
extends ConfigurationSerializer {
    public V2ConfigurationSerializer(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs) {
        super(newConfigs, oldConfigs);
    }

    @Override
    public void saveToXML(Element configurationElement) throws MojoFailureException {
        this.createOrUpdateAttribute("schemaVersion", "v2", this.oldConfigs.getSchemaVersion(), configurationElement);
        this.createOrUpdateAttribute("subscriptionId", this.newConfigs.getSubscriptionId(), this.oldConfigs.getSubscriptionId(), configurationElement);
        this.createOrUpdateAttribute("resourceGroup", this.newConfigs.getResourceGroup(), this.oldConfigs.getResourceGroup(), configurationElement);
        this.createOrUpdateAttribute("appName", this.newConfigs.getAppName(), this.oldConfigs.getAppName(), configurationElement);
        this.createOrUpdateAttribute("pricingTier", AppServiceUtils.convertPricingTierToString((PricingTier)this.newConfigs.getPricingTier()), AppServiceUtils.convertPricingTierToString((PricingTier)this.oldConfigs.getPricingTier()), configurationElement);
        if (this.newConfigs.getRegion() != null) {
            String oldRegion = this.oldConfigs.getRegion() == null ? null : this.oldConfigs.getRegion().name();
            this.createOrUpdateAttribute("region", this.newConfigs.getRegion().name(), oldRegion, configurationElement);
        }
        this.createOrUpdateAttribute("appServicePlanName", this.newConfigs.getServicePlanName(), this.oldConfigs.getServicePlanName(), configurationElement);
        this.createOrUpdateAttribute("appServicePlanResourceGroup", this.newConfigs.getServicePlanResourceGroup(), this.oldConfigs.getServicePlanResourceGroup(), configurationElement);
        if (this.newConfigs.getOs() != null) {
            this.updateRunTimeNode(this.newConfigs, this.oldConfigs, configurationElement);
        }
        if (this.newConfigs.getDeploymentSlotSetting() == null) {
            XMLUtils.removeNode(configurationElement, "deploymentSlot");
        } else {
            Element deploymentSlot = XMLUtils.getOrCreateSubElement("deploymentSlot", configurationElement);
            DeploymentSlotSetting oldDeploymentSlotSetting = this.oldConfigs.getDeploymentSlotSetting() == null ? new DeploymentSlotSetting() : this.oldConfigs.getDeploymentSlotSetting();
            this.updateDeploymentSlotNode(this.newConfigs.getDeploymentSlotSetting(), oldDeploymentSlotSetting, deploymentSlot);
        }
        if (configurationElement.element("deployment") == null && this.newConfigs.getResources() != null) {
            configurationElement.add((Element)this.createDeploymentNode(this.newConfigs));
        }
    }

    private void updateRunTimeNode(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs, Element configurationElement) throws MojoFailureException {
        Element runtime = XMLUtils.getOrCreateSubElement("runtime", configurationElement);
        if (!newConfigs.getOs().equals((Object)oldConfigs.getOs())) {
            XMLUtils.clearNode(runtime);
        }
        switch (newConfigs.getOs()) {
            case Linux: {
                this.updateLinuxRunTimeNode(newConfigs, oldConfigs, runtime);
                break;
            }
            case Windows: {
                this.updateWindowsRunTimeNode(newConfigs, oldConfigs, runtime);
                break;
            }
            case Docker: {
                this.updateDockerRunTimeNode(newConfigs, oldConfigs, runtime);
                break;
            }
            default: {
                throw new MojoFailureException("The value of <os> is unknown.");
            }
        }
    }

    private void updateLinuxRunTimeNode(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs, Element configurationElement) {
        String oldOS = V2ConfigurationSerializer.formatOperationSystem(oldConfigs.getOs());
        this.createOrUpdateAttribute("os", "Linux", oldOS, configurationElement);
        if (newConfigs.getRuntimeStack() != null) {
            String oldJavaVersion = oldConfigs.getRuntimeStack() == null ? null : RuntimeStackUtils.getJavaVersionFromRuntimeStack(oldConfigs.getRuntimeStack());
            this.createOrUpdateAttribute("javaVersion", RuntimeStackUtils.getJavaVersionFromRuntimeStack(newConfigs.getRuntimeStack()), oldJavaVersion, configurationElement);
            String oldWebContainer = oldConfigs.getRuntimeStack() == null ? null : RuntimeStackUtils.getWebContainerFromRuntimeStack(oldConfigs.getRuntimeStack());
            this.createOrUpdateAttribute("webContainer", RuntimeStackUtils.getWebContainerFromRuntimeStack(newConfigs.getRuntimeStack()), oldWebContainer, configurationElement);
        }
    }

    private void updateWindowsRunTimeNode(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs, Element configurationElement) {
        String oldOS = V2ConfigurationSerializer.formatOperationSystem(oldConfigs.getOs());
        this.createOrUpdateAttribute("os", "Windows", oldOS, configurationElement);
        if (newConfigs.getJavaVersion() != null) {
            String oldJavaVersion = oldConfigs.getJavaVersion() == null ? null : JavaVersionUtils.formatJavaVersion(oldConfigs.getJavaVersion());
            this.createOrUpdateAttribute("javaVersion", JavaVersionUtils.formatJavaVersion(newConfigs.getJavaVersion()), oldJavaVersion, configurationElement);
        }
        if (newConfigs.getWebContainer() != null) {
            String oldWebContainer = WebContainerUtils.formatWebContainer(oldConfigs.getWebContainer());
            this.createOrUpdateAttribute("webContainer", WebContainerUtils.formatWebContainer(newConfigs.getWebContainer()), oldWebContainer, configurationElement);
        }
    }

    private void updateDockerRunTimeNode(WebAppConfiguration newConfigs, WebAppConfiguration oldConfigs, Element configurationElement) {
        String oldOS = V2ConfigurationSerializer.formatOperationSystem(oldConfigs.getOs());
        this.createOrUpdateAttribute("os", "Docker", oldOS, configurationElement);
        this.createOrUpdateAttribute("image", newConfigs.getImage(), oldConfigs.getImage(), configurationElement);
        this.createOrUpdateAttribute("serverId", newConfigs.getServerId(), oldConfigs.getServerId(), configurationElement);
        this.createOrUpdateAttribute("registryUrl", newConfigs.getRegistryUrl(), oldConfigs.getRegistryUrl(), configurationElement);
    }

    protected void updateDeploymentSlotNode(DeploymentSlotSetting newConfigs, DeploymentSlotSetting oldConfigs, Element deploymentSlotRoot) {
        this.createOrUpdateAttribute("name", newConfigs.getName(), oldConfigs.getName(), deploymentSlotRoot);
        this.createOrUpdateAttribute("configurationSource", newConfigs.getConfigurationSource(), oldConfigs.getConfigurationSource(), deploymentSlotRoot);
    }

    private DOMElement createDeploymentNode(WebAppConfiguration webAppConfiguration) {
        DOMElement deploymentNode = new DOMElement("deployment");
        deploymentNode.add((Element)this.createResourcesNode(webAppConfiguration.getResources()));
        return deploymentNode;
    }

    private static String formatOperationSystem(OperatingSystemEnum osEnum) {
        return osEnum == null ? null : StringUtils.capitalise((String)osEnum.toString());
    }
}

