/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.parser;

import com.microsoft.azure.common.appservice.DeploymentSlotSetting;
import com.microsoft.azure.common.appservice.OperatingSystemEnum;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.validator.AbstractConfigurationValidator;
import java.util.List;
import org.apache.maven.model.Resource;

public abstract class ConfigurationParser {
    protected final AbstractWebAppMojo mojo;
    protected final AbstractConfigurationValidator validator;

    protected ConfigurationParser(AbstractWebAppMojo mojo, AbstractConfigurationValidator validator) {
        this.mojo = mojo;
        this.validator = validator;
    }

    protected String getAppName() throws AzureExecutionException {
        this.validate(this.validator.validateAppName());
        return this.mojo.getAppName();
    }

    protected String getResourceGroup() throws AzureExecutionException {
        this.validate(this.validator.validateResourceGroup());
        return this.mojo.getResourceGroup();
    }

    protected PricingTier getPricingTier() throws AzureExecutionException {
        this.validate(this.validator.validatePricingTier());
        return AppServiceUtils.getPricingTierFromString((String)this.mojo.getPricingTier());
    }

    protected DeploymentSlotSetting getDeploymentSlotSetting() throws AzureExecutionException {
        this.validate(this.validator.validateDeploymentSlot());
        return this.mojo.getDeploymentSlotSetting();
    }

    protected abstract OperatingSystemEnum getOs() throws AzureExecutionException;

    protected abstract Region getRegion() throws AzureExecutionException;

    protected abstract RuntimeStack getRuntimeStack() throws AzureExecutionException;

    protected abstract String getImage() throws AzureExecutionException;

    protected abstract String getServerId() throws AzureExecutionException;

    protected abstract String getRegistryUrl();

    protected abstract String getSchemaVersion();

    protected abstract JavaVersion getJavaVersion() throws AzureExecutionException;

    protected abstract WebContainer getWebContainer() throws AzureExecutionException;

    protected abstract List<Resource> getResources() throws AzureExecutionException;

    protected void validate(String errorMessage) throws AzureExecutionException {
        if (errorMessage != null) {
            throw new AzureExecutionException(errorMessage);
        }
    }

    public WebAppConfiguration getWebAppConfiguration() throws AzureExecutionException {
        WebAppConfiguration.Builder builder = new WebAppConfiguration.Builder();
        OperatingSystemEnum os = this.getOs();
        if (os == null) {
            Log.debug((String)"No runtime related config is specified. It will cause error if creating a new web app.");
        } else {
            switch (os) {
                case Windows: {
                    builder = builder.javaVersion(this.getJavaVersion()).webContainer(this.getWebContainer());
                    break;
                }
                case Linux: {
                    builder = builder.runtimeStack(this.getRuntimeStack());
                    break;
                }
                case Docker: {
                    builder = builder.image(this.getImage()).serverId(this.getServerId()).registryUrl(this.getRegistryUrl());
                    break;
                }
                default: {
                    throw new AzureExecutionException("Invalid operating system from the configuration.");
                }
            }
        }
        return builder.appName(this.getAppName()).resourceGroup(this.getResourceGroup()).region(this.getRegion()).pricingTier(this.getPricingTier()).servicePlanName(this.mojo.getAppServicePlanName()).servicePlanResourceGroup(this.mojo.getAppServicePlanResourceGroup()).deploymentSlotSetting(this.getDeploymentSlotSetting()).os(os).mavenSettings(this.mojo.getSettings()).resources(this.getResources()).stagingDirectoryPath(this.mojo.getDeploymentStagingDirectoryPath()).buildDirectoryAbsolutePath(this.mojo.getBuildDirectoryAbsolutePath()).project(this.mojo.getProject()).session(this.mojo.getSession()).filtering(this.mojo.getMavenResourcesFiltering()).schemaVersion(this.getSchemaVersion()).build();
    }
}

