/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.models;

import com.microsoft.azure.common.utils.AppServiceUtils;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.WebAppsInner;
import org.apache.commons.lang3.StringUtils;
import rx.Observable;

public class WebAppOption
implements Comparable<WebAppOption> {
    public static final WebAppOption CREATE_NEW = new WebAppOption();
    private static final String CREATE_NEW_STRING = "<create>";
    private SiteInner siteInner;
    private SiteConfigResourceInner siteConfig;
    private WebAppsInner webappClient;
    private boolean createNewPlaceHolder = false;

    public WebAppOption(SiteInner siteInner, WebAppsInner webappClient) {
        this.siteInner = siteInner;
        this.webappClient = webappClient;
    }

    public String getId() {
        return this.siteInner == null ? null : this.siteInner.id();
    }

    public String toString() {
        if (this.isCreateNew()) {
            return CREATE_NEW_STRING;
        }
        return this.siteInner != null ? String.format("%s (%s)", this.siteInner.name(), this.getDescription().toLowerCase()) : null;
    }

    @Override
    public int compareTo(WebAppOption other) {
        int typeCompareResult = new Boolean(this.createNewPlaceHolder).compareTo(other.isCreateNew());
        if (typeCompareResult != 0) {
            return typeCompareResult;
        }
        String name1 = this.toString();
        String name2 = other.siteInner != null ? other.toString() : null;
        return StringUtils.compare((String)name1, (String)name2);
    }

    private WebAppOption() {
        this.createNewPlaceHolder = true;
    }

    public boolean isCreateNew() {
        return this.createNewPlaceHolder;
    }

    public Observable<WebAppOption> loadConfigurationSync() {
        return Observable.fromCallable(() -> {
            this.siteConfig = this.webappClient.getConfiguration(this.siteInner.resourceGroup(), this.siteInner.name());
            return this;
        });
    }

    public String getServicePlanId() {
        if (this.siteInner == null) {
            return null;
        }
        return this.siteInner.serverFarmId();
    }

    public boolean isDockerWebapp() {
        String linuxFxVersion = this.getLinuxFxVersion();
        return StringUtils.containsIgnoreCase((CharSequence)linuxFxVersion, (CharSequence)"DOCKER|");
    }

    public boolean isJavaWebApp() {
        if (this.siteInner == null) {
            return false;
        }
        OperatingSystem os = this.getOperatingSystem();
        JavaVersion javaVersion = this.getJavaVersion();
        String linuxFxVersion = this.getLinuxFxVersion();
        return os == OperatingSystem.WINDOWS && javaVersion != JavaVersion.OFF || os == OperatingSystem.LINUX && (StringUtils.containsIgnoreCase((CharSequence)linuxFxVersion, (CharSequence)"-jre") || StringUtils.containsIgnoreCase((CharSequence)linuxFxVersion, (CharSequence)"-java"));
    }

    public boolean isJavaSE() {
        if (!this.isJavaWebApp() || this.isDockerWebapp()) {
            return false;
        }
        OperatingSystem os = this.getOperatingSystem();
        if (os == OperatingSystem.WINDOWS) {
            return StringUtils.startsWithIgnoreCase((CharSequence)this.siteConfig.javaContainer(), (CharSequence)"java");
        }
        if (os == OperatingSystem.LINUX) {
            String linuxFxVersion = this.getLinuxFxVersion();
            return StringUtils.startsWithIgnoreCase((CharSequence)linuxFxVersion, (CharSequence)"java");
        }
        return false;
    }

    public String getLinuxFxVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.linuxFxVersion();
    }

    public JavaVersion getJavaVersion() {
        if (this.siteConfig == null || this.siteConfig.javaVersion() == null) {
            return JavaVersion.OFF;
        }
        return JavaVersion.fromString((String)this.siteConfig.javaVersion());
    }

    public OperatingSystem getOperatingSystem() {
        if (this.siteInner == null || this.siteConfig == null) {
            return null;
        }
        if (this.siteInner.kind() != null && this.siteInner.kind().toLowerCase().contains("linux")) {
            return OperatingSystem.LINUX;
        }
        return OperatingSystem.WINDOWS;
    }

    public String getDescription() {
        if (this.siteInner == null || this.siteConfig == null) {
            return "unknown";
        }
        if (this.isDockerWebapp()) {
            return "docker";
        }
        OperatingSystem os = this.getOperatingSystem();
        if (os == OperatingSystem.WINDOWS) {
            if (StringUtils.isNotBlank((CharSequence)this.siteConfig.javaContainer())) {
                return "windows, " + this.siteConfig.javaContainer() + " " + this.siteConfig.javaContainerVersion();
            }
            return "windows, java " + this.siteConfig.javaVersion();
        }
        return "linux, " + AppServiceUtils.parseRuntimeStack((String)this.getLinuxFxVersion());
    }
}

