/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers.artifact;

import com.google.common.io.Files;
import com.microsoft.azure.common.deploytarget.DeployTarget;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.handlers.artifact.ZIPArtifactHandlerImpl;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public final class JarArtifactHandlerImpl
extends ZIPArtifactHandlerImpl {
    private String jarFile;
    public static final String FILE_IS_NOT_JAR = "The deployment file is not a jar typed file.";
    public static final String FIND_JAR_FILE_FAIL = "Failed to find the jar file: '%s'";

    protected JarArtifactHandlerImpl(Builder builder) {
        super((ZIPArtifactHandlerImpl.Builder)builder);
        this.jarFile = builder.jarFile;
    }

    public void publish(DeployTarget deployTarget) throws AzureExecutionException {
        File jar = this.getJarFile();
        this.assureJarFileExisted(jar);
        try {
            this.prepareDeploymentFiles(jar);
        }
        catch (IOException e) {
            throw new AzureExecutionException(String.format("Cannot copy jar to staging directory: '%s'", jar), (Throwable)e);
        }
        super.publish(deployTarget);
    }

    protected void prepareDeploymentFiles(File jar) throws IOException {
        File parent = new File(this.stagingDirectoryPath);
        parent.mkdirs();
        Files.copy((File)jar, (File)new File(parent, "app.jar"));
    }

    protected File getJarFile() {
        String jarFilePath = StringUtils.isNotEmpty((CharSequence)this.jarFile) ? this.jarFile : this.project.getArtifactFile().toString();
        return new File(jarFilePath);
    }

    protected void assureJarFileExisted(File jar) throws AzureExecutionException {
        if (!Files.getFileExtension((String)jar.getName()).equalsIgnoreCase("jar")) {
            throw new AzureExecutionException(FILE_IS_NOT_JAR);
        }
        if (!jar.exists() || !jar.isFile()) {
            throw new AzureExecutionException(String.format(FIND_JAR_FILE_FAIL, jar.getAbsolutePath()));
        }
    }

    public static class Builder
    extends ZIPArtifactHandlerImpl.Builder {
        private String jarFile;

        protected Builder self() {
            return this;
        }

        public JarArtifactHandlerImpl build() {
            return new JarArtifactHandlerImpl(this);
        }

        public Builder jarFile(String value) {
            this.jarFile = value;
            return this.self();
        }
    }
}

