/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.common.appservice.ConfigurationSourceType;
import com.microsoft.azure.common.appservice.DeploymentSlotSetting;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DeploymentSlotHandler {
    private static final String INVALID_SLOT_SETTINGS = "No <deploymentSlot> is specified in pom.xml. Please configure it for slot deployment.";
    private static final String SLOT_NAME_PATTERN = "[A-Za-z0-9-]{1,60}";
    private static final String INVALID_SLOT_NAME = String.format("Invalid value of <name> inside <deploymentSlot> in pom.xml, it needs to match the pattern '%s'", "[A-Za-z0-9-]{1,60}");
    private static final String EMPTY_CONFIGURATION_SOURCE = "Creating a new deployment slot without any configuration...";
    private static final String DEFAULT_CONFIGURATION_SOURCE = "Creating a new deployment slot and copying configuration from parent...";
    private static final String COPY_CONFIGURATION_FROM_SLOT = "Creating a new deployment slot and copying configuration from slot '%s'...";
    private static final String UNKNOWN_CONFIGURATION_SOURCE = "Unknown <configurationSource> value for creating deployment slot. Please use 'NEW', 'PARENT' or specify an existing slot.";
    private static final String TARGET_CONFIGURATION_SOURCE_SLOT_NOT_EXIST = "The deployment slot specified in <configurationSource> does not exist.";
    private AbstractWebAppMojo mojo;

    public DeploymentSlotHandler(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    public void createDeploymentSlotIfNotExist() throws AzureExecutionException, AzureAuthFailureException {
        DeploymentSlotSetting slotSetting = this.mojo.getDeploymentSlotSetting();
        this.assureValidSlotSetting(slotSetting);
        WebApp app = this.mojo.getWebApp();
        String slotName = slotSetting.getName();
        if (this.mojo.getDeploymentSlot(app, slotName) == null) {
            this.createDeploymentSlot(app, slotName, slotSetting.getConfigurationSource());
        }
    }

    protected void createDeploymentSlot(WebApp app, String slotName, String configurationSource) throws AzureExecutionException {
        this.assureValidSlotName(slotName);
        DeploymentSlot.DefinitionStages.Blank definedSlot = (DeploymentSlot.DefinitionStages.Blank)app.deploymentSlots().define(slotName);
        ConfigurationSourceType type = ConfigurationSourceType.fromString((String)configurationSource);
        switch (type) {
            case NEW: {
                Log.info((String)EMPTY_CONFIGURATION_SOURCE);
                definedSlot.withBrandNewConfiguration().create();
                break;
            }
            case PARENT: {
                Log.info((String)DEFAULT_CONFIGURATION_SOURCE);
                definedSlot.withConfigurationFromParent().create();
                break;
            }
            case OTHERS: {
                DeploymentSlot configurationSourceSlot = this.mojo.getDeploymentSlot(app, configurationSource);
                if (configurationSourceSlot == null) {
                    throw new AzureExecutionException(TARGET_CONFIGURATION_SOURCE_SLOT_NOT_EXIST);
                }
                Log.info((String)String.format(COPY_CONFIGURATION_FROM_SLOT, configurationSource));
                definedSlot.withConfigurationFromDeploymentSlot(configurationSourceSlot).create();
                break;
            }
            default: {
                throw new AzureExecutionException(UNKNOWN_CONFIGURATION_SOURCE);
            }
        }
    }

    protected void assureValidSlotSetting(DeploymentSlotSetting slotSetting) throws AzureExecutionException {
        if (slotSetting == null) {
            throw new AzureExecutionException(INVALID_SLOT_SETTINGS);
        }
    }

    protected void assureValidSlotName(String slotName) throws AzureExecutionException {
        Pattern pattern = Pattern.compile(SLOT_NAME_PATTERN, 2);
        if (StringUtils.isEmpty((CharSequence)slotName) || !pattern.matcher(slotName).matches()) {
            throw new AzureExecutionException(INVALID_SLOT_NAME);
        }
    }
}

