/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.google.common.io.Files;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.handlers.ArtifactHandler;
import java.io.File;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class WarArtifactHandlerImpl
implements ArtifactHandler {
    public static final String FILE_IS_NOT_WAR = "The deployment file is not a war typed file.";
    public static final String FIND_WAR_FILE_FAIL = "Failed to find the war file: '%s'";
    public static final int DEFAULT_MAX_RETRY_TIMES = 3;
    public static final String UPLOAD_FAILURE = "Failed to deploy the war file to server, retrying immediately (%d/%d)";
    private AbstractWebAppMojo mojo;

    public WarArtifactHandlerImpl(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    @Override
    public void publish() throws Exception {
        File war = this.getWarFile();
        this.assureWarFileExisted(war);
        String path = this.getContextPath();
        WebApp app = this.mojo.getWebApp();
        int retryCount = 0;
        this.mojo.getLog().info((CharSequence)"Starting to deploy the war file...");
        while (retryCount++ < 3) {
            try {
                app.warDeploy(war, path);
                return;
            }
            catch (Exception e) {
                this.mojo.getLog().warn((CharSequence)String.format(UPLOAD_FAILURE, retryCount, 3));
            }
        }
    }

    protected String getContextPath() {
        String path = this.mojo.getPath().trim();
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    protected File getWarFile() {
        return StringUtils.isNotEmpty((String)this.mojo.getWarFile()) ? new File(this.mojo.getWarFile()) : new File(Paths.get(this.mojo.getBuildDirectoryAbsolutePath(), this.mojo.getProject().getBuild().getFinalName() + ".war").toString());
    }

    protected void assureWarFileExisted(File war) throws MojoExecutionException {
        if (!Files.getFileExtension((String)war.getName()).equalsIgnoreCase("war")) {
            throw new MojoExecutionException(FILE_IS_NOT_WAR);
        }
        if (!war.exists() || !war.isFile()) {
            throw new MojoExecutionException(String.format(FIND_WAR_FILE_FAIL, war.getAbsolutePath()));
        }
    }
}

