/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppUtils;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.handlers.RuntimeHandler;

public class PublicDockerHubRuntimeHandlerImpl
implements RuntimeHandler {
    private AbstractWebAppMojo mojo;

    public PublicDockerHubRuntimeHandlerImpl(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    @Override
    public WebApp.DefinitionStages.WithCreate defineAppWithRuntime() throws Exception {
        AppServicePlan plan = WebAppUtils.createOrGetAppServicePlan(this.mojo, OperatingSystem.LINUX);
        return WebAppUtils.defineLinuxApp(this.mojo, plan).withPublicDockerHubImage(this.mojo.getContainerSettings().getImageName());
    }

    @Override
    public WebApp.Update updateAppRuntime(WebApp app) throws Exception {
        WebAppUtils.assureLinuxWebApp(app);
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        return ((WebApp.Update)app.update()).withPublicDockerHubImage(containerSetting.getImageName());
    }
}

