/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.Utils;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppUtils;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.handlers.RuntimeHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

public class PrivateDockerHubRuntimeHandlerImpl
implements RuntimeHandler {
    public static final String SERVER_ID_NOT_FOUND = "Server Id not found in settings.xml. ServerId=";
    private AbstractWebAppMojo mojo;

    public PrivateDockerHubRuntimeHandlerImpl(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    @Override
    public WebApp.DefinitionStages.WithCreate defineAppWithRuntime() throws Exception {
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        Server server = Utils.getServer((Settings)this.mojo.getSettings(), (String)containerSetting.getServerId());
        if (server == null) {
            throw new MojoExecutionException(SERVER_ID_NOT_FOUND + containerSetting.getServerId());
        }
        AppServicePlan plan = WebAppUtils.createOrGetAppServicePlan(this.mojo, OperatingSystem.LINUX);
        return WebAppUtils.defineLinuxApp(this.mojo, plan).withPrivateDockerHubImage(containerSetting.getImageName()).withCredentials(server.getUsername(), server.getPassword());
    }

    @Override
    public WebApp.Update updateAppRuntime(WebApp app) throws Exception {
        WebAppUtils.assureLinuxWebApp(app);
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        Server server = Utils.getServer((Settings)this.mojo.getSettings(), (String)containerSetting.getServerId());
        if (server == null) {
            throw new MojoExecutionException(SERVER_ID_NOT_FOUND + containerSetting.getServerId());
        }
        return ((WebApp.Update)app.update()).withPrivateDockerHubImage(containerSetting.getImageName()).withCredentials(server.getUsername(), server.getPassword());
    }
}

