/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.configuration.DockerImageType;
import java.util.UUID;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class WebAppUtils {
    public static final String CONTAINER_SETTING_NOT_APPLICABLE = "<containerSettings> is not applicable to Web App on Windows; please use <javaVersion> and <javaWebContainer> to configure your runtime.";
    public static final String JAVA_VERSION_NOT_APPLICABLE = "<javaVersion> is not applicable to Web App on Linux; please use <containerSettings> to specify your runtime.";
    public static final String NOT_SUPPORTED_IMAGE = "The image: '%s' is not supported.";
    public static final String IMAGE_NOT_GIVEN = "Image name is not specified.";
    public static final String SERVICE_PLAN_NOT_APPLICABLE = "The App Service Plan '%s' is not a %s Plan";
    public static final String CREATE_SERVICE_PLAN = "Creating App Service Plan '%s'...";
    public static final String SERVICE_PLAN_EXIST = "Found existing App Service Plan '%s' in Resource Group '%s'.";
    public static final String SERVICE_PLAN_CREATED = "Successfully created App Service Plan.";

    private static boolean isLinuxWebApp(WebApp app) {
        return ((SiteInner)app.inner()).kind().contains("linux");
    }

    public static void assureLinuxWebApp(WebApp app) throws MojoExecutionException {
        if (!WebAppUtils.isLinuxWebApp(app)) {
            throw new MojoExecutionException(CONTAINER_SETTING_NOT_APPLICABLE);
        }
    }

    public static void assureWindowsWebApp(WebApp app) throws MojoExecutionException {
        if (WebAppUtils.isLinuxWebApp(app)) {
            throw new MojoExecutionException(JAVA_VERSION_NOT_APPLICABLE);
        }
    }

    public static WebApp.DefinitionStages.WithDockerContainerImage defineLinuxApp(AbstractWebAppMojo mojo, AppServicePlan plan) throws Exception {
        WebAppUtils.assureLinuxPlan(plan);
        String resourceGroup = mojo.getResourceGroup();
        WebApp.DefinitionStages.ExistingLinuxPlanWithGroup existingLinuxPlanWithGroup = ((WebApp.DefinitionStages.Blank)mojo.getAzureClient().webApps().define(mojo.getAppName())).withExistingLinuxPlan(plan);
        return mojo.getAzureClient().resourceGroups().contain(resourceGroup) ? existingLinuxPlanWithGroup.withExistingResourceGroup(resourceGroup) : existingLinuxPlanWithGroup.withNewResourceGroup(resourceGroup);
    }

    private static void assureLinuxPlan(AppServicePlan plan) throws MojoExecutionException {
        if (!plan.operatingSystem().equals((Object)OperatingSystem.LINUX)) {
            throw new MojoExecutionException(String.format(SERVICE_PLAN_NOT_APPLICABLE, plan.name(), OperatingSystem.LINUX.name()));
        }
    }

    public static WebApp.DefinitionStages.WithCreate defineWindowsApp(AbstractWebAppMojo mojo, AppServicePlan plan) throws Exception {
        WebAppUtils.assureWindowsPlan(plan);
        String resourceGroup = mojo.getResourceGroup();
        WebApp.DefinitionStages.ExistingWindowsPlanWithGroup existingWindowsPlanWithGroup = ((WebApp.DefinitionStages.Blank)mojo.getAzureClient().webApps().define(mojo.getAppName())).withExistingWindowsPlan(plan);
        return mojo.getAzureClient().resourceGroups().contain(resourceGroup) ? existingWindowsPlanWithGroup.withExistingResourceGroup(resourceGroup) : existingWindowsPlanWithGroup.withNewResourceGroup(resourceGroup);
    }

    private static void assureWindowsPlan(AppServicePlan plan) throws MojoExecutionException {
        if (!plan.operatingSystem().equals((Object)OperatingSystem.WINDOWS)) {
            throw new MojoExecutionException(String.format(SERVICE_PLAN_NOT_APPLICABLE, plan.name(), OperatingSystem.WINDOWS.name()));
        }
    }

    public static AppServicePlan createOrGetAppServicePlan(AbstractWebAppMojo mojo, OperatingSystem os) throws Exception {
        AppServicePlan plan = null;
        String servicePlanResGrp = StringUtils.isNotEmpty((String)mojo.getAppServicePlanResourceGroup()) ? mojo.getAppServicePlanResourceGroup() : mojo.getResourceGroup();
        String servicePlanName = mojo.getAppServicePlanName();
        if (StringUtils.isNotEmpty((String)servicePlanName)) {
            plan = (AppServicePlan)mojo.getAzureClient().appServices().appServicePlans().getByResourceGroup(servicePlanResGrp, servicePlanName);
        } else {
            servicePlanName = WebAppUtils.generateRandomServicePlanName();
        }
        Azure azure = mojo.getAzureClient();
        if (plan == null) {
            mojo.getLog().info((CharSequence)String.format(CREATE_SERVICE_PLAN, servicePlanName));
            AppServicePlan.DefinitionStages.WithGroup withGroup = (AppServicePlan.DefinitionStages.WithGroup)((AppServicePlan.DefinitionStages.Blank)azure.appServices().appServicePlans().define(servicePlanName)).withRegion(mojo.getRegion());
            AppServicePlan.DefinitionStages.WithPricingTier withPricingTier = azure.resourceGroups().contain(servicePlanResGrp) ? (AppServicePlan.DefinitionStages.WithPricingTier)withGroup.withExistingResourceGroup(servicePlanResGrp) : (AppServicePlan.DefinitionStages.WithPricingTier)withGroup.withNewResourceGroup(servicePlanResGrp);
            plan = (AppServicePlan)withPricingTier.withPricingTier(mojo.getPricingTier()).withOperatingSystem(os).create();
            mojo.getLog().info((CharSequence)SERVICE_PLAN_CREATED);
        } else {
            mojo.getLog().info((CharSequence)String.format(SERVICE_PLAN_EXIST, servicePlanName, servicePlanResGrp));
        }
        return plan;
    }

    private static String generateRandomServicePlanName() {
        return "ServicePlan" + UUID.randomUUID().toString().substring(0, 18);
    }

    public static DockerImageType getDockerImageType(ContainerSetting containerSetting) {
        if (containerSetting == null || StringUtils.isEmpty((String)containerSetting.getImageName())) {
            return DockerImageType.NONE;
        }
        boolean isCustomRegistry = StringUtils.isNotEmpty((String)containerSetting.getRegistryUrl());
        boolean isPrivate = StringUtils.isNotEmpty((String)containerSetting.getServerId());
        if (isCustomRegistry) {
            return isPrivate ? DockerImageType.PRIVATE_REGISTRY : DockerImageType.UNKNOWN;
        }
        return isPrivate ? DockerImageType.PRIVATE_DOCKER_HUB : DockerImageType.PUBLIC_DOCKER_HUB;
    }

    public static RuntimeStack getLinuxRunTimeStack(String imageName) throws MojoExecutionException {
        if (StringUtils.isNotEmpty((String)imageName)) {
            if (imageName.equalsIgnoreCase(RuntimeStack.TOMCAT_8_5_JRE8.toString())) {
                return RuntimeStack.TOMCAT_8_5_JRE8;
            }
            if (imageName.equalsIgnoreCase(RuntimeStack.TOMCAT_9_0_JRE8.toString())) {
                return RuntimeStack.TOMCAT_9_0_JRE8;
            }
            throw new MojoExecutionException(String.format(NOT_SUPPORTED_IMAGE, imageName));
        }
        throw new MojoExecutionException(IMAGE_NOT_GIVEN);
    }
}

