/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppUtils;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.configuration.DockerImageType;
import com.microsoft.azure.maven.webapp.handlers.ArtifactHandler;
import com.microsoft.azure.maven.webapp.handlers.FTPArtifactHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.HandlerFactory;
import com.microsoft.azure.maven.webapp.handlers.JavaRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.LinuxRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.NullRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.PrivateDockerHubRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.PrivateRegistryRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.PublicDockerHubRuntimeHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.RuntimeHandler;
import com.microsoft.azure.maven.webapp.handlers.SettingsHandler;
import com.microsoft.azure.maven.webapp.handlers.SettingsHandlerImpl;
import com.microsoft.azure.maven.webapp.handlers.WarArtifactHandlerImpl;
import org.apache.maven.plugin.MojoExecutionException;

public class HandlerFactoryImpl
extends HandlerFactory {
    public static final String RUNTIME_CONFIG_CONFLICT = "Conflict settings found. <javaVersion>, <linuxRuntime>and <containerSettings> should not be set at the same time.";
    public static final String NO_RUNTIME_HANDLER = "Not able to process the runtime stack configuration; please check <javaVersion>, <linuxRuntime> or <containerSettings> tag in pom.xml";
    public static final String IMAGE_NAME_MISSING = "<imageName> not found within <containerSettings> tag.";
    public static final String DEPLOYMENT_TYPE_NOT_FOUND = "<deploymentType> is not configured.";
    public static final String UNKNOWN_DEPLOYMENT_TYPE = "Unknown value from <deploymentType> tag.";

    @Override
    public RuntimeHandler getRuntimeHandler(AbstractWebAppMojo mojo) throws MojoExecutionException {
        JavaVersion javaVersion = mojo.getJavaVersion();
        String linuxRuntime = mojo.getLinuxRuntime();
        ContainerSetting containerSetting = mojo.getContainerSettings();
        if (javaVersion == null && linuxRuntime == null && this.isContainerSettingEmpty(containerSetting)) {
            return new NullRuntimeHandlerImpl();
        }
        if (this.isDuplicatedRuntimeDefined(javaVersion, linuxRuntime, containerSetting)) {
            throw new MojoExecutionException(RUNTIME_CONFIG_CONFLICT);
        }
        if (javaVersion != null) {
            return new JavaRuntimeHandlerImpl(mojo);
        }
        if (linuxRuntime != null) {
            return new LinuxRuntimeHandlerImpl(mojo);
        }
        DockerImageType imageType = WebAppUtils.getDockerImageType(containerSetting);
        switch (imageType) {
            case PUBLIC_DOCKER_HUB: {
                return new PublicDockerHubRuntimeHandlerImpl(mojo);
            }
            case PRIVATE_DOCKER_HUB: {
                return new PrivateDockerHubRuntimeHandlerImpl(mojo);
            }
            case PRIVATE_REGISTRY: {
                return new PrivateRegistryRuntimeHandlerImpl(mojo);
            }
            case NONE: {
                throw new MojoExecutionException(IMAGE_NAME_MISSING);
            }
        }
        throw new MojoExecutionException(NO_RUNTIME_HANDLER);
    }

    @Override
    public SettingsHandler getSettingsHandler(AbstractWebAppMojo mojo) {
        return new SettingsHandlerImpl(mojo);
    }

    @Override
    public ArtifactHandler getArtifactHandler(AbstractWebAppMojo mojo) throws MojoExecutionException {
        switch (mojo.getDeploymentType()) {
            case NONE: {
                throw new MojoExecutionException(DEPLOYMENT_TYPE_NOT_FOUND);
            }
            case UNKNOWN: {
                throw new MojoExecutionException(UNKNOWN_DEPLOYMENT_TYPE);
            }
            case FTP: {
                return new FTPArtifactHandlerImpl(mojo);
            }
        }
        return new WarArtifactHandlerImpl(mojo);
    }

    private boolean isDuplicatedRuntimeDefined(JavaVersion javaVersion, String linuxRuntime, ContainerSetting containerSetting) {
        return javaVersion != null ? linuxRuntime != null || !this.isContainerSettingEmpty(containerSetting) : linuxRuntime != null && !this.isContainerSettingEmpty(containerSetting);
    }

    private boolean isContainerSettingEmpty(ContainerSetting containerSetting) {
        return containerSetting == null || containerSetting.isEmpty();
    }
}

